/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.mapr.tools;

import com.mapr.fs.MapRFileAce;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.mapr.tools.KafkaMaprTools;

public class MaprfsPermissions {
    public static final String STARTUP_USER = "<startup.user>";
    public static final String CLUSTER_ADMIN = "<cluster.admin>";
    public static final String PUBLIC = "p";
    private final Map<MapRFileAce.AccessType, String> aces = new HashMap<MapRFileAce.AccessType, String>();

    private MaprfsPermissions() {
    }

    public static MaprfsPermissions permissions() {
        return new MaprfsPermissions();
    }

    public MaprfsPermissions loadFromConfig(String configurationValue) {
        for (String entry : StringUtils.split((String)configurationValue.trim(), (char)';')) {
            String trimmed = entry.trim();
            this.put(MaprfsPermissions.parseAceKey(trimmed), MaprfsPermissions.parseAceValue(trimmed));
        }
        return this;
    }

    public MaprfsPermissions put(MapRFileAce.AccessType permission, String value) {
        this.aces.put(permission, MaprfsPermissions.substituteExpression(value));
        return this;
    }

    public List<MapRFileAce> buildAceList() {
        return this.aces.entrySet().stream().map(entry -> MaprfsPermissions.createFileAce((MapRFileAce.AccessType)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    private static MapRFileAce.AccessType parseAceKey(String line) {
        String key = StringUtils.substringBefore((String)line, (String)"=");
        return MapRFileAce.AccessType.valueOf((String)key.toUpperCase());
    }

    private static String parseAceValue(String line) {
        return StringUtils.substringAfter((String)line, (String)"=");
    }

    private static String substituteExpression(String expression) {
        if (expression.contains(STARTUP_USER)) {
            expression = expression.replaceAll(STARTUP_USER, "u:" + KafkaMaprTools.tools().getCurrentUserName());
        }
        if (expression.contains(CLUSTER_ADMIN)) {
            expression = expression.replaceAll(CLUSTER_ADMIN, "u:" + KafkaMaprTools.tools().getClusterAdminUserName());
        }
        return expression;
    }

    private static MapRFileAce createFileAce(MapRFileAce.AccessType type, String expression) {
        try {
            MapRFileAce ace = new MapRFileAce(type);
            ace.setBooleanExpression(expression);
            return ace;
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaprfsPermissions that = (MaprfsPermissions)o;
        return Objects.equals(this.aces, that.aces);
    }

    public int hashCode() {
        return Objects.hash(this.aces);
    }
}

