/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.tools.DelegationTokenCommand;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DelegationTokenCommandTest {
    @Test
    public void testDelegationTokenRequests() throws ExecutionException, InterruptedException {
        MockAdminClient adminClient = new MockAdminClient.Builder().build();
        String renewer1 = "User:renewer1";
        String renewer2 = "User:renewer2";
        DelegationToken tokenCreated = DelegationTokenCommand.createToken((Admin)adminClient, (DelegationTokenCommand.DelegationTokenCommandOptions)this.getCreateOpts(renewer1));
        List tokens = DelegationTokenCommand.describeToken((Admin)adminClient, (DelegationTokenCommand.DelegationTokenCommandOptions)this.getDescribeOpts(""));
        Assertions.assertEquals((int)1, (int)tokens.size());
        DelegationToken token1 = (DelegationToken)tokens.get(0);
        Assertions.assertEquals((Object)token1, (Object)tokenCreated);
        DelegationToken token2 = DelegationTokenCommand.createToken((Admin)adminClient, (DelegationTokenCommand.DelegationTokenCommandOptions)this.getCreateOpts(renewer2));
        tokens = DelegationTokenCommand.describeToken((Admin)adminClient, (DelegationTokenCommand.DelegationTokenCommandOptions)this.getDescribeOpts(""));
        Assertions.assertEquals((int)2, (int)tokens.size());
        Assertions.assertEquals(Arrays.asList(token1, token2), (Object)tokens);
        tokens = DelegationTokenCommand.describeToken((Admin)adminClient, (DelegationTokenCommand.DelegationTokenCommandOptions)this.getDescribeOpts(renewer2));
        Assertions.assertEquals((int)1, (int)tokens.size());
        Assertions.assertEquals(Collections.singletonList(token2), (Object)tokens);
        Long expiryTimestamp = DelegationTokenCommand.renewToken((Admin)adminClient, (DelegationTokenCommand.DelegationTokenCommandOptions)this.getRenewOpts(token1.hmacAsBase64String()));
        DelegationToken renewedToken = (DelegationToken)DelegationTokenCommand.describeToken((Admin)adminClient, (DelegationTokenCommand.DelegationTokenCommandOptions)this.getDescribeOpts(renewer1)).get(0);
        Assertions.assertEquals((Long)expiryTimestamp, (long)renewedToken.tokenInfo().expiryTimestamp());
        DelegationTokenCommand.expireToken((Admin)adminClient, (DelegationTokenCommand.DelegationTokenCommandOptions)this.getExpireOpts(token1.hmacAsBase64String()));
        DelegationTokenCommand.expireToken((Admin)adminClient, (DelegationTokenCommand.DelegationTokenCommandOptions)this.getExpireOpts(token2.hmacAsBase64String()));
        tokens = DelegationTokenCommand.describeToken((Admin)adminClient, (DelegationTokenCommand.DelegationTokenCommandOptions)this.getDescribeOpts(""));
        Assertions.assertEquals((int)0, (int)tokens.size());
        Assertions.assertThrows(ExecutionException.class, () -> this.lambda$testDelegationTokenRequests$0((Admin)adminClient));
        Assertions.assertTrue((boolean)DelegationTokenCommand.describeToken((Admin)adminClient, (DelegationTokenCommand.DelegationTokenCommandOptions)this.getDescribeOpts("User:Unknown")).isEmpty());
    }

    private DelegationTokenCommand.DelegationTokenCommandOptions getCreateOpts(String renewer) {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--max-life-time-period", "-1", "--command-config", "testfile", "--create", "--renewer-principal", renewer};
        return new DelegationTokenCommand.DelegationTokenCommandOptions(args);
    }

    private DelegationTokenCommand.DelegationTokenCommandOptions getDescribeOpts(String owner) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--bootstrap-server");
        args.add("localhost:9092");
        args.add("--command-config");
        args.add("testfile");
        args.add("--describe");
        if (!owner.equals("")) {
            args.add("--owner-principal");
            args.add(owner);
        }
        return new DelegationTokenCommand.DelegationTokenCommandOptions(args.toArray(new String[0]));
    }

    private DelegationTokenCommand.DelegationTokenCommandOptions getRenewOpts(String hmac) {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--command-config", "testfile", "--renew", "--renew-time-period", "604800000", "--hmac", hmac};
        return new DelegationTokenCommand.DelegationTokenCommandOptions(args);
    }

    private DelegationTokenCommand.DelegationTokenCommandOptions getExpireOpts(String hmac) {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--command-config", "testfile", "--expire", "--expiry-time-period", "-1", "--hmac", hmac};
        return new DelegationTokenCommand.DelegationTokenCommandOptions(args);
    }

    private /* synthetic */ void lambda$testDelegationTokenRequests$0(Admin adminClient) throws Throwable {
        DelegationTokenCommand.createToken((Admin)adminClient, (DelegationTokenCommand.DelegationTokenCommandOptions)this.getCreateOpts("Group:Renewer3"));
    }
}

