/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.common.AdminOperationException;
import org.apache.kafka.tools.DeleteRecordsCommand;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DeleteRecordsCommandUnitTest {
    DeleteRecordsCommandUnitTest() {
    }

    @Test
    public void testOffsetFileNotExists() {
        Assertions.assertThrows(IOException.class, () -> DeleteRecordsCommand.main((String[])new String[]{"--bootstrap-server", "localhost:9092", "--offset-json-file", "/not/existing/file"}));
    }

    @Test
    public void testCommandConfigNotExists() {
        Assertions.assertThrows(NoSuchFileException.class, () -> DeleteRecordsCommand.main((String[])new String[]{"--bootstrap-server", "localhost:9092", "--offset-json-file", "/not/existing/file", "--command-config", "/another/not/existing/file"}));
    }

    @Test
    public void testWrongVersion() {
        DeleteRecordsCommandUnitTest.assertCommandThrows(JsonProcessingException.class, "{\"version\":\"string\"}");
        DeleteRecordsCommandUnitTest.assertCommandThrows(AdminOperationException.class, "{\"version\":2}");
    }

    @Test
    public void testWrongPartitions() {
        DeleteRecordsCommandUnitTest.assertCommandThrows(AdminOperationException.class, "{\"version\":1}");
        DeleteRecordsCommandUnitTest.assertCommandThrows(JsonProcessingException.class, "{\"partitions\":2}");
        DeleteRecordsCommandUnitTest.assertCommandThrows(JsonProcessingException.class, "{\"partitions\":{}}");
        DeleteRecordsCommandUnitTest.assertCommandThrows(JsonProcessingException.class, "{\"partitions\":[{}]}");
        DeleteRecordsCommandUnitTest.assertCommandThrows(JsonProcessingException.class, "{\"partitions\":[{\"topic\":\"t\"}]}");
        DeleteRecordsCommandUnitTest.assertCommandThrows(JsonProcessingException.class, "{\"partitions\":[{\"topic\":\"t\", \"partition\": \"\"}]}");
        DeleteRecordsCommandUnitTest.assertCommandThrows(JsonProcessingException.class, "{\"partitions\":[{\"topic\":\"t\", \"partition\": 0}]}");
        DeleteRecordsCommandUnitTest.assertCommandThrows(JsonProcessingException.class, "{\"partitions\":[{\"topic\":\"t\", \"offset\":0}]}");
    }

    @Test
    public void testParse() throws Exception {
        Map res = DeleteRecordsCommand.parseOffsetJsonStringWithoutDedup((String)"{\"partitions\":[{\"topic\":\"t\", \"partition\":0, \"offset\":0},{\"topic\":\"t\", \"partition\":1, \"offset\":1, \"ignored\":\"field\"},{\"topic\":\"t\", \"partition\":0, \"offset\":2},{\"topic\":\"t\", \"partition\":0, \"offset\":0}]}");
        Assertions.assertEquals((int)2, (int)res.size());
        Assertions.assertEquals(Arrays.asList(0L, 2L, 0L), res.get(new TopicPartition("t", 0)));
        Assertions.assertEquals(Collections.singletonList(1L), res.get(new TopicPartition("t", 1)));
    }

    private static void assertCommandThrows(Class<? extends Exception> expectedException, String jsonData) {
        Assertions.assertThrows(expectedException, () -> DeleteRecordsCommand.parseOffsetJsonStringWithoutDedup((String)jsonData));
    }
}

