/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.tools.LogDirsCommand;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogDirsCommandTest {
    @Test
    public void shouldThrowWhenQueryingNonExistentBrokers() {
        Node broker = new Node(1, "hostname", 9092);
        try (MockAdminClient adminClient = new MockAdminClient(Collections.singletonList(broker), broker);){
            Assertions.assertThrows(RuntimeException.class, () -> this.execute(this.fromArgsToOptions("--bootstrap-server", "EMPTY", "--broker-list", "0,1,2", "--describe"), (Admin)adminClient));
        }
    }

    @Test
    public void shouldNotThrowWhenDuplicatedBrokers() throws JsonProcessingException {
        Node broker = new Node(1, "hostname", 9092);
        try (MockAdminClient adminClient = new MockAdminClient(Collections.singletonList(broker), broker);){
            String standardOutput = this.execute(this.fromArgsToOptions("--bootstrap-server", "EMPTY", "--broker-list", "1,1", "--describe"), (Admin)adminClient);
            String[] standardOutputLines = standardOutput.split("\n");
            Assertions.assertEquals((int)3, (int)standardOutputLines.length);
            Map information = (Map)new ObjectMapper().readValue(standardOutputLines[2], HashMap.class);
            List brokersInformation = (List)information.get("brokers");
            Integer brokerId = (Integer)((HashMap)brokersInformation.get(0)).get("broker");
            Assertions.assertEquals((int)1, (int)brokersInformation.size());
            Assertions.assertEquals((int)1, (Integer)brokerId);
        }
    }

    @Test
    public void shouldQueryAllBrokersIfNonSpecified() throws JsonProcessingException {
        Node brokerOne = new Node(1, "hostname", 9092);
        Node brokerTwo = new Node(2, "hostname", 9092);
        try (MockAdminClient adminClient = new MockAdminClient(Arrays.asList(brokerTwo, brokerOne), brokerOne);){
            String standardOutput = this.execute(this.fromArgsToOptions("--bootstrap-server", "EMPTY", "--describe"), (Admin)adminClient);
            String[] standardOutputLines = standardOutput.split("\n");
            Assertions.assertEquals((int)3, (int)standardOutputLines.length);
            Map information = (Map)new ObjectMapper().readValue(standardOutputLines[2], HashMap.class);
            final List brokersInformation = (List)information.get("brokers");
            HashSet<Integer> brokerIds = new HashSet<Integer>(){
                {
                    this.add((Integer)((HashMap)brokersInformation.get(0)).get("broker"));
                    this.add((Integer)((HashMap)brokersInformation.get(1)).get("broker"));
                }
            };
            Assertions.assertEquals((int)2, (int)brokersInformation.size());
            Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(2, 1)), (Object)brokerIds);
        }
    }

    @Test
    public void shouldQuerySpecifiedBroker() throws JsonProcessingException {
        Node brokerOne = new Node(1, "hostname", 9092);
        Node brokerTwo = new Node(2, "hostname", 9092);
        try (MockAdminClient adminClient = new MockAdminClient(Arrays.asList(brokerOne, brokerTwo), brokerOne);){
            String standardOutput = this.execute(this.fromArgsToOptions("--bootstrap-server", "EMPTY", "--broker-list", "1", "--describe"), (Admin)adminClient);
            String[] standardOutputLines = standardOutput.split("\n");
            Assertions.assertEquals((int)3, (int)standardOutputLines.length);
            Map information = (Map)new ObjectMapper().readValue(standardOutputLines[2], HashMap.class);
            List brokersInformation = (List)information.get("brokers");
            Integer brokerId = (Integer)((HashMap)brokersInformation.get(0)).get("broker");
            Assertions.assertEquals((int)1, (int)brokersInformation.size());
            Assertions.assertEquals((int)1, (Integer)brokerId);
        }
    }

    private LogDirsCommand.LogDirsCommandOptions fromArgsToOptions(String ... args) {
        return new LogDirsCommand.LogDirsCommandOptions(args);
    }

    private String execute(LogDirsCommand.LogDirsCommandOptions options, Admin adminClient) {
        Runnable runnable = () -> {
            try {
                LogDirsCommand.execute((LogDirsCommand.LogDirsCommandOptions)options, (Admin)adminClient);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        return ToolsTestUtils.captureStandardOut(runnable);
    }
}

