/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.tools.FeatureCommand;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.KRAFT)
@Tag(value="integration")
public class FeatureCommandTest {
    private final ClusterInstance cluster;

    public FeatureCommandTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }

    @ClusterTest(clusterType=Type.ZK, metadataVersion=MetadataVersion.IBP_3_3_IV1)
    public void testDescribeWithZK() {
        String commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)0, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "describe"})));
        Assertions.assertEquals((Object)"", (Object)commandOutput);
    }

    @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_3_IV1)
    public void testDescribeWithKRaft() {
        String commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)0, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "describe"})));
        Assertions.assertEquals((Object)"Feature: metadata.version\tSupportedMinVersion: 3.0-IV1\tSupportedMaxVersion: 3.6-IV2\tFinalizedVersionLevel: 3.3-IV1\t", (Object)this.outputWithoutEpoch(commandOutput));
    }

    @ClusterTest(clusterType=Type.ZK, metadataVersion=MetadataVersion.IBP_3_3_IV1)
    public void testUpgradeMetadataVersionWithZk() {
        String commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)1, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "upgrade", "--metadata", "3.3-IV2"})));
        Assertions.assertEquals((Object)"Could not upgrade metadata.version to 6. Could not apply finalized feature update because the provided feature is not supported.", (Object)commandOutput);
    }

    @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_3_IV1)
    public void testUpgradeMetadataVersionWithKraft() {
        String commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)0, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "upgrade", "--feature", "metadata.version=5"})));
        Assertions.assertEquals((Object)"metadata.version was upgraded to 5.", (Object)commandOutput);
        commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)0, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "upgrade", "--metadata", "3.3-IV2"})));
        Assertions.assertEquals((Object)"metadata.version was upgraded to 6.", (Object)commandOutput);
    }

    @ClusterTest(clusterType=Type.ZK, metadataVersion=MetadataVersion.IBP_3_3_IV1)
    public void testDowngradeMetadataVersionWithZk() {
        String commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)1, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "disable", "--feature", "metadata.version"})));
        Assertions.assertEquals((Object)"Could not disable metadata.version. Can not delete non-existing finalized feature.", (Object)commandOutput);
        commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)1, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "downgrade", "--metadata", "3.3-IV0"})));
        Assertions.assertEquals((Object)"Could not downgrade metadata.version to 4. Could not apply finalized feature update because the provided feature is not supported.", (Object)commandOutput);
        commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)1, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "downgrade", "--unsafe", "--metadata", "3.3-IV0"})));
        Assertions.assertEquals((Object)"Could not downgrade metadata.version to 4. Could not apply finalized feature update because the provided feature is not supported.", (Object)commandOutput);
    }

    @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_3_IV1)
    public void testDowngradeMetadataVersionWithKRaft() {
        String commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)1, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "disable", "--feature", "metadata.version"})));
        Assertions.assertEquals((Object)"Could not disable metadata.version. Invalid update version 0 for feature metadata.version. Local controller 3000 only supports versions 1-14", (Object)commandOutput);
        commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)1, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "downgrade", "--metadata", "3.3-IV0"})));
        Assertions.assertEquals((Object)"Could not downgrade metadata.version to 4. Invalid metadata.version 4. Refusing to perform the requested downgrade because it might delete metadata information. Retry using UNSAFE_DOWNGRADE if you want to force the downgrade to proceed.", (Object)commandOutput);
        commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)1, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "downgrade", "--unsafe", "--metadata", "3.3-IV0"})));
        Assertions.assertEquals((Object)"Could not downgrade metadata.version to 4. Invalid metadata.version 4. Unsafe metadata downgrade is not supported in this version.", (Object)commandOutput);
    }

    private String outputWithoutEpoch(String output) {
        int pos = output.indexOf("Epoch: ");
        return pos > 0 ? output.substring(0, pos) : output;
    }
}

