/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Properties;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.server.common.AdminCommandFailedException;
import org.apache.kafka.tools.DeleteRecordsCommand;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.ALL)
@Tag(value="integration")
public class DeleteRecordsCommandTest {
    private final ClusterInstance cluster;

    public DeleteRecordsCommandTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }

    @ClusterTest
    public void testCommand() throws Exception {
        Properties adminProps = new Properties();
        adminProps.put("retries", (Object)1);
        try (Admin admin = this.cluster.createAdminClient(adminProps);){
            Assertions.assertThrows(AdminCommandFailedException.class, () -> DeleteRecordsCommand.execute((Admin)admin, (String)"{\"partitions\":[{\"topic\":\"t\", \"partition\":0, \"offset\":1},{\"topic\":\"t\", \"partition\":0, \"offset\":1}]}", (PrintStream)System.out), (String)"Offset json file contains duplicate topic partitions: t-0");
            admin.createTopics(Collections.singleton(new NewTopic("t", 1, 1))).all().get();
            Properties props = new Properties();
            props.put("bootstrap.servers", this.cluster.bootstrapServers());
            props.put("key.serializer", StringSerializer.class);
            props.put("value.serializer", StringSerializer.class);
            try (KafkaProducer producer = new KafkaProducer(props);){
                producer.send(new ProducerRecord("t", (Object)"1")).get();
                producer.send(new ProducerRecord("t", (Object)"2")).get();
                producer.send(new ProducerRecord("t", (Object)"3")).get();
            }
            DeleteRecordsCommandTest.executeAndAssertOutput("{\"partitions\":[{\"topic\":\"t\", \"partition\":0, \"offset\":1}]}", "partition: t-0\tlow_watermark: 1", admin);
            DeleteRecordsCommandTest.executeAndAssertOutput("{\"partitions\":[{\"topic\":\"t\", \"partition\":42, \"offset\":42}]}", "partition: t-42\terror", admin);
        }
    }

    private static void executeAndAssertOutput(String json, String expOut, Admin admin) {
        String output = ToolsTestUtils.captureStandardOut(() -> {
            try {
                DeleteRecordsCommand.execute((Admin)admin, (String)json, (PrintStream)System.out);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        Assertions.assertTrue((boolean)output.contains(expOut));
    }
}

