/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.TaskMetadata;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.TaskMetadataImpl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class TaskMetadataImplTest {
    public static final TaskId TASK_ID = new TaskId(1, 2);
    public static final TopicPartition TP_0 = new TopicPartition("t", 0);
    public static final TopicPartition TP_1 = new TopicPartition("t", 1);
    public static final Set<TopicPartition> TOPIC_PARTITIONS = Utils.mkSet((Object[])new TopicPartition[]{TP_0, TP_1});
    public static final Map<TopicPartition, Long> COMMITTED_OFFSETS = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)TP_1, (Object)1L), Utils.mkEntry((Object)TP_1, (Object)2L)});
    public static final Map<TopicPartition, Long> END_OFFSETS = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)TP_1, (Object)1L), Utils.mkEntry((Object)TP_1, (Object)3L)});
    public static final Optional<Long> TIME_CURRENT_IDLING_STARTED = Optional.of(3L);
    private TaskMetadata taskMetadata;

    @Before
    public void setUp() {
        this.taskMetadata = new TaskMetadataImpl(TASK_ID, TOPIC_PARTITIONS, COMMITTED_OFFSETS, END_OFFSETS, TIME_CURRENT_IDLING_STARTED);
    }

    @Test
    public void shouldNotAllowModificationOfInternalStateViaGetters() {
        MatcherAssert.assertThat((Object)TaskMetadataImplTest.isUnmodifiable(this.taskMetadata.topicPartitions()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)TaskMetadataImplTest.isUnmodifiable(this.taskMetadata.committedOffsets()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)TaskMetadataImplTest.isUnmodifiable(this.taskMetadata.endOffsets()), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldBeEqualsIfSameObject() {
        TaskMetadataImpl same = new TaskMetadataImpl(TASK_ID, TOPIC_PARTITIONS, COMMITTED_OFFSETS, END_OFFSETS, TIME_CURRENT_IDLING_STARTED);
        MatcherAssert.assertThat((Object)this.taskMetadata, (Matcher)Matchers.equalTo((Object)same));
        MatcherAssert.assertThat((Object)this.taskMetadata.hashCode(), (Matcher)Matchers.equalTo((Object)same.hashCode()));
    }

    @Test
    public void shouldBeEqualsIfOnlyDifferInCommittedOffsets() {
        TaskMetadataImpl stillSameDifferCommittedOffsets = new TaskMetadataImpl(TASK_ID, TOPIC_PARTITIONS, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)TP_1, (Object)1000000L), Utils.mkEntry((Object)TP_1, (Object)2L)}), END_OFFSETS, TIME_CURRENT_IDLING_STARTED);
        MatcherAssert.assertThat((Object)this.taskMetadata, (Matcher)Matchers.equalTo((Object)stillSameDifferCommittedOffsets));
        MatcherAssert.assertThat((Object)this.taskMetadata.hashCode(), (Matcher)Matchers.equalTo((Object)stillSameDifferCommittedOffsets.hashCode()));
    }

    @Test
    public void shouldBeEqualsIfOnlyDifferInEndOffsets() {
        TaskMetadataImpl stillSameDifferEndOffsets = new TaskMetadataImpl(TASK_ID, TOPIC_PARTITIONS, COMMITTED_OFFSETS, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)TP_1, (Object)1000000L), Utils.mkEntry((Object)TP_1, (Object)2L)}), TIME_CURRENT_IDLING_STARTED);
        MatcherAssert.assertThat((Object)this.taskMetadata, (Matcher)Matchers.equalTo((Object)stillSameDifferEndOffsets));
        MatcherAssert.assertThat((Object)this.taskMetadata.hashCode(), (Matcher)Matchers.equalTo((Object)stillSameDifferEndOffsets.hashCode()));
    }

    @Test
    public void shouldBeEqualsIfOnlyDifferInIdlingTime() {
        TaskMetadataImpl stillSameDifferIdlingTime = new TaskMetadataImpl(TASK_ID, TOPIC_PARTITIONS, COMMITTED_OFFSETS, END_OFFSETS, Optional.empty());
        MatcherAssert.assertThat((Object)this.taskMetadata, (Matcher)Matchers.equalTo((Object)stillSameDifferIdlingTime));
        MatcherAssert.assertThat((Object)this.taskMetadata.hashCode(), (Matcher)Matchers.equalTo((Object)stillSameDifferIdlingTime.hashCode()));
    }

    @Test
    public void shouldNotBeEqualsIfDifferInTaskID() {
        TaskMetadataImpl differTaskId = new TaskMetadataImpl(new TaskId(1, 10000), TOPIC_PARTITIONS, COMMITTED_OFFSETS, END_OFFSETS, TIME_CURRENT_IDLING_STARTED);
        MatcherAssert.assertThat((Object)this.taskMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differTaskId)));
        MatcherAssert.assertThat((Object)this.taskMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differTaskId.hashCode())));
    }

    @Test
    public void shouldNotBeEqualsIfDifferInTopicPartitions() {
        TaskMetadataImpl differTopicPartitions = new TaskMetadataImpl(TASK_ID, Utils.mkSet((Object[])new TopicPartition[]{TP_0}), COMMITTED_OFFSETS, END_OFFSETS, TIME_CURRENT_IDLING_STARTED);
        MatcherAssert.assertThat((Object)this.taskMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differTopicPartitions)));
        MatcherAssert.assertThat((Object)this.taskMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differTopicPartitions.hashCode())));
    }

    private static boolean isUnmodifiable(Collection<?> collection) {
        try {
            collection.clear();
            return false;
        }
        catch (UnsupportedOperationException e) {
            return true;
        }
    }

    private static boolean isUnmodifiable(Map<?, ?> collection) {
        try {
            collection.clear();
            return false;
        }
        catch (UnsupportedOperationException e) {
            return true;
        }
    }
}

