/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.Repartitioned;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={IntegrationTest.class})
public class KStreamRepartitionIntegrationTest {
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)600L);
    private static final int NUM_BROKERS = 1;
    public static final EmbeddedKafkaCluster CLUSTER = new EmbeddedKafkaCluster(1);
    private String topicB;
    private String inputTopic;
    private String outputTopic;
    private String applicationId;
    private String safeTestName;
    private Properties streamsConfiguration;
    private List<KafkaStreams> kafkaStreamsInstances;
    @Parameterized.Parameter
    public String topologyOptimization;
    @Rule
    public TestName testName = new TestName();

    @BeforeClass
    public static void startCluster() throws IOException {
        CLUSTER.start();
    }

    @AfterClass
    public static void closeCluster() {
        CLUSTER.stop();
    }

    @Parameterized.Parameters(name="Optimization = {0}")
    public static Collection<?> topologyOptimization() {
        return Arrays.asList({"all"}, {"none"});
    }

    @Before
    public void before() throws InterruptedException {
        this.streamsConfiguration = new Properties();
        this.kafkaStreamsInstances = new ArrayList<KafkaStreams>();
        this.safeTestName = IntegrationTestUtils.safeUniqueTestName(this.getClass(), this.testName);
        this.topicB = "topic-b-" + this.safeTestName;
        this.inputTopic = "input-topic-" + this.safeTestName;
        this.outputTopic = "output-topic-" + this.safeTestName;
        this.applicationId = "app-" + this.safeTestName;
        CLUSTER.createTopic(this.inputTopic, 4, 1);
        CLUSTER.createTopic(this.outputTopic, 1, 1);
        this.streamsConfiguration.put("application.id", this.applicationId);
        this.streamsConfiguration.put("bootstrap.servers", CLUSTER.bootstrapServers());
        this.streamsConfiguration.put("state.dir", TestUtils.tempDirectory().getPath());
        this.streamsConfiguration.put("statestore.cache.max.bytes", (Object)0);
        this.streamsConfiguration.put("commit.interval.ms", (Object)100L);
        this.streamsConfiguration.put("default.key.serde", Serdes.Integer().getClass());
        this.streamsConfiguration.put("default.value.serde", Serdes.String().getClass());
        this.streamsConfiguration.put("topology.optimization", this.topologyOptimization);
    }

    @After
    public void whenShuttingDown() throws IOException {
        this.kafkaStreamsInstances.stream().filter(Objects::nonNull).forEach(KafkaStreams::close);
        IntegrationTestUtils.purgeLocalStreamsState(this.streamsConfiguration);
    }

    @Test
    public void shouldThrowAnExceptionWhenNumberOfPartitionsOfRepartitionOperationDoNotMatchSourceTopicWhenJoining() throws InterruptedException {
        int topicBNumberOfPartitions = 6;
        String inputTopicRepartitionName = "join-repartition-test";
        AtomicReference expectedThrowable = new AtomicReference();
        int inputTopicRepartitionedNumOfPartitions = 2;
        CLUSTER.createTopic(this.topicB, 6, 1);
        StreamsBuilder builder = new StreamsBuilder();
        Repartitioned inputTopicRepartitioned = Repartitioned.as((String)"join-repartition-test").withNumberOfPartitions(2);
        KStream topicBStream = builder.stream(this.topicB, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        builder.stream(this.inputTopic, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).repartition(inputTopicRepartitioned).join(topicBStream, (value1, value2) -> value2, JoinWindows.of((Duration)Duration.ofSeconds(10L))).to(this.outputTopic);
        builder.build(this.streamsConfiguration);
        this.startStreams(builder, KafkaStreams.State.REBALANCING, KafkaStreams.State.ERROR, (t, e) -> expectedThrowable.set(e));
        String expectedMsg = String.format("Number of partitions [%s] of repartition topic [%s] doesn't match number of partitions [%s] of the source topic.", 2, this.toRepartitionTopicName("join-repartition-test"), 6);
        Assert.assertNotNull(expectedThrowable.get());
        Assert.assertTrue((boolean)((Throwable)expectedThrowable.get()).getMessage().contains(expectedMsg));
    }

    @Test
    public void shouldDeductNumberOfPartitionsFromRepartitionOperation() throws Exception {
        String topicBMapperName = "topic-b-mapper";
        int topicBNumberOfPartitions = 6;
        String inputTopicRepartitionName = "join-repartition-test";
        int inputTopicRepartitionedNumOfPartitions = 3;
        long timestamp = System.currentTimeMillis();
        CLUSTER.createTopic(this.topicB, 6, 1);
        List expectedRecords = Arrays.asList(new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)2, (Object)"B"));
        this.sendEvents(timestamp, expectedRecords);
        this.sendEvents(this.topicB, timestamp, expectedRecords);
        StreamsBuilder builder = new StreamsBuilder();
        Repartitioned inputTopicRepartitioned = Repartitioned.as((String)"join-repartition-test").withNumberOfPartitions(3);
        KStream topicBStream = builder.stream(this.topicB, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).map(KeyValue::new, Named.as((String)"topic-b-mapper"));
        builder.stream(this.inputTopic, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).repartition(inputTopicRepartitioned).join(topicBStream, (value1, value2) -> value2, JoinWindows.of((Duration)Duration.ofSeconds(10L))).to(this.outputTopic);
        builder.build(this.streamsConfiguration);
        this.startStreams(builder);
        Assert.assertEquals((long)3L, (long)this.getNumberOfPartitionsForTopic(this.toRepartitionTopicName("join-repartition-test")));
        Assert.assertEquals((long)3L, (long)this.getNumberOfPartitionsForTopic(this.toRepartitionTopicName("topic-b-mapper")));
        this.validateReceivedMessages((Deserializer)new IntegerDeserializer(), (Deserializer)new StringDeserializer(), expectedRecords);
    }

    @Test
    public void shouldDoProperJoiningWhenNumberOfPartitionsAreValidWhenUsingRepartitionOperation() throws Exception {
        String topicBRepartitionedName = "topic-b-scale-up";
        String inputTopicRepartitionedName = "input-topic-scale-up";
        long timestamp = System.currentTimeMillis();
        CLUSTER.createTopic(this.topicB, 1, 1);
        List expectedRecords = Arrays.asList(new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)2, (Object)"B"));
        this.sendEvents(timestamp, expectedRecords);
        this.sendEvents(this.topicB, timestamp, expectedRecords);
        StreamsBuilder builder = new StreamsBuilder();
        Repartitioned inputTopicRepartitioned = Repartitioned.as((String)"input-topic-scale-up").withNumberOfPartitions(4);
        Repartitioned topicBRepartitioned = Repartitioned.as((String)"topic-b-scale-up").withNumberOfPartitions(4);
        KStream topicBStream = builder.stream(this.topicB, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).repartition(topicBRepartitioned);
        builder.stream(this.inputTopic, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).repartition(inputTopicRepartitioned).join(topicBStream, (value1, value2) -> value2, JoinWindows.of((Duration)Duration.ofSeconds(10L))).to(this.outputTopic);
        this.startStreams(builder);
        Assert.assertEquals((long)4L, (long)this.getNumberOfPartitionsForTopic(this.toRepartitionTopicName("topic-b-scale-up")));
        Assert.assertEquals((long)4L, (long)this.getNumberOfPartitionsForTopic(this.toRepartitionTopicName("input-topic-scale-up")));
        this.validateReceivedMessages((Deserializer)new IntegerDeserializer(), (Deserializer)new StringDeserializer(), expectedRecords);
    }

    @Test
    public void shouldRepartitionToMultiplePartitions() throws Exception {
        String repartitionName = "broadcasting-partitioner-test";
        long timestamp = System.currentTimeMillis();
        final AtomicInteger partitionerInvocation = new AtomicInteger(0);
        String broadcastingOutputTopic = "broadcast-output-topic-" + this.safeTestName;
        CLUSTER.createTopic(broadcastingOutputTopic, 4, 1);
        List expectedRecordsOnRepartition = Arrays.asList(new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)2, (Object)"B"), new KeyValue((Object)2, (Object)"B"), new KeyValue((Object)2, (Object)"B"), new KeyValue((Object)2, (Object)"B"));
        List<KeyValue<Integer, String>> expectedRecords = expectedRecordsOnRepartition.subList(3, 5);
        this.sendEvents(timestamp, expectedRecords);
        StreamsBuilder builder = new StreamsBuilder();
        class BroadcastingPartitioner
        implements StreamPartitioner<Integer, String> {
            BroadcastingPartitioner() {
            }

            @Deprecated
            public Integer partition(String topic, Integer key, String value, int numPartitions) {
                return null;
            }

            public Optional<Set<Integer>> partitions(String topic, Integer key, String value, int numPartitions) {
                partitionerInvocation.incrementAndGet();
                return Optional.of(IntStream.range(0, numPartitions).boxed().collect(Collectors.toSet()));
            }
        }
        Repartitioned repartitioned = Repartitioned.as((String)"broadcasting-partitioner-test").withStreamPartitioner((StreamPartitioner)new BroadcastingPartitioner());
        builder.stream(this.inputTopic, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).repartition(repartitioned).to(broadcastingOutputTopic);
        this.startStreams(builder);
        String topic = this.toRepartitionTopicName("broadcasting-partitioner-test");
        this.validateReceivedMessages((Deserializer)new IntegerDeserializer(), (Deserializer)new StringDeserializer(), expectedRecordsOnRepartition, topic);
        this.validateReceivedMessages((Deserializer)new IntegerDeserializer(), (Deserializer)new StringDeserializer(), expectedRecordsOnRepartition, broadcastingOutputTopic);
        Assert.assertTrue((boolean)this.topicExists(topic));
        Assert.assertEquals((long)expectedRecords.size(), (long)partitionerInvocation.get());
    }

    @Test
    public void shouldUseStreamPartitionerForRepartitionOperation() throws Exception {
        boolean partition = true;
        String repartitionName = "partitioner-test";
        long timestamp = System.currentTimeMillis();
        AtomicInteger partitionerInvocation = new AtomicInteger(0);
        List expectedRecords = Arrays.asList(new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)2, (Object)"B"));
        this.sendEvents(timestamp, expectedRecords);
        StreamsBuilder builder = new StreamsBuilder();
        Repartitioned repartitioned = Repartitioned.as((String)"partitioner-test").withStreamPartitioner((topic, key, value, numPartitions) -> {
            partitionerInvocation.incrementAndGet();
            return 1;
        });
        builder.stream(this.inputTopic, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).repartition(repartitioned).to(this.outputTopic);
        this.startStreams(builder);
        String topic2 = this.toRepartitionTopicName("partitioner-test");
        this.validateReceivedMessages((Deserializer)new IntegerDeserializer(), (Deserializer)new StringDeserializer(), expectedRecords);
        Assert.assertTrue((boolean)this.topicExists(topic2));
        Assert.assertEquals((long)expectedRecords.size(), (long)partitionerInvocation.get());
    }

    @Test
    public void shouldPerformSelectKeyWithRepartitionOperation() throws Exception {
        long timestamp = System.currentTimeMillis();
        this.sendEvents(timestamp, Arrays.asList(new KeyValue((Object)1, (Object)"10"), new KeyValue((Object)2, (Object)"20")));
        StreamsBuilder builder = new StreamsBuilder();
        builder.stream(this.inputTopic, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).selectKey((key, value) -> Integer.valueOf(value)).repartition().to(this.outputTopic);
        this.startStreams(builder);
        this.validateReceivedMessages((Deserializer)new IntegerDeserializer(), (Deserializer)new StringDeserializer(), Arrays.asList(new KeyValue((Object)10, (Object)"10"), new KeyValue((Object)20, (Object)"20")));
        String topology = builder.build().describe().toString();
        Assert.assertEquals((long)1L, (long)KStreamRepartitionIntegrationTest.countOccurrencesInTopology(topology, "Sink: .*-repartition.*"));
    }

    @Test
    public void shouldCreateRepartitionTopicIfKeyChangingOperationWasNotPerformed() throws Exception {
        String repartitionName = "dummy";
        long timestamp = System.currentTimeMillis();
        this.sendEvents(timestamp, Arrays.asList(new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)2, (Object)"B")));
        StreamsBuilder builder = new StreamsBuilder();
        builder.stream(this.inputTopic, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).repartition(Repartitioned.as((String)"dummy")).to(this.outputTopic);
        this.startStreams(builder);
        this.validateReceivedMessages((Deserializer)new IntegerDeserializer(), (Deserializer)new StringDeserializer(), Arrays.asList(new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)2, (Object)"B")));
        String topology = builder.build().describe().toString();
        Assert.assertTrue((boolean)this.topicExists(this.toRepartitionTopicName("dummy")));
        Assert.assertEquals((long)1L, (long)KStreamRepartitionIntegrationTest.countOccurrencesInTopology(topology, "Sink: .*dummy-repartition.*"));
    }

    @Test
    public void shouldPerformKeySelectOperationWhenRepartitionOperationIsUsedWithKeySelector() throws Exception {
        String repartitionedName = "new-key";
        long timestamp = System.currentTimeMillis();
        this.sendEvents(timestamp, Arrays.asList(new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)2, (Object)"B")));
        StreamsBuilder builder = new StreamsBuilder();
        Repartitioned repartitioned = Repartitioned.as((String)"new-key").withKeySerde(Serdes.String());
        builder.stream(this.inputTopic, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).selectKey((key, value) -> key.toString(), Named.as((String)"new-key")).repartition(repartitioned).groupByKey().count().toStream().to(this.outputTopic);
        this.startStreams(builder);
        this.validateReceivedMessages((Deserializer)new StringDeserializer(), (Deserializer)new LongDeserializer(), Arrays.asList(new KeyValue((Object)"1", (Object)1L), new KeyValue((Object)"2", (Object)1L)));
        String topology = builder.build().describe().toString();
        String repartitionTopicName = this.toRepartitionTopicName("new-key");
        Assert.assertTrue((boolean)this.topicExists(repartitionTopicName));
        Assert.assertEquals((long)1L, (long)KStreamRepartitionIntegrationTest.countOccurrencesInTopology(topology, "Sink: .*new-key-repartition.*"));
        Assert.assertEquals((long)1L, (long)KStreamRepartitionIntegrationTest.countOccurrencesInTopology(topology, "<-- new-key\n"));
    }

    @Test
    public void shouldCreateRepartitionTopicWithSpecifiedNumberOfPartitions() throws Exception {
        String repartitionName = "new-partitions";
        long timestamp = System.currentTimeMillis();
        this.sendEvents(timestamp, Arrays.asList(new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)2, (Object)"B")));
        StreamsBuilder builder = new StreamsBuilder();
        builder.stream(this.inputTopic, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).repartition(Repartitioned.as((String)"new-partitions").withNumberOfPartitions(2)).groupByKey().count().toStream().to(this.outputTopic);
        this.startStreams(builder);
        this.validateReceivedMessages((Deserializer)new IntegerDeserializer(), (Deserializer)new LongDeserializer(), Arrays.asList(new KeyValue((Object)1, (Object)1L), new KeyValue((Object)2, (Object)1L)));
        String repartitionTopicName = this.toRepartitionTopicName("new-partitions");
        Assert.assertTrue((boolean)this.topicExists(repartitionTopicName));
        Assert.assertEquals((long)2L, (long)this.getNumberOfPartitionsForTopic(repartitionTopicName));
    }

    @Test
    public void shouldInheritRepartitionTopicPartitionNumberFromUpstreamTopicWhenNumberOfPartitionsIsNotSpecified() throws Exception {
        String repartitionName = "new-topic";
        long timestamp = System.currentTimeMillis();
        this.sendEvents(timestamp, Arrays.asList(new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)2, (Object)"B")));
        StreamsBuilder builder = new StreamsBuilder();
        builder.stream(this.inputTopic, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).repartition(Repartitioned.as((String)"new-topic")).groupByKey().count().toStream().to(this.outputTopic);
        this.startStreams(builder);
        this.validateReceivedMessages((Deserializer)new IntegerDeserializer(), (Deserializer)new LongDeserializer(), Arrays.asList(new KeyValue((Object)1, (Object)1L), new KeyValue((Object)2, (Object)1L)));
        String repartitionTopicName = this.toRepartitionTopicName("new-topic");
        Assert.assertTrue((boolean)this.topicExists(repartitionTopicName));
        Assert.assertEquals((long)4L, (long)this.getNumberOfPartitionsForTopic(repartitionTopicName));
    }

    @Test
    public void shouldCreateOnlyOneRepartitionTopicWhenRepartitionIsFollowedByGroupByKey() throws Exception {
        String repartitionName = "new-partitions";
        long timestamp = System.currentTimeMillis();
        this.sendEvents(timestamp, Arrays.asList(new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)2, (Object)"B")));
        StreamsBuilder builder = new StreamsBuilder();
        Repartitioned repartitioned = Repartitioned.as((String)"new-partitions").withKeySerde(Serdes.String()).withValueSerde(Serdes.String()).withNumberOfPartitions(1);
        builder.stream(this.inputTopic, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).selectKey((key, value) -> key.toString()).repartition(repartitioned).groupByKey().count().toStream().to(this.outputTopic);
        this.startStreams(builder);
        String topology = builder.build().describe().toString();
        this.validateReceivedMessages((Deserializer)new StringDeserializer(), (Deserializer)new LongDeserializer(), Arrays.asList(new KeyValue((Object)"1", (Object)1L), new KeyValue((Object)"2", (Object)1L)));
        Assert.assertTrue((boolean)this.topicExists(this.toRepartitionTopicName("new-partitions")));
        Assert.assertEquals((long)1L, (long)KStreamRepartitionIntegrationTest.countOccurrencesInTopology(topology, "Sink: .*-repartition"));
    }

    @Test
    public void shouldGenerateRepartitionTopicWhenNameIsNotSpecified() throws Exception {
        long timestamp = System.currentTimeMillis();
        this.sendEvents(timestamp, Arrays.asList(new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)2, (Object)"B")));
        StreamsBuilder builder = new StreamsBuilder();
        builder.stream(this.inputTopic, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).selectKey((key, value) -> key.toString()).repartition(Repartitioned.with((Serde)Serdes.String(), (Serde)Serdes.String())).to(this.outputTopic);
        this.startStreams(builder);
        this.validateReceivedMessages((Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), Arrays.asList(new KeyValue((Object)"1", (Object)"A"), new KeyValue((Object)"2", (Object)"B")));
        String topology = builder.build().describe().toString();
        Assert.assertEquals((long)1L, (long)KStreamRepartitionIntegrationTest.countOccurrencesInTopology(topology, "Sink: .*-repartition"));
    }

    @Test
    public void shouldGoThroughRebalancingCorrectly() throws Exception {
        String repartitionName = "rebalancing-test";
        long timestamp = System.currentTimeMillis();
        this.sendEvents(timestamp, Arrays.asList(new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)2, (Object)"B")));
        StreamsBuilder builder = new StreamsBuilder();
        Repartitioned repartitioned = Repartitioned.as((String)"rebalancing-test").withKeySerde(Serdes.String()).withValueSerde(Serdes.String()).withNumberOfPartitions(2);
        builder.stream(this.inputTopic, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String())).selectKey((key, value) -> key.toString()).repartition(repartitioned).groupByKey().count().toStream().to(this.outputTopic);
        this.startStreams(builder);
        Properties streamsToCloseConfigs = new Properties();
        streamsToCloseConfigs.putAll((Map<?, ?>)this.streamsConfiguration);
        streamsToCloseConfigs.put("state.dir", TestUtils.tempDirectory().getPath() + "-2");
        KafkaStreams kafkaStreamsToClose = this.startStreams(builder, streamsToCloseConfigs);
        this.validateReceivedMessages((Deserializer)new StringDeserializer(), (Deserializer)new LongDeserializer(), Arrays.asList(new KeyValue((Object)"1", (Object)1L), new KeyValue((Object)"2", (Object)1L)));
        kafkaStreamsToClose.close();
        this.sendEvents(timestamp, Arrays.asList(new KeyValue((Object)1, (Object)"C"), new KeyValue((Object)2, (Object)"D")));
        this.validateReceivedMessages((Deserializer)new StringDeserializer(), (Deserializer)new LongDeserializer(), Arrays.asList(new KeyValue((Object)"1", (Object)2L), new KeyValue((Object)"2", (Object)2L)));
        String repartitionTopicName = this.toRepartitionTopicName("rebalancing-test");
        Assert.assertTrue((boolean)this.topicExists(repartitionTopicName));
        Assert.assertEquals((long)2L, (long)this.getNumberOfPartitionsForTopic(repartitionTopicName));
    }

    private int getNumberOfPartitionsForTopic(String topic) throws Exception {
        try (AdminClient adminClient = KStreamRepartitionIntegrationTest.createAdminClient();){
            TopicDescription topicDescription = (TopicDescription)((KafkaFuture)adminClient.describeTopics(Collections.singleton(topic)).topicNameValues().get(topic)).get();
            int n = topicDescription.partitions().size();
            return n;
        }
    }

    private boolean topicExists(String topic) throws Exception {
        try (AdminClient adminClient = KStreamRepartitionIntegrationTest.createAdminClient();){
            Set topics = (Set)adminClient.listTopics().names().get();
            boolean bl = topics.contains(topic);
            return bl;
        }
    }

    private String toRepartitionTopicName(String input) {
        return this.applicationId + "-" + input + "-repartition";
    }

    private static AdminClient createAdminClient() {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", CLUSTER.bootstrapServers());
        return AdminClient.create((Properties)properties);
    }

    private static int countOccurrencesInTopology(String topologyString, String searchPattern) {
        Matcher matcher = Pattern.compile(searchPattern).matcher(topologyString);
        ArrayList<String> repartitionTopicsFound = new ArrayList<String>();
        while (matcher.find()) {
            repartitionTopicsFound.add(matcher.group());
        }
        return repartitionTopicsFound.size();
    }

    private void sendEvents(long timestamp, List<KeyValue<Integer, String>> events) throws Exception {
        this.sendEvents(this.inputTopic, timestamp, events);
    }

    private void sendEvents(String topic, long timestamp, List<KeyValue<Integer, String>> events) throws Exception {
        IntegrationTestUtils.produceKeyValuesSynchronouslyWithTimestamp(topic, events, TestUtils.producerConfig((String)CLUSTER.bootstrapServers(), IntegerSerializer.class, StringSerializer.class, (Properties)new Properties()), timestamp);
    }

    private KafkaStreams startStreams(StreamsBuilder builder) throws InterruptedException {
        return this.startStreams(builder, KafkaStreams.State.REBALANCING, KafkaStreams.State.RUNNING, this.streamsConfiguration, null);
    }

    private KafkaStreams startStreams(StreamsBuilder builder, Properties streamsConfiguration) throws InterruptedException {
        return this.startStreams(builder, KafkaStreams.State.REBALANCING, KafkaStreams.State.RUNNING, streamsConfiguration, null);
    }

    private KafkaStreams startStreams(StreamsBuilder builder, KafkaStreams.State expectedOldState, KafkaStreams.State expectedNewState, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) throws InterruptedException {
        return this.startStreams(builder, expectedOldState, expectedNewState, this.streamsConfiguration, uncaughtExceptionHandler);
    }

    private KafkaStreams startStreams(StreamsBuilder builder, KafkaStreams.State expectedOldState, KafkaStreams.State expectedNewState, Properties streamsConfiguration, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) throws InterruptedException {
        CountDownLatch latch;
        KafkaStreams kafkaStreams = new KafkaStreams(builder.build(streamsConfiguration), streamsConfiguration);
        if (uncaughtExceptionHandler == null) {
            latch = new CountDownLatch(1);
        } else {
            latch = new CountDownLatch(2);
            kafkaStreams.setUncaughtExceptionHandler(e -> {
                uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), e);
                latch.countDown();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException("Unexpected checked exception caught in the uncaught exception handler", e);
            });
        }
        kafkaStreams.setStateListener((newState, oldState) -> {
            if (expectedOldState == oldState && expectedNewState == newState) {
                latch.countDown();
            }
        });
        kafkaStreams.start();
        latch.await(60000L, TimeUnit.MILLISECONDS);
        this.kafkaStreamsInstances.add(kafkaStreams);
        return kafkaStreams;
    }

    private <K, V> void validateReceivedMessages(Deserializer<K> keySerializer, Deserializer<V> valueSerializer, List<KeyValue<K, V>> expectedRecords) throws Exception {
        this.validateReceivedMessages(keySerializer, valueSerializer, expectedRecords, this.outputTopic);
    }

    private <K, V> void validateReceivedMessages(Deserializer<K> keySerializer, Deserializer<V> valueSerializer, List<KeyValue<K, V>> expectedRecords, String outputTopic) throws Exception {
        String safeTestName = IntegrationTestUtils.safeUniqueTestName(this.getClass(), this.testName);
        Properties consumerProperties = new Properties();
        consumerProperties.setProperty("bootstrap.servers", CLUSTER.bootstrapServers());
        consumerProperties.setProperty("group.id", "group-" + safeTestName);
        consumerProperties.setProperty("auto.offset.reset", "earliest");
        consumerProperties.setProperty("key.deserializer", keySerializer.getClass().getName());
        consumerProperties.setProperty("value.deserializer", valueSerializer.getClass().getName());
        IntegrationTestUtils.waitUntilFinalKeyValueRecordsReceived(consumerProperties, outputTopic, expectedRecords);
    }
}

