/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.File;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.processor.CommitCallback;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.api.FixedKeyRecord;
import org.apache.kafka.streams.processor.api.MockProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorMetadata;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.internals.ThreadCache;

public class MockInternalNewProcessorContext<KOut, VOut>
extends MockProcessorContext<KOut, VOut>
implements InternalProcessorContext<KOut, VOut> {
    private ProcessorNode currentNode;
    private long currentSystemTimeMs;
    private Task.TaskType taskType = Task.TaskType.ACTIVE;
    private long timestamp = 0L;
    private Headers headers = new RecordHeaders();
    private ProcessorMetadata processorMetadata = new ProcessorMetadata();

    public MockInternalNewProcessorContext() {
    }

    public MockInternalNewProcessorContext(Properties config, TaskId taskId, File stateDir) {
        super(config, taskId, stateDir);
    }

    public void setSystemTimeMs(long timeMs) {
        this.currentSystemTimeMs = timeMs;
    }

    public long currentSystemTimeMs() {
        return this.currentSystemTimeMs;
    }

    public long currentStreamTimeMs() {
        return 0L;
    }

    public StreamsMetricsImpl metrics() {
        return (StreamsMetricsImpl)super.metrics();
    }

    public ProcessorRecordContext recordContext() {
        return new ProcessorRecordContext(this.timestamp(), this.offset(), this.partition(), this.topic(), this.headers());
    }

    public void setRecordContext(ProcessorRecordContext recordContext) {
        this.setRecordMetadata(recordContext.topic(), recordContext.partition(), recordContext.offset());
        this.headers = recordContext.headers();
        this.timestamp = recordContext.timestamp();
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    public void setCurrentNode(ProcessorNode currentNode) {
        this.currentNode = currentNode;
    }

    public ProcessorNode currentNode() {
        return this.currentNode;
    }

    public ThreadCache cache() {
        return null;
    }

    public void initialize() {
    }

    public void uninitialize() {
    }

    public void register(StateStore store, StateRestoreCallback stateRestoreCallback) {
        this.addStateStore(store);
    }

    public void register(StateStore store, StateRestoreCallback stateRestoreCallback, CommitCallback checkpoint) {
        this.addStateStore(store);
    }

    public <K, V> void forward(K key, V value) {
        throw new UnsupportedOperationException("Migrate to new implementation");
    }

    public <K, V> void forward(K key, V value, To to) {
        throw new UnsupportedOperationException("Migrate to new implementation");
    }

    public String topic() {
        if (this.recordMetadata().isPresent()) {
            return ((RecordMetadata)this.recordMetadata().get()).topic();
        }
        return null;
    }

    public int partition() {
        if (this.recordMetadata().isPresent()) {
            return ((RecordMetadata)this.recordMetadata().get()).partition();
        }
        return 0;
    }

    public long offset() {
        if (this.recordMetadata().isPresent()) {
            return ((RecordMetadata)this.recordMetadata().get()).offset();
        }
        return 0L;
    }

    public Headers headers() {
        return this.headers;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Task.TaskType taskType() {
        return this.taskType;
    }

    public void logChange(String storeName, Bytes key, byte[] value, long timestamp, Position position) {
    }

    public void transitionToActive(StreamTask streamTask, RecordCollector recordCollector, ThreadCache newCache) {
    }

    public void transitionToStandby(ThreadCache newCache) {
    }

    public void registerCacheFlushListener(String namespace, ThreadCache.DirtyEntryFlushListener listener) {
    }

    public <T extends StateStore> T getStateStore(StoreBuilder<T> builder) {
        return (T)this.getStateStore(builder.name());
    }

    public String changelogFor(String storeName) {
        return "mock-changelog";
    }

    public void addProcessorMetadataKeyValue(String key, long value) {
        this.processorMetadata.put(key, value);
    }

    public Long processorMetadataForKey(String key) {
        return this.processorMetadata.get(key);
    }

    public void setProcessorMetadata(ProcessorMetadata metadata) {
        Objects.requireNonNull(metadata);
        this.processorMetadata = metadata;
    }

    public ProcessorMetadata getProcessorMetadata() {
        return this.processorMetadata;
    }

    public <K extends KOut, V extends VOut> void forward(FixedKeyRecord<K, V> record) {
        this.forward(new Record(record.key(), record.value(), record.timestamp(), record.headers()));
    }

    public <K extends KOut, V extends VOut> void forward(FixedKeyRecord<K, V> record, String childName) {
        this.forward(new Record(record.key(), record.value(), record.timestamp(), record.headers()), childName);
    }
}

