/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CompositeReadOnlyWindowStore;
import org.apache.kafka.streams.state.internals.ReadOnlyWindowStoreStub;
import org.apache.kafka.streams.state.internals.StateStoreProvider;
import org.apache.kafka.streams.state.internals.StreamThreadStateStoreProvider;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;
import org.apache.kafka.test.StateStoreProviderStub;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class CompositeReadOnlyWindowStoreTest {
    private static final long WINDOW_SIZE = 30000L;
    private final String storeName = "window-store";
    private StateStoreProviderStub stubProviderOne;
    private StateStoreProviderStub stubProviderTwo;
    private CompositeReadOnlyWindowStore<String, String> windowStore;
    private ReadOnlyWindowStoreStub<String, String> underlyingWindowStore;
    private ReadOnlyWindowStoreStub<String, String> otherUnderlyingStore;

    @Before
    public void before() {
        this.stubProviderOne = new StateStoreProviderStub(false);
        this.stubProviderTwo = new StateStoreProviderStub(false);
        this.underlyingWindowStore = new ReadOnlyWindowStoreStub(30000L);
        this.stubProviderOne.addStore("window-store", this.underlyingWindowStore);
        this.otherUnderlyingStore = new ReadOnlyWindowStoreStub(30000L);
        this.stubProviderOne.addStore("other-window-store", this.otherUnderlyingStore);
        this.windowStore = new CompositeReadOnlyWindowStore((StateStoreProvider)new WrappingStoreProvider(Arrays.asList(new StreamThreadStateStoreProvider[]{this.stubProviderOne, this.stubProviderTwo}), StoreQueryParameters.fromNameAndType((String)"window-store", (QueryableStoreType)QueryableStoreTypes.windowStore())), QueryableStoreTypes.windowStore(), "window-store");
    }

    @Test
    public void shouldFetchValuesFromWindowStore() {
        this.underlyingWindowStore.put("my-key", "my-value", 0L);
        this.underlyingWindowStore.put("my-key", "my-later-value", 10L);
        Assert.assertEquals(Arrays.asList(new KeyValue((Object)0L, (Object)"my-value"), new KeyValue((Object)10L, (Object)"my-later-value")), StreamsTestUtils.toList(this.windowStore.fetch((Object)"my-key", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(25L))));
    }

    @Test
    public void shouldBackwardFetchValuesFromWindowStore() {
        this.underlyingWindowStore.put("my-key", "my-value", 0L);
        this.underlyingWindowStore.put("my-key", "my-later-value", 10L);
        Assert.assertEquals(Arrays.asList(new KeyValue((Object)10L, (Object)"my-later-value"), new KeyValue((Object)0L, (Object)"my-value")), StreamsTestUtils.toList(this.windowStore.backwardFetch((Object)"my-key", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(25L))));
    }

    @Test
    public void shouldReturnEmptyIteratorIfNoData() {
        try (WindowStoreIterator iterator = this.windowStore.fetch((Object)"my-key", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(25L));){
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldReturnBackwardEmptyIteratorIfNoData() {
        try (WindowStoreIterator iterator = this.windowStore.backwardFetch((Object)"my-key", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(25L));){
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldFindValueForKeyWhenMultiStores() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("key-one", "value-one", 0L);
        secondUnderlying.put("key-two", "value-two", 10L);
        List keyOneResults = StreamsTestUtils.toList(this.windowStore.fetch((Object)"key-one", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1L)));
        List keyTwoResults = StreamsTestUtils.toList(this.windowStore.fetch((Object)"key-two", Instant.ofEpochMilli(10L), Instant.ofEpochMilli(11L)));
        Assert.assertEquals(Collections.singletonList(KeyValue.pair((Object)0L, (Object)"value-one")), keyOneResults);
        Assert.assertEquals(Collections.singletonList(KeyValue.pair((Object)10L, (Object)"value-two")), keyTwoResults);
    }

    @Test
    public void shouldFindValueForKeyWhenMultiStoresBackwards() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("key-one", "value-one", 0L);
        secondUnderlying.put("key-two", "value-two", 10L);
        List keyOneResults = StreamsTestUtils.toList(this.windowStore.backwardFetch((Object)"key-one", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1L)));
        List keyTwoResults = StreamsTestUtils.toList(this.windowStore.backwardFetch((Object)"key-two", Instant.ofEpochMilli(10L), Instant.ofEpochMilli(11L)));
        Assert.assertEquals(Collections.singletonList(KeyValue.pair((Object)0L, (Object)"value-one")), keyOneResults);
        Assert.assertEquals(Collections.singletonList(KeyValue.pair((Object)10L, (Object)"value-two")), keyTwoResults);
    }

    @Test
    public void shouldNotGetValuesFromOtherStores() {
        this.otherUnderlyingStore.put("some-key", "some-value", 0L);
        this.underlyingWindowStore.put("some-key", "my-value", 1L);
        List results = StreamsTestUtils.toList(this.windowStore.fetch((Object)"some-key", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(2L)));
        Assert.assertEquals(Collections.singletonList(new KeyValue((Object)1L, (Object)"my-value")), results);
    }

    @Test
    public void shouldNotGetValuesBackwardFromOtherStores() {
        this.otherUnderlyingStore.put("some-key", "some-value", 0L);
        this.underlyingWindowStore.put("some-key", "my-value", 1L);
        List results = StreamsTestUtils.toList(this.windowStore.backwardFetch((Object)"some-key", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(2L)));
        Assert.assertEquals(Collections.singletonList(new KeyValue((Object)1L, (Object)"my-value")), results);
    }

    @Test
    public void shouldThrowInvalidStateStoreExceptionOnRebalance() {
        StateStoreProvider storeProvider = (StateStoreProvider)Mockito.mock(StateStoreProvider.class);
        Mockito.when((Object)storeProvider.stores(ArgumentMatchers.anyString(), (QueryableStoreType)ArgumentMatchers.any())).thenThrow(new Throwable[]{new InvalidStateStoreException("store is unavailable")});
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore(storeProvider, QueryableStoreTypes.windowStore(), "foo");
        Assert.assertThrows(InvalidStateStoreException.class, () -> store.fetch((Object)"key", Instant.ofEpochMilli(1L), Instant.ofEpochMilli(10L)));
    }

    @Test
    public void shouldThrowInvalidStateStoreExceptionOnRebalanceWhenBackwards() {
        StateStoreProvider storeProvider = (StateStoreProvider)Mockito.mock(StateStoreProvider.class);
        Mockito.when((Object)storeProvider.stores(ArgumentMatchers.anyString(), (QueryableStoreType)ArgumentMatchers.any())).thenThrow(new Throwable[]{new InvalidStateStoreException("store is unavailable")});
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore(storeProvider, QueryableStoreTypes.windowStore(), "foo");
        Assert.assertThrows(InvalidStateStoreException.class, () -> store.backwardFetch((Object)"key", Instant.ofEpochMilli(1L), Instant.ofEpochMilli(10L)));
    }

    @Test
    public void shouldThrowInvalidStateStoreExceptionIfFetchThrows() {
        this.underlyingWindowStore.setOpen(false);
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore((StateStoreProvider)new WrappingStoreProvider(Collections.singletonList(this.stubProviderOne), StoreQueryParameters.fromNameAndType((String)"window-store", (QueryableStoreType)QueryableStoreTypes.windowStore())), QueryableStoreTypes.windowStore(), "window-store");
        try {
            store.fetch((Object)"key", Instant.ofEpochMilli(1L), Instant.ofEpochMilli(10L));
            Assert.fail((String)"InvalidStateStoreException was expected");
        }
        catch (InvalidStateStoreException e) {
            Assert.assertEquals((Object)"State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldThrowInvalidStateStoreExceptionIfBackwardFetchThrows() {
        this.underlyingWindowStore.setOpen(false);
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore((StateStoreProvider)new WrappingStoreProvider(Collections.singletonList(this.stubProviderOne), StoreQueryParameters.fromNameAndType((String)"window-store", (QueryableStoreType)QueryableStoreTypes.windowStore())), QueryableStoreTypes.windowStore(), "window-store");
        try {
            store.backwardFetch((Object)"key", Instant.ofEpochMilli(1L), Instant.ofEpochMilli(10L));
            Assert.fail((String)"InvalidStateStoreException was expected");
        }
        catch (InvalidStateStoreException e) {
            Assert.assertEquals((Object)"State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.", (Object)e.getMessage());
        }
    }

    @Test
    public void emptyBackwardIteratorAlwaysReturnsFalse() {
        StateStoreProvider storeProvider = (StateStoreProvider)Mockito.mock(StateStoreProvider.class);
        Mockito.when((Object)storeProvider.stores(ArgumentMatchers.anyString(), (QueryableStoreType)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore(storeProvider, QueryableStoreTypes.windowStore(), "foo");
        try (WindowStoreIterator windowStoreIterator = store.backwardFetch((Object)"key", Instant.ofEpochMilli(1L), Instant.ofEpochMilli(10L));){
            Assert.assertFalse((boolean)windowStoreIterator.hasNext());
        }
    }

    @Test
    public void emptyIteratorAlwaysReturnsFalse() {
        StateStoreProvider storeProvider = (StateStoreProvider)Mockito.mock(StateStoreProvider.class);
        Mockito.when((Object)storeProvider.stores(ArgumentMatchers.anyString(), (QueryableStoreType)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore(storeProvider, QueryableStoreTypes.windowStore(), "foo");
        try (WindowStoreIterator windowStoreIterator = store.fetch((Object)"key", Instant.ofEpochMilli(1L), Instant.ofEpochMilli(10L));){
            Assert.assertFalse((boolean)windowStoreIterator.hasNext());
        }
    }

    @Test
    public void emptyBackwardIteratorPeekNextKeyShouldThrowNoSuchElementException() {
        StateStoreProvider storeProvider = (StateStoreProvider)Mockito.mock(StateStoreProvider.class);
        Mockito.when((Object)storeProvider.stores(ArgumentMatchers.anyString(), (QueryableStoreType)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore(storeProvider, QueryableStoreTypes.windowStore(), "foo");
        try (WindowStoreIterator windowStoreIterator = store.backwardFetch((Object)"key", Instant.ofEpochMilli(1L), Instant.ofEpochMilli(10L));){
            Assert.assertThrows(NoSuchElementException.class, () -> ((WindowStoreIterator)windowStoreIterator).peekNextKey());
        }
    }

    @Test
    public void emptyIteratorPeekNextKeyShouldThrowNoSuchElementException() {
        StateStoreProvider storeProvider = (StateStoreProvider)Mockito.mock(StateStoreProvider.class);
        Mockito.when((Object)storeProvider.stores(ArgumentMatchers.anyString(), (QueryableStoreType)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore(storeProvider, QueryableStoreTypes.windowStore(), "foo");
        try (WindowStoreIterator windowStoreIterator = store.fetch((Object)"key", Instant.ofEpochMilli(1L), Instant.ofEpochMilli(10L));){
            Assert.assertThrows(NoSuchElementException.class, () -> ((WindowStoreIterator)windowStoreIterator).peekNextKey());
        }
    }

    @Test
    public void emptyIteratorNextShouldThrowNoSuchElementException() {
        StateStoreProvider storeProvider = (StateStoreProvider)Mockito.mock(StateStoreProvider.class);
        Mockito.when((Object)storeProvider.stores(ArgumentMatchers.anyString(), (QueryableStoreType)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore(storeProvider, QueryableStoreTypes.windowStore(), "foo");
        try (WindowStoreIterator windowStoreIterator = store.fetch((Object)"key", Instant.ofEpochMilli(1L), Instant.ofEpochMilli(10L));){
            Assert.assertThrows(NoSuchElementException.class, () -> windowStoreIterator.next());
        }
    }

    @Test
    public void emptyBackwardIteratorNextShouldThrowNoSuchElementException() {
        StateStoreProvider storeProvider = (StateStoreProvider)Mockito.mock(StateStoreProvider.class);
        Mockito.when((Object)storeProvider.stores(ArgumentMatchers.anyString(), (QueryableStoreType)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore(storeProvider, QueryableStoreTypes.windowStore(), "foo");
        try (WindowStoreIterator windowStoreIterator = store.backwardFetch((Object)"key", Instant.ofEpochMilli(1L), Instant.ofEpochMilli(10L));){
            Assert.assertThrows(NoSuchElementException.class, () -> windowStoreIterator.next());
        }
    }

    @Test
    public void shouldFetchKeyRangeAcrossStores() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.fetch((Object)"a", (Object)"b", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L)));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new TimeWindow(0L, 30000L)), (Object)"a"), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new TimeWindow(10L, 30010L)), (Object)"b"))));
    }

    @Test
    public void shouldFetchKeyRangeAcrossStoresWithNullKeyTo() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        secondUnderlying.put("c", "c", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.fetch((Object)"a", null, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L)));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new TimeWindow(0L, 30000L)), (Object)"a"), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new TimeWindow(10L, 30010L)), (Object)"b"), KeyValue.pair((Object)new Windowed((Object)"c", (Window)new TimeWindow(10L, 30010L)), (Object)"c"))));
    }

    @Test
    public void shouldFetchKeyRangeAcrossStoresWithNullKeyFrom() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        secondUnderlying.put("c", "c", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.fetch(null, (Object)"c", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L)));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new TimeWindow(0L, 30000L)), (Object)"a"), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new TimeWindow(10L, 30010L)), (Object)"b"), KeyValue.pair((Object)new Windowed((Object)"c", (Window)new TimeWindow(10L, 30010L)), (Object)"c"))));
    }

    @Test
    public void shouldFetchKeyRangeAcrossStoresWithNullKeyFromKeyTo() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        secondUnderlying.put("c", "c", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.fetch(null, null, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L)));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new TimeWindow(0L, 30000L)), (Object)"a"), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new TimeWindow(10L, 30010L)), (Object)"b"), KeyValue.pair((Object)new Windowed((Object)"c", (Window)new TimeWindow(10L, 30010L)), (Object)"c"))));
    }

    @Test
    public void shouldBackwardFetchKeyRangeAcrossStoresWithNullKeyTo() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        secondUnderlying.put("c", "c", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.backwardFetch((Object)"a", null, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L)));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new TimeWindow(0L, 30000L)), (Object)"a"), KeyValue.pair((Object)new Windowed((Object)"c", (Window)new TimeWindow(10L, 30010L)), (Object)"c"), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new TimeWindow(10L, 30010L)), (Object)"b"))));
    }

    @Test
    public void shouldBackwardFetchKeyRangeAcrossStoresWithNullKeyFrom() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        secondUnderlying.put("c", "c", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.backwardFetch(null, (Object)"c", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L)));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new TimeWindow(0L, 30000L)), (Object)"a"), KeyValue.pair((Object)new Windowed((Object)"c", (Window)new TimeWindow(10L, 30010L)), (Object)"c"), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new TimeWindow(10L, 30010L)), (Object)"b"))));
    }

    @Test
    public void shouldBackwardFetchKeyRangeAcrossStoresWithNullKeyFromKeyTo() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        secondUnderlying.put("c", "c", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.backwardFetch(null, null, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L)));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new TimeWindow(0L, 30000L)), (Object)"a"), KeyValue.pair((Object)new Windowed((Object)"c", (Window)new TimeWindow(10L, 30010L)), (Object)"c"), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new TimeWindow(10L, 30010L)), (Object)"b"))));
    }

    @Test
    public void shouldBackwardFetchKeyRangeAcrossStores() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.backwardFetch((Object)"a", (Object)"b", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L)));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new TimeWindow(0L, 30000L)), (Object)"a"), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new TimeWindow(10L, 30010L)), (Object)"b"))));
    }

    @Test
    public void shouldFetchKeyValueAcrossStores() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlyingWindowStore = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlyingWindowStore);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlyingWindowStore.put("b", "b", 10L);
        MatcherAssert.assertThat((Object)((String)this.windowStore.fetch((Object)"a", 0L)), (Matcher)IsEqual.equalTo((Object)"a"));
        MatcherAssert.assertThat((Object)((String)this.windowStore.fetch((Object)"b", 10L)), (Matcher)IsEqual.equalTo((Object)"b"));
        MatcherAssert.assertThat((Object)((String)this.windowStore.fetch((Object)"c", 10L)), (Matcher)IsEqual.equalTo(null));
        MatcherAssert.assertThat((Object)((String)this.windowStore.fetch((Object)"a", 10L)), (Matcher)IsEqual.equalTo(null));
    }

    @Test
    public void shouldGetAllAcrossStores() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.all());
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new TimeWindow(0L, 30000L)), (Object)"a"), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new TimeWindow(10L, 30010L)), (Object)"b"))));
    }

    @Test
    public void shouldGetBackwardAllAcrossStores() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.backwardAll());
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new TimeWindow(0L, 30000L)), (Object)"a"), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new TimeWindow(10L, 30010L)), (Object)"b"))));
    }

    @Test
    public void shouldFetchAllAcrossStores() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.fetchAll(Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L)));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new TimeWindow(0L, 30000L)), (Object)"a"), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new TimeWindow(10L, 30010L)), (Object)"b"))));
    }

    @Test
    public void shouldBackwardFetchAllAcrossStores() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.backwardFetchAll(Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L)));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new TimeWindow(0L, 30000L)), (Object)"a"), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new TimeWindow(10L, 30010L)), (Object)"b"))));
    }

    @Test
    public void shouldThrowNPEIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowStore.fetch(null, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(0L)));
    }
}

