/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.util.Optional;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.state.KeyValueIterator;

@InterfaceStability.Evolving
public final class RangeQuery<K, V>
implements Query<KeyValueIterator<K, V>> {
    private final Optional<K> lower;
    private final Optional<K> upper;

    private RangeQuery(Optional<K> lower, Optional<K> upper) {
        this.lower = lower;
        this.upper = upper;
    }

    public static <K, V> RangeQuery<K, V> withRange(K lower, K upper) {
        return new RangeQuery<K, V>(Optional.ofNullable(lower), Optional.ofNullable(upper));
    }

    public static <K, V> RangeQuery<K, V> withUpperBound(K upper) {
        return new RangeQuery(Optional.empty(), Optional.of(upper));
    }

    public static <K, V> RangeQuery<K, V> withLowerBound(K lower) {
        return new RangeQuery<K, V>(Optional.of(lower), Optional.empty());
    }

    public static <K, V> RangeQuery<K, V> withNoBounds() {
        return new RangeQuery(Optional.empty(), Optional.empty());
    }

    public Optional<K> getLowerBound() {
        return this.lower;
    }

    public Optional<K> getUpperBound() {
        return this.upper;
    }
}

