/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.internals.StreamThreadStateStoreProvider;

public class StateStoreProviderStub
extends StreamThreadStateStoreProvider {
    private final Map<Map.Entry<String, Integer>, StateStore> stores = new HashMap<Map.Entry<String, Integer>, StateStore>();
    private final boolean throwException;
    private final int defaultStorePartition = 0;

    public StateStoreProviderStub(boolean throwException) {
        super(null);
        this.throwException = throwException;
    }

    public <T> List<T> stores(StoreQueryParameters storeQueryParameters) {
        String storeName = storeQueryParameters.storeName();
        QueryableStoreType queryableStoreType = storeQueryParameters.queryableStoreType();
        if (this.throwException) {
            throw new InvalidStateStoreException("store is unavailable");
        }
        if (storeQueryParameters.partition() != null) {
            AbstractMap.SimpleEntry<String, Integer> stateStoreKey = new AbstractMap.SimpleEntry<String, Integer>(storeName, storeQueryParameters.partition());
            if (this.stores.containsKey(stateStoreKey) && queryableStoreType.accepts(this.stores.get(stateStoreKey))) {
                return Collections.singletonList(this.stores.get(stateStoreKey));
            }
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.stores.entrySet().stream().filter(entry -> ((String)((Map.Entry)entry.getKey()).getKey()).equals(storeName) && queryableStoreType.accepts((StateStore)entry.getValue())).map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    public void addStore(String storeName, StateStore store) {
        this.addStore(storeName, 0, store);
    }

    public void addStore(String storeName, int partition, StateStore store) {
        this.stores.put(new AbstractMap.SimpleEntry<String, Integer>(storeName, partition), store);
    }
}

