/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.CachingSessionStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingSessionBytesStore;
import org.apache.kafka.streams.state.internals.MeteredSessionStore;
import org.apache.kafka.streams.state.internals.SessionStoreBuilder;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class SessionStoreBuilderTest {
    @Mock
    private SessionBytesStoreSupplier supplier;
    @Mock
    private SessionStore<Bytes, byte[]> inner;
    private SessionStoreBuilder<String, String> builder;

    @Before
    public void setUp() {
        Mockito.when((Object)((SessionStore)this.supplier.get())).thenReturn(this.inner);
        Mockito.when((Object)this.supplier.name()).thenReturn((Object)"name");
        Mockito.when((Object)this.supplier.metricsScope()).thenReturn((Object)"metricScope");
        this.builder = new SessionStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    @Test
    public void shouldHaveMeteredStoreAsOuterStore() {
        SessionStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredSessionStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreByDefault() {
        SessionStore store = this.builder.build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingSessionBytesStore.class));
    }

    @Test
    public void shouldNotHaveChangeLoggingStoreWhenDisabled() {
        SessionStore store = (SessionStore)this.builder.withLoggingDisabled().build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldHaveCachingStoreWhenEnabled() {
        SessionStore store = (SessionStore)this.builder.withCachingEnabled().build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredSessionStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(CachingSessionStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreWhenLoggingEnabled() {
        SessionStore store = (SessionStore)this.builder.withLoggingEnabled(Collections.emptyMap()).build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredSessionStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingSessionBytesStore.class));
        MatcherAssert.assertThat((Object)((WrappedStateStore)wrapped).wrapped(), (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldHaveCachingAndChangeLoggingWhenBothEnabled() {
        SessionStore store = (SessionStore)this.builder.withLoggingEnabled(Collections.emptyMap()).withCachingEnabled().build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        WrappedStateStore changeLogging = (WrappedStateStore)caching.wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredSessionStore.class));
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingSessionStore.class));
        MatcherAssert.assertThat((Object)changeLogging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingSessionBytesStore.class));
        MatcherAssert.assertThat((Object)changeLogging.wrapped(), (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldThrowNullPointerIfStoreSupplierIsNull() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> new SessionStoreBuilder(null, Serdes.String(), Serdes.String(), (Time)new MockTime()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"storeSupplier cannot be null"));
    }

    @Test
    public void shouldThrowNullPointerIfNameIsNull() {
        Mockito.when((Object)this.supplier.name()).thenReturn(null);
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> new SessionStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"name cannot be null"));
    }

    @Test
    public void shouldThrowNullPointerIfTimeIsNull() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> new SessionStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), null));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"time cannot be null"));
    }

    @Test
    public void shouldThrowNullPointerIfMetricsScopeIsNull() {
        Mockito.when((Object)this.supplier.metricsScope()).thenReturn(null);
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> new SessionStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"storeSupplier's metricsScope can't be null"));
    }
}

