/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.streams.state.internals.Maybe;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MaybeTest {
    @Test
    public void shouldReturnDefinedValue() {
        MatcherAssert.assertThat((Object)Maybe.defined(null).getNullableValue(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)((String)Maybe.defined((Object)"ASDF").getNullableValue()), (Matcher)Matchers.is((Object)"ASDF"));
    }

    @Test
    public void shouldAnswerIsDefined() {
        MatcherAssert.assertThat((Object)Maybe.defined(null).isDefined(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Maybe.defined((Object)"ASDF").isDefined(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Maybe.undefined().isDefined(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldThrowOnGetUndefinedValue() {
        Maybe undefined = Maybe.undefined();
        try {
            undefined.getNullableValue();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void shouldUpholdEqualityCorrectness() {
        MatcherAssert.assertThat((Object)Maybe.undefined().equals((Object)Maybe.undefined()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Maybe.defined(null).equals((Object)Maybe.defined(null)), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Maybe.defined((Object)"q").equals((Object)Maybe.defined((Object)"q")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Maybe.undefined().equals((Object)Maybe.defined(null)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)Maybe.undefined().equals((Object)Maybe.defined((Object)"x")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)Maybe.defined(null).equals((Object)Maybe.undefined()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)Maybe.defined(null).equals((Object)Maybe.defined((Object)"x")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)Maybe.defined((Object)"a").equals((Object)Maybe.undefined()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)Maybe.defined((Object)"a").equals((Object)Maybe.defined(null)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)Maybe.defined((Object)"a").equals((Object)Maybe.defined((Object)"b")), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldUpholdHashCodeCorrectness() {
        MatcherAssert.assertThat((Object)Maybe.undefined().hashCode(), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)Maybe.defined(null).hashCode(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)Maybe.defined((Object)"a").hashCode(), (Matcher)Matchers.is((Object)"a".hashCode()));
    }
}

