/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.KeyValueIteratorFacade;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class KeyValueIteratorFacadeTest {
    @Mock
    private KeyValueIterator<String, ValueAndTimestamp<String>> mockedKeyValueIterator;
    private KeyValueIteratorFacade<String, String> keyValueIteratorFacade;

    @Before
    public void setup() {
        this.keyValueIteratorFacade = new KeyValueIteratorFacade(this.mockedKeyValueIterator);
    }

    @Test
    public void shouldForwardHasNext() {
        EasyMock.expect((Object)this.mockedKeyValueIterator.hasNext()).andReturn((Object)true).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueIterator});
        Assert.assertTrue((boolean)this.keyValueIteratorFacade.hasNext());
        Assert.assertFalse((boolean)this.keyValueIteratorFacade.hasNext());
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueIterator});
    }

    @Test
    public void shouldForwardPeekNextKey() {
        EasyMock.expect((Object)((String)this.mockedKeyValueIterator.peekNextKey())).andReturn((Object)"key");
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueIterator});
        MatcherAssert.assertThat((Object)((String)this.keyValueIteratorFacade.peekNextKey()), (Matcher)Matchers.is((Object)"key"));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueIterator});
    }

    @Test
    public void shouldReturnPlainKeyValuePairOnGet() {
        EasyMock.expect((Object)((KeyValue)this.mockedKeyValueIterator.next())).andReturn((Object)new KeyValue((Object)"key", (Object)ValueAndTimestamp.make((Object)"value", (long)42L)));
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueIterator});
        MatcherAssert.assertThat((Object)this.keyValueIteratorFacade.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)"key", (Object)"value")));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueIterator});
    }

    @Test
    public void shouldCloseInnerIterator() {
        this.mockedKeyValueIterator.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueIterator});
        this.keyValueIteratorFacade.close();
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueIterator});
    }
}

