/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class PositionBoundTest {
    @Test
    public void shouldCopyPosition() {
        Position position = Position.emptyPosition();
        PositionBound positionBound = PositionBound.at((Position)position);
        position.withComponent("topic", 1, 2L);
        MatcherAssert.assertThat((Object)position.getTopics(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new String[]{"topic"})));
        MatcherAssert.assertThat((Object)positionBound.position().getTopics(), (Matcher)Matchers.empty());
    }

    @Test
    public void unboundedShouldBeUnbounded() {
        PositionBound bound = PositionBound.unbounded();
        Assert.assertTrue((boolean)bound.isUnbounded());
    }

    @Test
    public void unboundedShouldReturnEmptyPosition() {
        PositionBound bound = PositionBound.unbounded();
        MatcherAssert.assertThat((Object)bound.position(), (Matcher)Matchers.equalTo((Object)Position.emptyPosition()));
    }

    @Test
    public void shouldEqualPosition() {
        PositionBound bound1 = PositionBound.at((Position)Position.emptyPosition());
        PositionBound bound2 = PositionBound.at((Position)Position.emptyPosition());
        Assert.assertEquals((Object)bound1, (Object)bound2);
    }

    @Test
    public void shouldEqualUnbounded() {
        PositionBound bound1 = PositionBound.unbounded();
        PositionBound bound2 = PositionBound.unbounded();
        Assert.assertEquals((Object)bound1, (Object)bound2);
    }

    @Test
    public void shouldEqualSelf() {
        PositionBound bound1 = PositionBound.at((Position)Position.emptyPosition());
        Assert.assertEquals((Object)bound1, (Object)bound1);
    }

    @Test
    public void shouldNotEqualNull() {
        PositionBound bound1 = PositionBound.at((Position)Position.emptyPosition());
        Assert.assertNotEquals((Object)bound1, null);
    }

    @Test
    public void shouldNotHash() {
        PositionBound bound = PositionBound.at((Position)Position.emptyPosition());
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((PositionBound)bound).hashCode());
        HashSet set = new HashSet();
        Assert.assertThrows(UnsupportedOperationException.class, () -> set.add(bound));
        HashMap map = new HashMap();
        Assert.assertThrows(UnsupportedOperationException.class, () -> map.put(bound, 5));
    }
}

