/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.test.StreamsTestUtils;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Sensor.class, KafkaMetric.class})
public class StreamsMetricsImplTest {
    private static final String SENSOR_PREFIX_DELIMITER = ".";
    private static final String SENSOR_NAME_DELIMITER = ".s.";
    private static final String SENSOR_NAME_1 = "sensor1";
    private static final String SENSOR_NAME_2 = "sensor2";
    private static final String INTERNAL_PREFIX = "internal";
    private static final String VERSION = "latest";
    private static final String CLIENT_ID = "test-client";
    private static final String THREAD_ID1 = "test-thread-1";
    private static final String TASK_ID1 = "test-task-1";
    private static final String TASK_ID2 = "test-task-2";
    private static final String NODE_ID1 = "test-node-1";
    private static final String NODE_ID2 = "test-node-2";
    private static final String TOPIC_ID1 = "test-topic-1";
    private static final String TOPIC_ID2 = "test-topic-2";
    private static final String METRIC_NAME1 = "test-metric1";
    private static final String METRIC_NAME2 = "test-metric2";
    private static final String THREAD_ID_TAG = "thread-id";
    private static final String TASK_ID_TAG = "task-id";
    private static final String SCOPE_NAME = "test-scope";
    private static final String STORE_ID_TAG = "-state-id";
    private static final String STORE_NAME1 = "store1";
    private static final String STORE_NAME2 = "store2";
    private static final Map<String, String> STORE_LEVEL_TAG_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)Thread.currentThread().getName()), Utils.mkEntry((Object)"task-id", (Object)"test-task-1"), Utils.mkEntry((Object)"test-scope-state-id", (Object)"store1")});
    private static final String RECORD_CACHE_ID_TAG = "record-cache-id";
    private static final String ENTITY_NAME = "test-entity";
    private static final String OPERATION_NAME = "test-operation";
    private static final String CUSTOM_TAG_KEY1 = "test-key1";
    private static final String CUSTOM_TAG_VALUE1 = "test-value1";
    private static final String CUSTOM_TAG_KEY2 = "test-key2";
    private static final String CUSTOM_TAG_VALUE2 = "test-value2";
    private static final Sensor.RecordingLevel INFO_RECORDING_LEVEL = Sensor.RecordingLevel.INFO;
    private static final String DESCRIPTION1 = "description number one";
    private static final String DESCRIPTION2 = "description number two";
    private static final String DESCRIPTION3 = "description number three";
    private static final Gauge<String> VALUE_PROVIDER = (config, now) -> "mutable-value";
    private final Metrics metrics = new Metrics();
    private final Sensor sensor = this.metrics.sensor("dummy");
    private final String metricNamePrefix = "metric";
    private final String group = "group";
    private final Map<String, String> tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"tag", (Object)"value")});
    private final Map<String, String> clientLevelTags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"test-client")});
    private final MetricName metricName1 = new MetricName("test-metric1", "stream-metrics", "description number one", this.clientLevelTags);
    private final MetricName metricName2 = new MetricName("test-metric1", "stream-metrics", "description number two", this.clientLevelTags);
    private final MockTime time = new MockTime(0L);
    private final StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, "test-client", "latest", (Time)this.time);

    private static MetricConfig eqMetricConfig(final MetricConfig metricConfig) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){
            private final StringBuffer message = new StringBuffer();

            public boolean matches(Object argument) {
                if (argument instanceof MetricConfig) {
                    boolean equalsComparisons;
                    MetricConfig otherMetricConfig = (MetricConfig)argument;
                    boolean bl = equalsComparisons = (otherMetricConfig.quota() == metricConfig.quota() || otherMetricConfig.quota().equals((Object)metricConfig.quota())) && otherMetricConfig.tags().equals(metricConfig.tags());
                    if (otherMetricConfig.eventWindow() == metricConfig.eventWindow() && otherMetricConfig.recordLevel() == metricConfig.recordLevel() && equalsComparisons && otherMetricConfig.samples() == metricConfig.samples() && otherMetricConfig.timeWindowMs() == metricConfig.timeWindowMs()) {
                        return true;
                    }
                    this.message.append("{ ");
                    this.message.append("eventWindow=");
                    this.message.append(otherMetricConfig.eventWindow());
                    this.message.append(", ");
                    this.message.append("recordLevel=");
                    this.message.append(otherMetricConfig.recordLevel());
                    this.message.append(", ");
                    this.message.append("quota=");
                    this.message.append(otherMetricConfig.quota().toString());
                    this.message.append(", ");
                    this.message.append("samples=");
                    this.message.append(otherMetricConfig.samples());
                    this.message.append(", ");
                    this.message.append("tags=");
                    this.message.append(otherMetricConfig.tags().toString());
                    this.message.append(", ");
                    this.message.append("timeWindowMs=");
                    this.message.append(otherMetricConfig.timeWindowMs());
                    this.message.append(" }");
                }
                this.message.append("not a MetricConfig object");
                return false;
            }

            public void appendTo(StringBuffer buffer) {
                buffer.append(this.message);
            }
        });
        return null;
    }

    private Capture<String> addSensorsOnAllLevels(Metrics metrics, StreamsMetricsImpl streamsMetrics) {
        Capture sensorKeys = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Sensor[] parents = new Sensor[]{};
        EasyMock.expect((Object)metrics.sensor((String)EasyMock.capture((Capture)sensorKeys), (Sensor.RecordingLevel)EasyMock.eq((Object)INFO_RECORDING_LEVEL), parents)).andStubReturn((Object)this.sensor);
        EasyMock.expect((Object)metrics.metricName(METRIC_NAME1, "stream-metrics", DESCRIPTION1, this.clientLevelTags)).andReturn((Object)this.metricName1);
        EasyMock.expect((Object)metrics.metricName(METRIC_NAME2, "stream-metrics", DESCRIPTION2, this.clientLevelTags)).andReturn((Object)this.metricName2);
        EasyMock.replay((Object[])new Object[]{metrics});
        streamsMetrics.addClientLevelImmutableMetric(METRIC_NAME1, DESCRIPTION1, INFO_RECORDING_LEVEL, (Object)"value");
        streamsMetrics.addClientLevelImmutableMetric(METRIC_NAME2, DESCRIPTION2, INFO_RECORDING_LEVEL, (Object)"value");
        streamsMetrics.clientLevelSensor(SENSOR_NAME_1, INFO_RECORDING_LEVEL, new Sensor[0]);
        streamsMetrics.clientLevelSensor(SENSOR_NAME_2, INFO_RECORDING_LEVEL, new Sensor[0]);
        streamsMetrics.threadLevelSensor(THREAD_ID1, SENSOR_NAME_1, INFO_RECORDING_LEVEL, new Sensor[0]);
        streamsMetrics.threadLevelSensor(THREAD_ID1, SENSOR_NAME_2, INFO_RECORDING_LEVEL, new Sensor[0]);
        streamsMetrics.taskLevelSensor(THREAD_ID1, TASK_ID1, SENSOR_NAME_1, INFO_RECORDING_LEVEL, new Sensor[0]);
        streamsMetrics.taskLevelSensor(THREAD_ID1, TASK_ID1, SENSOR_NAME_2, INFO_RECORDING_LEVEL, new Sensor[0]);
        streamsMetrics.storeLevelSensor(TASK_ID1, STORE_NAME1, SENSOR_NAME_1, INFO_RECORDING_LEVEL, new Sensor[0]);
        streamsMetrics.storeLevelSensor(TASK_ID1, STORE_NAME1, SENSOR_NAME_2, INFO_RECORDING_LEVEL, new Sensor[0]);
        streamsMetrics.storeLevelSensor(TASK_ID1, STORE_NAME2, SENSOR_NAME_1, INFO_RECORDING_LEVEL, new Sensor[0]);
        streamsMetrics.addStoreLevelMutableMetric(TASK_ID1, SCOPE_NAME, STORE_NAME1, METRIC_NAME1, DESCRIPTION1, INFO_RECORDING_LEVEL, VALUE_PROVIDER);
        streamsMetrics.addStoreLevelMutableMetric(TASK_ID1, SCOPE_NAME, STORE_NAME1, METRIC_NAME2, DESCRIPTION2, INFO_RECORDING_LEVEL, VALUE_PROVIDER);
        streamsMetrics.addStoreLevelMutableMetric(TASK_ID1, SCOPE_NAME, STORE_NAME2, METRIC_NAME1, DESCRIPTION1, INFO_RECORDING_LEVEL, VALUE_PROVIDER);
        return sensorKeys;
    }

    private Capture<String> setupGetNewSensorTest(Metrics metrics, Sensor.RecordingLevel recordingLevel) {
        Capture sensorKey = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        EasyMock.expect((Object)metrics.getSensor((String)EasyMock.capture((Capture)sensorKey))).andStubReturn(null);
        Sensor[] parents = new Sensor[]{};
        EasyMock.expect((Object)metrics.sensor((String)EasyMock.capture((Capture)sensorKey), (Sensor.RecordingLevel)EasyMock.eq((Object)recordingLevel), parents)).andReturn((Object)this.sensor);
        EasyMock.replay((Object[])new Object[]{metrics});
        return sensorKey;
    }

    private void setupGetExistingSensorTest(Metrics metrics) {
        EasyMock.expect((Object)metrics.getSensor(EasyMock.anyString())).andStubReturn((Object)this.sensor);
        EasyMock.replay((Object[])new Object[]{metrics});
    }

    @Test
    public void shouldGetNewThreadLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetNewSensorTest(metrics, recordingLevel);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Sensor actualSensor = streamsMetrics.threadLevelSensor(THREAD_ID1, SENSOR_NAME_1, recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetExistingThreadLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetExistingSensorTest(metrics);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Sensor actualSensor = streamsMetrics.threadLevelSensor(THREAD_ID1, SENSOR_NAME_1, recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetNewTaskLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetNewSensorTest(metrics, recordingLevel);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Sensor actualSensor = streamsMetrics.taskLevelSensor(THREAD_ID1, TASK_ID1, SENSOR_NAME_1, recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetExistingTaskLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetExistingSensorTest(metrics);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Sensor actualSensor = streamsMetrics.taskLevelSensor(THREAD_ID1, TASK_ID1, SENSOR_NAME_1, recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetNewTopicLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetNewSensorTest(metrics, recordingLevel);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Sensor actualSensor = streamsMetrics.topicLevelSensor(THREAD_ID1, TASK_ID1, NODE_ID1, TOPIC_ID1, SENSOR_NAME_1, recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetExistingTopicLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetExistingSensorTest(metrics);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Sensor actualSensor = streamsMetrics.topicLevelSensor(THREAD_ID1, TASK_ID1, NODE_ID1, TOPIC_ID1, SENSOR_NAME_1, recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetNewStoreLevelSensorIfNoneExists() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        Capture<String> sensorKeys = this.setupGetNewSensorTest(metrics, recordingLevel);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Sensor actualSensor = streamsMetrics.storeLevelSensor(TASK_ID1, STORE_NAME1, SENSOR_NAME_1, recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
        MatcherAssert.assertThat((Object)((String)sensorKeys.getValues().get(0)), (Matcher)CoreMatchers.is((Object)((String)sensorKeys.getValues().get(1))));
    }

    @Test
    public void shouldGetExistingStoreLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetExistingSensorTest(metrics);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Sensor actualSensor = streamsMetrics.storeLevelSensor(TASK_ID1, STORE_NAME1, SENSOR_NAME_1, recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldUseSameStoreLevelSensorKeyWithTwoDifferentSensorNames() {
        Metrics metrics = (Metrics)EasyMock.niceMock(Metrics.class);
        Capture<String> sensorKeys = this.setUpSensorKeyTests(metrics);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        streamsMetrics.storeLevelSensor(TASK_ID1, STORE_NAME1, SENSOR_NAME_1, INFO_RECORDING_LEVEL, new Sensor[0]);
        streamsMetrics.storeLevelSensor(TASK_ID1, STORE_NAME1, SENSOR_NAME_2, INFO_RECORDING_LEVEL, new Sensor[0]);
        MatcherAssert.assertThat((Object)((String)sensorKeys.getValues().get(0)), (Matcher)CoreMatchers.not((Object)((String)sensorKeys.getValues().get(1))));
    }

    @Test
    public void shouldNotUseSameStoreLevelSensorKeyWithDifferentTaskIds() {
        Metrics metrics = (Metrics)EasyMock.niceMock(Metrics.class);
        Capture<String> sensorKeys = this.setUpSensorKeyTests(metrics);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        streamsMetrics.storeLevelSensor(TASK_ID1, STORE_NAME1, SENSOR_NAME_1, INFO_RECORDING_LEVEL, new Sensor[0]);
        streamsMetrics.storeLevelSensor(TASK_ID2, STORE_NAME1, SENSOR_NAME_1, INFO_RECORDING_LEVEL, new Sensor[0]);
        MatcherAssert.assertThat((Object)((String)sensorKeys.getValues().get(0)), (Matcher)CoreMatchers.not((Object)((String)sensorKeys.getValues().get(1))));
    }

    @Test
    public void shouldNotUseSameStoreLevelSensorKeyWithDifferentStoreNames() {
        Metrics metrics = (Metrics)EasyMock.niceMock(Metrics.class);
        Capture<String> sensorKeys = this.setUpSensorKeyTests(metrics);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        streamsMetrics.storeLevelSensor(TASK_ID1, STORE_NAME1, SENSOR_NAME_1, INFO_RECORDING_LEVEL, new Sensor[0]);
        streamsMetrics.storeLevelSensor(TASK_ID1, STORE_NAME2, SENSOR_NAME_1, INFO_RECORDING_LEVEL, new Sensor[0]);
        MatcherAssert.assertThat((Object)((String)sensorKeys.getValues().get(0)), (Matcher)CoreMatchers.not((Object)((String)sensorKeys.getValues().get(1))));
    }

    @Test
    public void shouldNotUseSameStoreLevelSensorKeyWithDifferentThreadIds() throws InterruptedException {
        Metrics metrics = (Metrics)EasyMock.niceMock(Metrics.class);
        Capture<String> sensorKeys = this.setUpSensorKeyTests(metrics);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        streamsMetrics.storeLevelSensor(TASK_ID1, STORE_NAME1, SENSOR_NAME_1, INFO_RECORDING_LEVEL, new Sensor[0]);
        Thread otherThread = new Thread(() -> streamsMetrics.storeLevelSensor(TASK_ID1, STORE_NAME1, SENSOR_NAME_1, INFO_RECORDING_LEVEL, new Sensor[0]));
        otherThread.start();
        otherThread.join();
        MatcherAssert.assertThat((Object)((String)sensorKeys.getValues().get(0)), (Matcher)CoreMatchers.not((Object)((String)sensorKeys.getValues().get(1))));
    }

    @Test
    public void shouldUseSameStoreLevelSensorKeyWithSameSensorNames() {
        Metrics metrics = (Metrics)EasyMock.niceMock(Metrics.class);
        Capture<String> sensorKeys = this.setUpSensorKeyTests(metrics);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        streamsMetrics.storeLevelSensor(TASK_ID1, STORE_NAME1, SENSOR_NAME_1, INFO_RECORDING_LEVEL, new Sensor[0]);
        streamsMetrics.storeLevelSensor(TASK_ID1, STORE_NAME1, SENSOR_NAME_1, INFO_RECORDING_LEVEL, new Sensor[0]);
        MatcherAssert.assertThat((Object)((String)sensorKeys.getValues().get(0)), (Matcher)CoreMatchers.is((Object)((String)sensorKeys.getValues().get(1))));
    }

    private Capture<String> setUpSensorKeyTests(Metrics metrics) {
        Capture sensorKeys = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        EasyMock.expect((Object)metrics.getSensor((String)EasyMock.capture((Capture)sensorKeys))).andStubReturn((Object)this.sensor);
        EasyMock.replay((Object[])new Object[]{metrics});
        return sensorKeys;
    }

    @Test
    public void shouldAddNewStoreLevelMutableMetric() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        MetricName metricName = new MetricName(METRIC_NAME1, "stream-state-metrics", DESCRIPTION1, STORE_LEVEL_TAG_MAP);
        MetricConfig metricConfig = new MetricConfig().recordLevel(INFO_RECORDING_LEVEL);
        EasyMock.expect((Object)metrics.metricName(METRIC_NAME1, "stream-state-metrics", DESCRIPTION1, STORE_LEVEL_TAG_MAP)).andReturn((Object)metricName);
        EasyMock.expect((Object)metrics.metric(metricName)).andReturn(null);
        EasyMock.expect((Object)metrics.addMetricIfAbsent((MetricName)EasyMock.eq((Object)metricName), StreamsMetricsImplTest.eqMetricConfig(metricConfig), (MetricValueProvider)EasyMock.eq(VALUE_PROVIDER))).andReturn(null);
        EasyMock.replay((Object[])new Object[]{metrics});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        streamsMetrics.addStoreLevelMutableMetric(TASK_ID1, SCOPE_NAME, STORE_NAME1, METRIC_NAME1, DESCRIPTION1, INFO_RECORDING_LEVEL, VALUE_PROVIDER);
        EasyMock.verify((Object[])new Object[]{metrics});
    }

    @Test
    public void shouldCreateNewStoreLevelMutableMetric() {
        MetricName metricName = new MetricName(METRIC_NAME1, "stream-state-metrics", DESCRIPTION1, STORE_LEVEL_TAG_MAP);
        MetricConfig metricConfig = new MetricConfig().recordLevel(INFO_RECORDING_LEVEL);
        Metrics metrics = new Metrics(metricConfig);
        Assert.assertNull((Object)metrics.metric(metricName));
        metrics.addMetricIfAbsent(metricName, metricConfig, VALUE_PROVIDER);
        Assert.assertNotNull((Object)metrics.metric(metricName));
    }

    @Test
    public void shouldNotAddStoreLevelMutableMetricIfAlreadyExists() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        MetricName metricName = new MetricName(METRIC_NAME1, "stream-state-metrics", DESCRIPTION1, STORE_LEVEL_TAG_MAP);
        EasyMock.expect((Object)metrics.metricName(METRIC_NAME1, "stream-state-metrics", DESCRIPTION1, STORE_LEVEL_TAG_MAP)).andReturn((Object)metricName);
        EasyMock.expect((Object)metrics.metric(metricName)).andReturn((Object)((KafkaMetric)EasyMock.mock(KafkaMetric.class)));
        EasyMock.replay((Object[])new Object[]{metrics});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        streamsMetrics.addStoreLevelMutableMetric(TASK_ID1, SCOPE_NAME, STORE_NAME1, METRIC_NAME1, DESCRIPTION1, INFO_RECORDING_LEVEL, VALUE_PROVIDER);
        EasyMock.verify((Object[])new Object[]{metrics});
    }

    @Test
    public void shouldReturnSameMetricIfAlreadyCreated() {
        MetricName metricName = new MetricName(METRIC_NAME1, "stream-state-metrics", DESCRIPTION1, STORE_LEVEL_TAG_MAP);
        MetricConfig metricConfig = new MetricConfig().recordLevel(INFO_RECORDING_LEVEL);
        Metrics metrics = new Metrics(metricConfig);
        Assert.assertNull((Object)metrics.metric(metricName));
        KafkaMetric kafkaMetric = metrics.addMetricIfAbsent(metricName, metricConfig, VALUE_PROVIDER);
        Assert.assertEquals((Object)kafkaMetric, (Object)metrics.addMetricIfAbsent(metricName, metricConfig, VALUE_PROVIDER));
    }

    @Test
    public void shouldCreateMetricOnceDuringConcurrentMetricCreationRequest() throws InterruptedException {
        MetricName metricName = new MetricName(METRIC_NAME1, "stream-state-metrics", DESCRIPTION1, STORE_LEVEL_TAG_MAP);
        MetricConfig metricConfig = new MetricConfig().recordLevel(INFO_RECORDING_LEVEL);
        Metrics metrics = new Metrics(metricConfig);
        Assert.assertNull((Object)metrics.metric(metricName));
        AtomicReference metricCreatedViaThread1 = new AtomicReference();
        AtomicReference metricCreatedViaThread2 = new AtomicReference();
        Thread thread1 = new Thread(() -> metricCreatedViaThread1.set(metrics.addMetricIfAbsent(metricName, metricConfig, VALUE_PROVIDER)));
        Thread thread2 = new Thread(() -> metricCreatedViaThread2.set(metrics.addMetricIfAbsent(metricName, metricConfig, VALUE_PROVIDER)));
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        Assert.assertEquals(metricCreatedViaThread1.get(), metricCreatedViaThread2.get());
    }

    @Test
    public void shouldRemoveStateStoreLevelSensors() {
        Metrics metrics = (Metrics)EasyMock.niceMock(Metrics.class);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        MetricName metricName1 = new MetricName(METRIC_NAME1, "stream-state-metrics", DESCRIPTION1, STORE_LEVEL_TAG_MAP);
        MetricName metricName2 = new MetricName(METRIC_NAME2, "stream-state-metrics", DESCRIPTION2, STORE_LEVEL_TAG_MAP);
        EasyMock.expect((Object)metrics.metricName(METRIC_NAME1, "stream-state-metrics", DESCRIPTION1, STORE_LEVEL_TAG_MAP)).andReturn((Object)metricName1);
        EasyMock.expect((Object)metrics.metricName(METRIC_NAME2, "stream-state-metrics", DESCRIPTION2, STORE_LEVEL_TAG_MAP)).andReturn((Object)metricName2);
        Capture<String> sensorKeys = this.addSensorsOnAllLevels(metrics, streamsMetrics);
        EasyMock.resetToDefault((Object[])new Object[]{metrics});
        metrics.removeSensor((String)sensorKeys.getValues().get(6));
        metrics.removeSensor((String)sensorKeys.getValues().get(7));
        EasyMock.expect((Object)metrics.removeMetric(metricName1)).andReturn((Object)((KafkaMetric)EasyMock.mock(KafkaMetric.class)));
        EasyMock.expect((Object)metrics.removeMetric(metricName2)).andReturn((Object)((KafkaMetric)EasyMock.mock(KafkaMetric.class)));
        EasyMock.replay((Object[])new Object[]{metrics});
        streamsMetrics.removeAllStoreLevelSensorsAndMetrics(TASK_ID1, STORE_NAME1);
        EasyMock.verify((Object[])new Object[]{metrics});
    }

    @Test
    public void shouldGetNewNodeLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetNewSensorTest(metrics, recordingLevel);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Sensor actualSensor = streamsMetrics.nodeLevelSensor(THREAD_ID1, TASK_ID1, NODE_ID1, SENSOR_NAME_1, recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetExistingNodeLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetExistingSensorTest(metrics);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Sensor actualSensor = streamsMetrics.nodeLevelSensor(THREAD_ID1, TASK_ID1, NODE_ID1, SENSOR_NAME_1, recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetNewCacheLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        String processorCacheName = "processorNodeName";
        this.setupGetNewSensorTest(metrics, recordingLevel);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Sensor actualSensor = streamsMetrics.cacheLevelSensor(THREAD_ID1, TASK_ID1, "processorNodeName", SENSOR_NAME_1, recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetExistingCacheLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        String processorCacheName = "processorNodeName";
        this.setupGetExistingSensorTest(metrics);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Sensor actualSensor = streamsMetrics.cacheLevelSensor(THREAD_ID1, TASK_ID1, "processorNodeName", SENSOR_NAME_1, recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetNewClientLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetNewSensorTest(metrics, recordingLevel);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Sensor actualSensor = streamsMetrics.clientLevelSensor(SENSOR_NAME_1, recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetExistingClientLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetExistingSensorTest(metrics);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Sensor actualSensor = streamsMetrics.clientLevelSensor(SENSOR_NAME_1, recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldAddClientLevelImmutableMetric() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        MetricConfig metricConfig = new MetricConfig().recordLevel(recordingLevel);
        String value = "immutable-value";
        StreamsMetricsImpl.ImmutableMetricValue immutableValue = new StreamsMetricsImpl.ImmutableMetricValue((Object)"immutable-value");
        EasyMock.expect((Object)metrics.metricName(METRIC_NAME1, "stream-metrics", DESCRIPTION1, this.clientLevelTags)).andReturn((Object)this.metricName1);
        metrics.addMetric((MetricName)EasyMock.eq((Object)this.metricName1), StreamsMetricsImplTest.eqMetricConfig(metricConfig), (MetricValueProvider)EasyMock.eq((Object)immutableValue));
        EasyMock.replay((Object[])new Object[]{metrics});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        streamsMetrics.addClientLevelImmutableMetric(METRIC_NAME1, DESCRIPTION1, recordingLevel, (Object)"immutable-value");
        EasyMock.verify((Object[])new Object[]{metrics});
    }

    @Test
    public void shouldAddClientLevelMutableMetric() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        MetricConfig metricConfig = new MetricConfig().recordLevel(recordingLevel);
        Gauge valueProvider = (config, now) -> "mutable-value";
        EasyMock.expect((Object)metrics.metricName(METRIC_NAME1, "stream-metrics", DESCRIPTION1, this.clientLevelTags)).andReturn((Object)this.metricName1);
        metrics.addMetric((MetricName)EasyMock.eq((Object)this.metricName1), StreamsMetricsImplTest.eqMetricConfig(metricConfig), (MetricValueProvider)EasyMock.eq((Object)valueProvider));
        EasyMock.replay((Object[])new Object[]{metrics});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        streamsMetrics.addClientLevelMutableMetric(METRIC_NAME1, DESCRIPTION1, recordingLevel, valueProvider);
        EasyMock.verify((Object[])new Object[]{metrics});
    }

    @Test
    public void shouldProvideCorrectStrings() {
        MatcherAssert.assertThat((Object)"-latency", (Matcher)CoreMatchers.is((Object)"-latency"));
        MatcherAssert.assertThat((Object)"all", (Matcher)CoreMatchers.is((Object)"all"));
    }

    private void setupRemoveSensorsTest(Metrics metrics, String level) {
        String fullSensorNamePrefix = "internal." + level + SENSOR_NAME_DELIMITER;
        EasyMock.resetToDefault((Object[])new Object[]{metrics});
        metrics.removeSensor(fullSensorNamePrefix + SENSOR_NAME_1);
        metrics.removeSensor(fullSensorNamePrefix + SENSOR_NAME_2);
        EasyMock.replay((Object[])new Object[]{metrics});
    }

    @Test
    public void shouldRemoveClientLevelMetricsAndSensors() {
        Metrics metrics = (Metrics)EasyMock.niceMock(Metrics.class);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        Capture<String> sensorKeys = this.addSensorsOnAllLevels(metrics, streamsMetrics);
        EasyMock.resetToDefault((Object[])new Object[]{metrics});
        metrics.removeSensor((String)sensorKeys.getValues().get(0));
        metrics.removeSensor((String)sensorKeys.getValues().get(1));
        EasyMock.expect((Object)metrics.removeMetric(this.metricName1)).andStubReturn(null);
        EasyMock.expect((Object)metrics.removeMetric(this.metricName2)).andStubReturn(null);
        EasyMock.replay((Object[])new Object[]{metrics});
        streamsMetrics.removeAllClientLevelSensorsAndMetrics();
        EasyMock.verify((Object[])new Object[]{metrics});
    }

    @Test
    public void shouldRemoveThreadLevelSensors() {
        Metrics metrics = (Metrics)EasyMock.niceMock(Metrics.class);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION, (Time)this.time);
        this.addSensorsOnAllLevels(metrics, streamsMetrics);
        this.setupRemoveSensorsTest(metrics, THREAD_ID1);
        streamsMetrics.removeAllThreadLevelSensors(THREAD_ID1);
        EasyMock.verify((Object[])new Object[]{metrics});
    }

    @Test
    public void testNullMetrics() {
        Assert.assertThrows(NullPointerException.class, () -> new StreamsMetricsImpl(null, "", VERSION, (Time)this.time));
    }

    @Test
    public void testRemoveNullSensor() {
        Assert.assertThrows(NullPointerException.class, () -> this.streamsMetrics.removeSensor(null));
    }

    @Test
    public void testRemoveSensor() {
        String sensorName = SENSOR_NAME_1;
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        Sensor sensor1 = this.streamsMetrics.addSensor(SENSOR_NAME_1, Sensor.RecordingLevel.DEBUG);
        this.streamsMetrics.removeSensor(sensor1);
        Sensor sensor1a = this.streamsMetrics.addSensor(SENSOR_NAME_1, Sensor.RecordingLevel.DEBUG, new Sensor[]{sensor1});
        this.streamsMetrics.removeSensor(sensor1a);
        Sensor sensor2 = this.streamsMetrics.addLatencyRateTotalSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        this.streamsMetrics.removeSensor(sensor2);
        Sensor sensor3 = this.streamsMetrics.addRateTotalSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        this.streamsMetrics.removeSensor(sensor3);
        Assert.assertEquals(Collections.emptyMap(), (Object)this.streamsMetrics.parentSensors());
    }

    @Test
    public void testMultiLevelSensorRemoval() {
        Metrics registry = new Metrics();
        StreamsMetricsImpl metrics = new StreamsMetricsImpl(registry, THREAD_ID1, VERSION, (Time)this.time);
        for (MetricName defaultMetric : registry.metrics().keySet()) {
            registry.removeMetric(defaultMetric);
        }
        String taskName = "taskName";
        String operation = "operation";
        Map taskTags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"tkey", (Object)"value")});
        String processorNodeName = "processorNodeName";
        Map nodeTags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"nkey", (Object)"value")});
        String topicName = "topicName";
        Map topicTags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"tkey", (Object)"value")});
        Sensor parent1 = metrics.taskLevelSensor(THREAD_ID1, "taskName", "operation", Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        StreamsMetricsImpl.addAvgAndMaxLatencyToSensor((Sensor)parent1, (String)"stream-processor-node-metrics", (Map)taskTags, (String)"operation");
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)parent1, (String)"stream-processor-node-metrics", (Map)taskTags, (String)"operation", (String)"", (String)"");
        int numberOfTaskMetrics = registry.metrics().size();
        Sensor sensor1 = metrics.nodeLevelSensor(THREAD_ID1, "taskName", "processorNodeName", "operation", Sensor.RecordingLevel.DEBUG, new Sensor[]{parent1});
        StreamsMetricsImpl.addAvgAndMaxLatencyToSensor((Sensor)sensor1, (String)"stream-processor-node-metrics", (Map)nodeTags, (String)"operation");
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)sensor1, (String)"stream-processor-node-metrics", (Map)nodeTags, (String)"operation", (String)"", (String)"");
        MatcherAssert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(numberOfTaskMetrics)));
        int numberOfNodeMetrics = registry.metrics().size();
        Sensor child1 = metrics.topicLevelSensor(THREAD_ID1, "taskName", "processorNodeName", "topicName", "operation", Sensor.RecordingLevel.DEBUG, new Sensor[]{sensor1});
        StreamsMetricsImpl.addAvgAndMaxLatencyToSensor((Sensor)child1, (String)"stream-topic-metrics", (Map)topicTags, (String)"operation");
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)child1, (String)"stream-topic-metrics", (Map)topicTags, (String)"operation", (String)"", (String)"");
        MatcherAssert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(numberOfNodeMetrics)));
        metrics.removeAllTopicLevelSensors(THREAD_ID1, "taskName", "processorNodeName", "topicName");
        MatcherAssert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.equalTo((Object)numberOfNodeMetrics));
        metrics.removeAllNodeLevelSensors(THREAD_ID1, "taskName", "processorNodeName");
        MatcherAssert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.equalTo((Object)numberOfTaskMetrics));
        Sensor parent2 = metrics.taskLevelSensor(THREAD_ID1, "taskName", "operation", Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        StreamsMetricsImpl.addAvgAndMaxLatencyToSensor((Sensor)parent2, (String)"stream-processor-node-metrics", (Map)taskTags, (String)"operation");
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)parent2, (String)"stream-processor-node-metrics", (Map)taskTags, (String)"operation", (String)"", (String)"");
        MatcherAssert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.equalTo((Object)numberOfTaskMetrics));
        Sensor sensor2 = metrics.nodeLevelSensor(THREAD_ID1, "taskName", "processorNodeName", "operation", Sensor.RecordingLevel.DEBUG, new Sensor[]{parent2});
        StreamsMetricsImpl.addAvgAndMaxLatencyToSensor((Sensor)sensor2, (String)"stream-processor-node-metrics", (Map)nodeTags, (String)"operation");
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)sensor2, (String)"stream-processor-node-metrics", (Map)nodeTags, (String)"operation", (String)"", (String)"");
        MatcherAssert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(numberOfTaskMetrics)));
        metrics.removeAllNodeLevelSensors(THREAD_ID1, "taskName", "processorNodeName");
        MatcherAssert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.equalTo((Object)numberOfTaskMetrics));
        metrics.removeAllTaskLevelSensors(THREAD_ID1, "taskName");
        MatcherAssert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testLatencyMetrics() {
        int defaultMetrics = this.streamsMetrics.metrics().size();
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        Sensor sensor1 = this.streamsMetrics.addLatencyRateTotalSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        int meterMetricsCount = 2;
        int otherMetricsCount = 2;
        Assert.assertEquals((long)(defaultMetrics + 2 + 2), (long)this.streamsMetrics.metrics().size());
        this.streamsMetrics.removeSensor(sensor1);
        Assert.assertEquals((long)defaultMetrics, (long)this.streamsMetrics.metrics().size());
    }

    @Test
    public void testThroughputMetrics() {
        int defaultMetrics = this.streamsMetrics.metrics().size();
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        Sensor sensor1 = this.streamsMetrics.addRateTotalSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        int meterMetricsCount = 2;
        Assert.assertEquals((long)(defaultMetrics + 2), (long)this.streamsMetrics.metrics().size());
        this.streamsMetrics.removeSensor(sensor1);
        Assert.assertEquals((long)defaultMetrics, (long)this.streamsMetrics.metrics().size());
    }

    @Test
    public void testTotalMetricDoesntDecrease() {
        MockTime time = new MockTime(1L);
        MetricConfig config = new MetricConfig().timeWindow(1L, TimeUnit.MILLISECONDS);
        Metrics metrics = new Metrics(config, (Time)time);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, "", VERSION, (Time)time);
        String scope = "scope";
        String entity = "entity";
        String operation = "op";
        Sensor sensor = streamsMetrics.addLatencyRateTotalSensor("scope", "entity", "op", Sensor.RecordingLevel.INFO, new String[0]);
        double latency = 100.0;
        MetricName totalMetricName = metrics.metricName("op-total", "stream-scope-metrics", "", new String[]{THREAD_ID_TAG, Thread.currentThread().getName(), "scope-id", "entity"});
        KafkaMetric totalMetric = metrics.metric(totalMetricName);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)Math.round(totalMetric.measurable().measure(config, time.milliseconds())));
            sensor.record(100.0, time.milliseconds());
        }
    }

    @Test
    public void shouldAddLatencyRateTotalSensor() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, VERSION, (Time)this.time);
        this.shouldAddCustomSensor(streamsMetrics.addLatencyRateTotalSensor(SCOPE_NAME, ENTITY_NAME, OPERATION_NAME, Sensor.RecordingLevel.DEBUG, new String[0]), streamsMetrics, Arrays.asList("test-operation-latency-avg", "test-operation-latency-max", "test-operation-total", "test-operation-rate"));
    }

    @Test
    public void shouldAddRateTotalSensor() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, VERSION, (Time)this.time);
        this.shouldAddCustomSensor(streamsMetrics.addRateTotalSensor(SCOPE_NAME, ENTITY_NAME, OPERATION_NAME, Sensor.RecordingLevel.DEBUG, new String[0]), streamsMetrics, Arrays.asList("test-operation-total", "test-operation-rate"));
    }

    @Test
    public void shouldAddLatencyRateTotalSensorWithCustomTags() {
        Sensor sensor = this.streamsMetrics.addLatencyRateTotalSensor(SCOPE_NAME, ENTITY_NAME, OPERATION_NAME, Sensor.RecordingLevel.DEBUG, new String[]{CUSTOM_TAG_KEY1, CUSTOM_TAG_VALUE1, CUSTOM_TAG_KEY2, CUSTOM_TAG_VALUE2});
        Map<String, String> tags = this.customTags(this.streamsMetrics);
        this.shouldAddCustomSensorWithTags(sensor, Arrays.asList("test-operation-latency-avg", "test-operation-latency-max", "test-operation-total", "test-operation-rate"), tags);
    }

    @Test
    public void shouldAddRateTotalSensorWithCustomTags() {
        Sensor sensor = this.streamsMetrics.addRateTotalSensor(SCOPE_NAME, ENTITY_NAME, OPERATION_NAME, Sensor.RecordingLevel.DEBUG, new String[]{CUSTOM_TAG_KEY1, CUSTOM_TAG_VALUE1, CUSTOM_TAG_KEY2, CUSTOM_TAG_VALUE2});
        Map<String, String> tags = this.customTags(this.streamsMetrics);
        this.shouldAddCustomSensorWithTags(sensor, Arrays.asList("test-operation-total", "test-operation-rate"), tags);
    }

    private void shouldAddCustomSensor(Sensor sensor, StreamsMetricsImpl streamsMetrics, List<String> metricsNames) {
        Map<String, String> tags = this.tags(streamsMetrics);
        this.shouldAddCustomSensorWithTags(sensor, metricsNames, tags);
    }

    private void shouldAddCustomSensorWithTags(Sensor sensor, List<String> metricsNames, Map<String, String> tags) {
        String group = "stream-test-scope-metrics";
        Assert.assertTrue((boolean)sensor.hasMetrics());
        MatcherAssert.assertThat((Object)sensor.name(), (Matcher)CoreMatchers.is((Object)("external." + Thread.currentThread().getName() + ".entity." + ENTITY_NAME + SENSOR_NAME_DELIMITER + OPERATION_NAME)));
        for (String name : metricsNames) {
            Assert.assertTrue((boolean)StreamsTestUtils.containsMetric(this.metrics, name, "stream-test-scope-metrics", tags));
        }
    }

    private Map<String, String> tags(StreamsMetricsImpl streamsMetrics) {
        return Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)(streamsMetrics.version() == StreamsMetricsImpl.Version.LATEST ? THREAD_ID_TAG : "client-id"), (Object)Thread.currentThread().getName()), Utils.mkEntry((Object)"test-scope-id", (Object)ENTITY_NAME)});
    }

    private Map<String, String> customTags(StreamsMetricsImpl streamsMetrics) {
        Map<String, String> tags = this.tags(streamsMetrics);
        tags.put(CUSTOM_TAG_KEY1, CUSTOM_TAG_VALUE1);
        tags.put(CUSTOM_TAG_KEY2, CUSTOM_TAG_VALUE2);
        return tags;
    }

    @Test
    public void shouldThrowIfLatencyRateTotalSensorIsAddedWithOddTags() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.streamsMetrics.addLatencyRateTotalSensor(SCOPE_NAME, ENTITY_NAME, OPERATION_NAME, Sensor.RecordingLevel.DEBUG, new String[]{"bad-tag"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"Tags needs to be specified in key-value pairs"));
    }

    @Test
    public void shouldThrowIfRateTotalSensorIsAddedWithOddTags() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.streamsMetrics.addRateTotalSensor(SCOPE_NAME, ENTITY_NAME, OPERATION_NAME, Sensor.RecordingLevel.DEBUG, new String[]{"bad-tag"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"Tags needs to be specified in key-value pairs"));
    }

    @Test
    public void shouldGetClientLevelTagMap() {
        Map tagMap = this.streamsMetrics.clientLevelTagMap();
        MatcherAssert.assertThat((Object)tagMap.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((String)tagMap.get("client-id")), (Matcher)Matchers.equalTo((Object)CLIENT_ID));
    }

    @Test
    public void shouldGetStoreLevelTagMap() {
        String taskName = "test-task";
        String storeType = "remote-window";
        String storeName = "window-keeper";
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, THREAD_ID1, VERSION, (Time)this.time);
        Map tagMap = streamsMetrics.storeLevelTagMap("test-task", "remote-window", "window-keeper");
        MatcherAssert.assertThat((Object)tagMap.size(), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)((String)tagMap.get(THREAD_ID_TAG)), (Matcher)Matchers.equalTo((Object)Thread.currentThread().getName()));
        MatcherAssert.assertThat((Object)((String)tagMap.get(TASK_ID_TAG)), (Matcher)Matchers.equalTo((Object)"test-task"));
        MatcherAssert.assertThat((Object)((String)tagMap.get("remote-window-state-id")), (Matcher)Matchers.equalTo((Object)"window-keeper"));
    }

    @Test
    public void shouldGetCacheLevelTagMap() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, THREAD_ID1, VERSION, (Time)this.time);
        String taskName = "taskName";
        String storeName = "storeName";
        Map tagMap = streamsMetrics.cacheLevelTagMap(THREAD_ID1, "taskName", "storeName");
        MatcherAssert.assertThat((Object)tagMap.size(), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)((String)tagMap.get(THREAD_ID_TAG)), (Matcher)Matchers.equalTo((Object)THREAD_ID1));
        MatcherAssert.assertThat((Object)((String)tagMap.get(TASK_ID_TAG)), (Matcher)Matchers.equalTo((Object)"taskName"));
        MatcherAssert.assertThat((Object)((String)tagMap.get(RECORD_CACHE_ID_TAG)), (Matcher)Matchers.equalTo((Object)"storeName"));
    }

    @Test
    public void shouldGetThreadLevelTagMap() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, THREAD_ID1, VERSION, (Time)this.time);
        Map tagMap = streamsMetrics.threadLevelTagMap(THREAD_ID1);
        MatcherAssert.assertThat((Object)tagMap.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((String)tagMap.get(THREAD_ID_TAG)), (Matcher)Matchers.equalTo((Object)THREAD_ID1));
    }

    @Test
    public void shouldAddInvocationRateToSensor() {
        Sensor sensor = (Sensor)PowerMock.createMock(Sensor.class);
        MetricName expectedMetricName = new MetricName("test-metric1-rate", "group", DESCRIPTION1, this.tags);
        EasyMock.expect((Object)sensor.add((MetricName)EasyMock.eq((Object)expectedMetricName), (MeasurableStat)EasyMock.anyObject(Rate.class))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{sensor});
        StreamsMetricsImpl.addInvocationRateToSensor((Sensor)sensor, (String)"group", this.tags, (String)METRIC_NAME1, (String)DESCRIPTION1);
        EasyMock.verify((Object[])new Object[]{sensor});
    }

    @Test
    public void shouldAddAmountRateAndSum() {
        StreamsMetricsImpl.addRateOfSumAndSumMetricsToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"metric", (String)DESCRIPTION1, (String)DESCRIPTION2);
        double valueToRecord1 = 18.0;
        double valueToRecord2 = 72.0;
        long defaultWindowSizeInSeconds = Duration.ofMillis(new MetricConfig().timeWindowMs()).getSeconds();
        double expectedRateMetricValue = 90.0 / (double)defaultWindowSizeInSeconds;
        this.verifyMetric("metric-rate", DESCRIPTION1, 18.0, 72.0, expectedRateMetricValue);
        double expectedSumMetricValue = 180.0;
        this.verifyMetric("metric-total", DESCRIPTION2, 18.0, 72.0, 180.0);
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void shouldAddSum() {
        StreamsMetricsImpl.addSumMetricToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"metric", (String)DESCRIPTION1);
        double valueToRecord1 = 18.0;
        double valueToRecord2 = 42.0;
        double expectedSumMetricValue = 60.0;
        this.verifyMetric("metric-total", DESCRIPTION1, 18.0, 42.0, 60.0);
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void shouldAddAmountRate() {
        StreamsMetricsImpl.addRateOfSumMetricToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"metric", (String)DESCRIPTION1);
        double valueToRecord1 = 18.0;
        double valueToRecord2 = 72.0;
        long defaultWindowSizeInSeconds = Duration.ofMillis(new MetricConfig().timeWindowMs()).getSeconds();
        double expectedRateMetricValue = 90.0 / (double)defaultWindowSizeInSeconds;
        this.verifyMetric("metric-rate", DESCRIPTION1, 18.0, 72.0, expectedRateMetricValue);
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void shouldAddValue() {
        StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"metric", (String)DESCRIPTION1);
        KafkaMetric ratioMetric = this.metrics.metric(new MetricName("metric", "group", DESCRIPTION1, this.tags));
        MatcherAssert.assertThat((Object)ratioMetric, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MetricConfig metricConfig = new MetricConfig();
        double value1 = 42.0;
        this.sensor.record(42.0);
        MatcherAssert.assertThat((Object)ratioMetric.measurable().measure(metricConfig, this.time.milliseconds()), (Matcher)Matchers.equalTo((Object)42.0));
        double value2 = 18.0;
        this.sensor.record(18.0);
        MatcherAssert.assertThat((Object)ratioMetric.measurable().measure(metricConfig, this.time.milliseconds()), (Matcher)Matchers.equalTo((Object)18.0));
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void shouldAddTotalCountAndSumMetricsToSensor() {
        String totalMetricNamePrefix = "total";
        String sumMetricNamePrefix = "count";
        StreamsMetricsImpl.addTotalCountAndSumMetricsToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"total", (String)"count", (String)DESCRIPTION1, (String)DESCRIPTION2);
        double valueToRecord1 = 18.0;
        double valueToRecord2 = 42.0;
        double expectedCountMetricValue = 2.0;
        this.verifyMetric("total-total", DESCRIPTION1, 18.0, 42.0, 2.0);
        double expectedSumMetricValue = 120.0;
        this.verifyMetric("count-total", DESCRIPTION2, 18.0, 42.0, 120.0);
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void shouldAddAvgAndTotalMetricsToSensor() {
        StreamsMetricsImpl.addAvgAndSumMetricsToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"metric", (String)DESCRIPTION1, (String)DESCRIPTION2);
        double valueToRecord1 = 18.0;
        double valueToRecord2 = 42.0;
        double expectedAvgMetricValue = 30.0;
        this.verifyMetric("metric-avg", DESCRIPTION1, 18.0, 42.0, 30.0);
        double expectedSumMetricValue = 120.0;
        this.verifyMetric("metric-total", DESCRIPTION2, 18.0, 42.0, 120.0);
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void shouldAddAvgAndMinAndMaxMetricsToSensor() {
        StreamsMetricsImpl.addAvgAndMinAndMaxToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"metric", (String)DESCRIPTION1, (String)DESCRIPTION2, (String)DESCRIPTION3);
        double valueToRecord1 = 18.0;
        double valueToRecord2 = 42.0;
        double expectedAvgMetricValue = 30.0;
        this.verifyMetric("metric-avg", DESCRIPTION1, 18.0, 42.0, 30.0);
        this.verifyMetric("metric-min", DESCRIPTION2, 18.0, 42.0, 18.0);
        this.verifyMetric("metric-max", DESCRIPTION3, 18.0, 42.0, 42.0);
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)4));
    }

    @Test
    public void shouldAddMinAndMaxMetricsToSensor() {
        StreamsMetricsImpl.addMinAndMaxToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"metric", (String)DESCRIPTION1, (String)DESCRIPTION2);
        double valueToRecord1 = 18.0;
        double valueToRecord2 = 42.0;
        this.verifyMetric("metric-min", DESCRIPTION1, 18.0, 42.0, 18.0);
        this.verifyMetric("metric-max", DESCRIPTION2, 18.0, 42.0, 42.0);
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void shouldReturnMetricsVersionCurrent() {
        MatcherAssert.assertThat((Object)new StreamsMetricsImpl(this.metrics, THREAD_ID1, VERSION, (Time)this.time).version(), (Matcher)Matchers.equalTo((Object)StreamsMetricsImpl.Version.LATEST));
    }

    private void verifyMetric(String name, String description, double valueToRecord1, double valueToRecord2, double expectedMetricValue) {
        KafkaMetric metric = this.metrics.metric(new MetricName(name, "group", description, this.tags));
        MatcherAssert.assertThat((Object)metric, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)metric.metricName().description(), (Matcher)Matchers.equalTo((Object)description));
        this.sensor.record(valueToRecord1, this.time.milliseconds());
        this.sensor.record(valueToRecord2, this.time.milliseconds());
        MatcherAssert.assertThat((Object)metric.measurable().measure(new MetricConfig(), this.time.milliseconds()), (Matcher)Matchers.equalTo((Object)expectedMetricValue));
    }

    @Test
    public void shouldMeasureLatency() {
        long startTime = 6L;
        long endTime = 10L;
        Sensor sensor = (Sensor)PowerMock.createMock(Sensor.class);
        EasyMock.expect((Object)sensor.shouldRecord()).andReturn((Object)true);
        EasyMock.expect((Object)sensor.hasMetrics()).andReturn((Object)true);
        sensor.record(4.0);
        Time time = (Time)EasyMock.mock(Time.class);
        EasyMock.expect((Object)time.nanoseconds()).andReturn((Object)6L);
        EasyMock.expect((Object)time.nanoseconds()).andReturn((Object)10L);
        EasyMock.replay((Object[])new Object[]{sensor, time});
        StreamsMetricsImpl.maybeMeasureLatency(() -> {}, (Time)time, (Sensor)sensor);
        EasyMock.verify((Object[])new Object[]{sensor, time});
    }

    @Test
    public void shouldNotMeasureLatencyDueToRecordingLevel() {
        Sensor sensor = (Sensor)PowerMock.createMock(Sensor.class);
        EasyMock.expect((Object)sensor.shouldRecord()).andReturn((Object)false);
        Time time = (Time)EasyMock.mock(Time.class);
        EasyMock.replay((Object[])new Object[]{sensor});
        StreamsMetricsImpl.maybeMeasureLatency(() -> {}, (Time)time, (Sensor)sensor);
        EasyMock.verify((Object[])new Object[]{sensor});
    }

    @Test
    public void shouldNotMeasureLatencyBecauseSensorHasNoMetrics() {
        Sensor sensor = (Sensor)PowerMock.createMock(Sensor.class);
        EasyMock.expect((Object)sensor.shouldRecord()).andReturn((Object)true);
        EasyMock.expect((Object)sensor.hasMetrics()).andReturn((Object)false);
        Time time = (Time)EasyMock.mock(Time.class);
        EasyMock.replay((Object[])new Object[]{sensor});
        StreamsMetricsImpl.maybeMeasureLatency(() -> {}, (Time)time, (Sensor)sensor);
        EasyMock.verify((Object[])new Object[]{sensor});
    }

    @Test
    public void shouldAddThreadLevelMutableMetric() {
        int measuredValue = 123;
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, THREAD_ID1, VERSION, (Time)this.time);
        streamsMetrics.addThreadLevelMutableMetric("foobar", "test metric", "t1", (c, t) -> 123);
        MetricName name = this.metrics.metricName("foobar", "stream-thread-metrics", Collections.singletonMap(THREAD_ID_TAG, "t1"));
        MatcherAssert.assertThat((Object)this.metrics.metric(name), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)this.metrics.metric(name).metricValue(), (Matcher)Matchers.equalTo((Object)123));
    }

    @Test
    public void shouldCleanupThreadLevelMutableMetric() {
        int measuredValue = 123;
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, THREAD_ID1, VERSION, (Time)this.time);
        streamsMetrics.addThreadLevelMutableMetric("foobar", "test metric", "t1", (c, t) -> 123);
        streamsMetrics.removeAllThreadLevelMetrics("t1");
        MetricName name = this.metrics.metricName("foobar", "stream-thread-metrics", Collections.singletonMap(THREAD_ID_TAG, "t1"));
        MatcherAssert.assertThat((Object)this.metrics.metric(name), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldAddThreadLevelImmutableMetric() {
        int measuredValue = 123;
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, THREAD_ID1, VERSION, (Time)this.time);
        streamsMetrics.addThreadLevelImmutableMetric("foobar", "test metric", "t1", (Object)123);
        MetricName name = this.metrics.metricName("foobar", "stream-thread-metrics", Collections.singletonMap(THREAD_ID_TAG, "t1"));
        MatcherAssert.assertThat((Object)this.metrics.metric(name), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)this.metrics.metric(name).metricValue(), (Matcher)Matchers.equalTo((Object)123));
    }

    @Test
    public void shouldCleanupThreadLevelImmutableMetric() {
        int measuredValue = 123;
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, THREAD_ID1, VERSION, (Time)this.time);
        streamsMetrics.addThreadLevelImmutableMetric("foobar", "test metric", "t1", (Object)123);
        streamsMetrics.removeAllThreadLevelMetrics("t1");
        MetricName name = this.metrics.metricName("foobar", "stream-thread-metrics", Collections.singletonMap(THREAD_ID_TAG, "t1"));
        MatcherAssert.assertThat((Object)this.metrics.metric(name), (Matcher)CoreMatchers.nullValue());
    }
}

