/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Iterator;
import java.util.Set;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.internals.TransformerSupplierAdapter;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.StoreBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsSame;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class TransformerSupplierAdapterTest {
    @Mock
    private ProcessorContext context;
    @Mock
    private Transformer<String, String, KeyValue<Integer, Integer>> transformer;
    @Mock
    private TransformerSupplier<String, String, KeyValue<Integer, Integer>> transformerSupplier;
    @Mock
    private Set<StoreBuilder<?>> stores;
    final String key = "Hello";
    final String value = "World";

    @Test
    public void shouldCallInitOfAdaptedTransformer() {
        Mockito.when((Object)this.transformerSupplier.get()).thenReturn(this.transformer);
        TransformerSupplierAdapter adapter = new TransformerSupplierAdapter(this.transformerSupplier);
        Transformer adaptedTransformer = adapter.get();
        adaptedTransformer.init(this.context);
        ((Transformer)Mockito.verify(this.transformer)).init(this.context);
    }

    @Test
    public void shouldCallCloseOfAdaptedTransformer() {
        Mockito.when((Object)this.transformerSupplier.get()).thenReturn(this.transformer);
        TransformerSupplierAdapter adapter = new TransformerSupplierAdapter(this.transformerSupplier);
        Transformer adaptedTransformer = adapter.get();
        adaptedTransformer.close();
        ((Transformer)Mockito.verify(this.transformer)).close();
    }

    @Test
    public void shouldCallStoresOfAdaptedTransformerSupplier() {
        Mockito.when((Object)this.transformerSupplier.stores()).thenReturn(this.stores);
        TransformerSupplierAdapter adapter = new TransformerSupplierAdapter(this.transformerSupplier);
        adapter.stores();
    }

    @Test
    public void shouldCallTransformOfAdaptedTransformerAndReturnSingletonIterable() {
        Mockito.when((Object)this.transformerSupplier.get()).thenReturn(this.transformer);
        Mockito.when((Object)((KeyValue)this.transformer.transform((Object)"Hello", (Object)"World"))).thenReturn((Object)KeyValue.pair((Object)0, (Object)1));
        TransformerSupplierAdapter adapter = new TransformerSupplierAdapter(this.transformerSupplier);
        Transformer adaptedTransformer = adapter.get();
        Iterator iterator = ((Iterable)adaptedTransformer.transform((Object)"Hello", (Object)"World")).iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)IsEqual.equalTo((Object)true));
        iterator.next();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)IsEqual.equalTo((Object)false));
    }

    @Test
    public void shouldCallTransformOfAdaptedTransformerAndReturnEmptyIterable() {
        Mockito.when((Object)this.transformerSupplier.get()).thenReturn(this.transformer);
        Mockito.when((Object)((KeyValue)this.transformer.transform((Object)"Hello", (Object)"World"))).thenReturn(null);
        TransformerSupplierAdapter adapter = new TransformerSupplierAdapter(this.transformerSupplier);
        Transformer adaptedTransformer = adapter.get();
        Iterator iterator = ((Iterable)adaptedTransformer.transform((Object)"Hello", (Object)"World")).iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)IsEqual.equalTo((Object)false));
    }

    @Test
    public void shouldAlwaysGetNewAdapterTransformer() {
        Transformer transformer1 = (Transformer)Mockito.mock(Transformer.class);
        Transformer transformer2 = (Transformer)Mockito.mock(Transformer.class);
        Transformer transformer3 = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)this.transformerSupplier.get()).thenReturn((Object)transformer1).thenReturn((Object)transformer2).thenReturn((Object)transformer3);
        TransformerSupplierAdapter adapter = new TransformerSupplierAdapter(this.transformerSupplier);
        Transformer adapterTransformer1 = adapter.get();
        adapterTransformer1.init(this.context);
        Transformer adapterTransformer2 = adapter.get();
        adapterTransformer2.init(this.context);
        Transformer adapterTransformer3 = adapter.get();
        adapterTransformer3.init(this.context);
        MatcherAssert.assertThat((Object)adapterTransformer1, (Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)adapterTransformer2)));
        MatcherAssert.assertThat((Object)adapterTransformer2, (Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)adapterTransformer3)));
        MatcherAssert.assertThat((Object)adapterTransformer3, (Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)adapterTransformer1)));
        ((Transformer)Mockito.verify((Object)transformer1)).init(this.context);
        ((Transformer)Mockito.verify((Object)transformer2)).init(this.context);
        ((Transformer)Mockito.verify((Object)transformer3)).init(this.context);
    }
}

