/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals;

import java.time.Duration;
import java.time.Instant;
import org.apache.kafka.streams.internals.ApiUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ApiUtilsTest {
    private static final long MAX_ACCEPTABLE_DAYS_FOR_DURATION = 106751991167300L;
    private static final long MAX_ACCEPTABLE_DAYS_FOR_DURATION_TO_MILLIS = 106751991167L;

    @Test
    public void shouldThrowNullPointerExceptionForNullDuration() {
        String nullDurationPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(null, (String)"nullDuration");
        try {
            ApiUtils.validateMillisecondDuration(null, (String)nullDurationPrefix);
            Assert.fail((String)"Expected exception when null passed to duration.");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)nullDurationPrefix));
        }
    }

    @Test
    public void shouldThrowArithmeticExceptionForMaxDuration() {
        Duration maxDurationInDays = Duration.ofDays(106751991167300L);
        String maxDurationPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix((Object)maxDurationInDays, (String)"maxDuration");
        try {
            ApiUtils.validateMillisecondDuration((Duration)maxDurationInDays, (String)maxDurationPrefix);
            Assert.fail((String)"Expected exception when maximum days passed for duration, because of long overflow");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)maxDurationPrefix));
        }
    }

    @Test
    public void shouldThrowNullPointerExceptionForNullInstant() {
        String nullInstantPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(null, (String)"nullInstant");
        try {
            ApiUtils.validateMillisecondInstant(null, (String)nullInstantPrefix);
            Assert.fail((String)"Expected exception when null value passed for instant.");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)nullInstantPrefix));
        }
    }

    @Test
    public void shouldThrowArithmeticExceptionForMaxInstant() {
        String maxInstantPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix((Object)Instant.MAX, (String)"maxInstant");
        try {
            ApiUtils.validateMillisecondInstant((Instant)Instant.MAX, (String)maxInstantPrefix);
            Assert.fail((String)"Expected exception when maximum value passed for instant, because of long overflow.");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)maxInstantPrefix));
        }
    }

    @Test
    public void shouldReturnMillisecondsOnValidDuration() {
        Duration sampleDuration = Duration.ofDays(106751991167L);
        Assert.assertEquals((long)sampleDuration.toMillis(), (long)ApiUtils.validateMillisecondDuration((Duration)sampleDuration, (String)"sampleDuration"));
    }

    @Test
    public void shouldReturnMillisecondsOnValidInstant() {
        Instant sampleInstant = Instant.now();
        Assert.assertEquals((long)sampleInstant.toEpochMilli(), (long)ApiUtils.validateMillisecondInstant((Instant)sampleInstant, (String)"sampleInstant"));
    }

    @Test
    public void shouldContainsNameAndValueInFailMsgPrefix() {
        String failMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix((Object)"someValue", (String)"variableName");
        MatcherAssert.assertThat((Object)failMsgPrefix, (Matcher)CoreMatchers.containsString((String)"variableName"));
        MatcherAssert.assertThat((Object)failMsgPrefix, (Matcher)CoreMatchers.containsString((String)"someValue"));
    }
}

