/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.mapr;

import com.mapr.fs.MapRFileAce;
import java.io.IOException;
import org.apache.hadoop.io.PermissionNotMatchException;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.mapr.tools.KafkaMaprStreams;
import org.apache.kafka.mapr.tools.KafkaMaprTools;
import org.apache.kafka.mapr.tools.KafkaMaprfs;
import org.apache.kafka.mapr.tools.MaprfsPermissions;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.mapr.InternalStreamNotExistException;

public class KafkaStreamsInternalStorageInitializer {
    public static void createAppDirAndInternalStreams(StreamsConfig config) {
        try (KafkaMaprStreams maprStreams = KafkaMaprTools.tools().streams();){
            KafkaStreamsInternalStorageInitializer.createAppDir(config);
            KafkaStreamsInternalStorageInitializer.createInternalStreams(maprStreams, config);
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    private static void createAppDir(StreamsConfig config) throws IOException {
        KafkaMaprfs maprfs = KafkaMaprTools.tools().maprfs();
        maprfs.requireExisting("/apps/kafka-streams/");
        String internalFolder = config.getStreamsInternalStreamFolder();
        if (!maprfs.exists(internalFolder)) {
            maprfs.mkdirs(internalFolder);
            maprfs.setPermissions(internalFolder, MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, "p").put(MapRFileAce.AccessType.LOOKUPDIR, "p").put(MapRFileAce.AccessType.ADDCHILD, "<startup.user>").put(MapRFileAce.AccessType.DELETECHILD, "<startup.user>").put(MapRFileAce.AccessType.WRITEFILE, "<startup.user>").loadFromConfig(config.getString("streams.appdir.aces")));
        }
        if (!maprfs.isAccessibleAsDirectory(internalFolder)) {
            String user = KafkaMaprTools.tools().getCurrentUserName();
            String applicationId = config.getString("application.id");
            throw new PermissionNotMatchException(String.format("User '%s' has no permissions to run KStreams application with ID '%s'", user, applicationId));
        }
    }

    private static void createInternalStreams(KafkaMaprStreams maprStreams, StreamsConfig config) {
        if (!maprStreams.streamExists(config.getStreamsInternalStreamNotcompacted())) {
            maprStreams.createStreamForClusterAdmin(config.getStreamsInternalStreamNotcompacted());
        }
        if (!maprStreams.streamExists(config.getStreamsInternalStreamCompacted())) {
            maprStreams.createStreamForCurrentUser(config.getStreamsInternalStreamCompacted());
        }
        maprStreams.ensureStreamLogCompactionIsEnabled(config.getStreamsInternalStreamCompacted());
        String cliSideAssignmentInternalStream = config.getStreamsCliSideAssignmentInternalStream();
        if (!maprStreams.streamExists(cliSideAssignmentInternalStream)) {
            throw new InternalStreamNotExistException(cliSideAssignmentInternalStream + " doesn't exist");
        }
    }
}

