/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.MeteredWindowStoreIterator;
import org.apache.kafka.streams.state.internals.MeteredWindowedKeyValueIterator;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.streams.state.internals.metrics.StateStoreMetrics;

public class MeteredWindowStore<K, V>
extends WrappedStateStore<WindowStore<Bytes, byte[]>, Windowed<K>, V>
implements WindowStore<K, V> {
    private final long windowSizeMs;
    private final String metricsScope;
    private final Time time;
    final Serde<K> keySerde;
    final Serde<V> valueSerde;
    StateSerdes<K, V> serdes;
    private StreamsMetricsImpl streamsMetrics;
    private Sensor putSensor;
    private Sensor fetchSensor;
    private Sensor flushSensor;
    private ProcessorContext context;
    private final String threadId;
    private String taskId;

    MeteredWindowStore(WindowStore<Bytes, byte[]> inner, long windowSizeMs, String metricsScope, Time time, Serde<K> keySerde, Serde<V> valueSerde) {
        super(inner);
        this.windowSizeMs = windowSizeMs;
        this.threadId = Thread.currentThread().getName();
        this.metricsScope = metricsScope;
        this.time = time;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.context = context;
        this.initStoreSerde(context);
        this.streamsMetrics = (StreamsMetricsImpl)context.metrics();
        this.taskId = context.taskId().toString();
        this.putSensor = StateStoreMetrics.putSensor(this.threadId, this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        this.fetchSensor = StateStoreMetrics.fetchSensor(this.threadId, this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        this.flushSensor = StateStoreMetrics.flushSensor(this.threadId, this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        Sensor restoreSensor = StateStoreMetrics.restoreSensor(this.threadId, this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.init(context, root), this.time, restoreSensor);
    }

    protected Serde<V> prepareValueSerde(Serde<V> valueSerde, Serde<?> contextKeySerde, Serde<?> contextValueSerde) {
        return WrappingNullableUtils.prepareValueSerde(valueSerde, contextKeySerde, contextValueSerde);
    }

    void initStoreSerde(ProcessorContext context) {
        this.serdes = new StateSerdes<K, V>(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name(), context.applicationInternalStream()), WrappingNullableUtils.prepareKeySerde(this.keySerde, context.keySerde(), context.valueSerde()), this.prepareValueSerde(this.valueSerde, context.keySerde(), context.valueSerde()));
    }

    @Override
    public boolean setFlushListener(CacheFlushListener<Windowed<K>, V> listener, boolean sendOldValues) {
        WindowStore wrapped = (WindowStore)this.wrapped();
        if (wrapped instanceof CachedStateStore) {
            return ((CachedStateStore)((Object)wrapped)).setFlushListener((K key, V newValue, V oldValue, long timestamp) -> listener.apply(WindowKeySchema.fromStoreKey(key, this.windowSizeMs, this.serdes.keyDeserializer(), this.serdes.topic()), newValue != null ? (Object)this.serdes.valueFrom((byte[])newValue) : null, oldValue != null ? (Object)this.serdes.valueFrom((byte[])oldValue) : null, timestamp), sendOldValues);
        }
        return false;
    }

    @Override
    @Deprecated
    public void put(K key, V value) {
        this.put(key, value, this.context.timestamp());
    }

    @Override
    public void put(K key, V value, long windowStartTimestamp) {
        try {
            StreamsMetricsImpl.maybeMeasureLatency(() -> ((WindowStore)this.wrapped()).put(this.keyBytes(key), this.serdes.rawValue(value), windowStartTimestamp), this.time, this.putSensor);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key, value);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public V fetch(K key, long timestamp) {
        return (V)StreamsMetricsImpl.maybeMeasureLatency(() -> {
            byte[] result = (byte[])((WindowStore)this.wrapped()).fetch(this.keyBytes(key), timestamp);
            if (result == null) {
                return null;
            }
            return this.serdes.valueFrom(result);
        }, this.time, this.fetchSensor);
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        return new MeteredWindowStoreIterator<V>(((WindowStore)this.wrapped()).fetch(this.keyBytes(key), timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K from, K to, long timeFrom, long timeTo) {
        return new MeteredWindowedKeyValueIterator<K, V>(((WindowStore)this.wrapped()).fetch(this.keyBytes(from), this.keyBytes(to), timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetchAll(long timeFrom, long timeTo) {
        return new MeteredWindowedKeyValueIterator<K, V>(((WindowStore)this.wrapped()).fetchAll(timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> all() {
        return new MeteredWindowedKeyValueIterator<K, V>(((WindowStore)this.wrapped()).all(), this.fetchSensor, this.streamsMetrics, this.serdes, this.time);
    }

    @Override
    public void flush() {
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.flush(), this.time, this.flushSensor);
    }

    @Override
    public void close() {
        try {
            ((WindowStore)this.wrapped()).close();
        }
        finally {
            this.streamsMetrics.removeAllStoreLevelSensors(this.threadId, this.taskId, this.name());
        }
    }

    private Bytes keyBytes(K key) {
        return Bytes.wrap((byte[])this.serdes.rawKey(key));
    }
}

