/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.List;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

abstract class AbstractReadOnlyDecorator<T extends StateStore, K, V>
extends WrappedStateStore<T, K, V> {
    static final String ERROR_MESSAGE = "Global store is read only";

    private AbstractReadOnlyDecorator(T inner) {
        super(inner);
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    static StateStore getReadOnlyStore(StateStore global) {
        if (global instanceof TimestampedKeyValueStore) {
            return new TimestampedKeyValueStoreReadOnlyDecorator((TimestampedKeyValueStore)global);
        }
        if (global instanceof KeyValueStore) {
            return new KeyValueStoreReadOnlyDecorator((KeyValueStore)global);
        }
        if (global instanceof TimestampedWindowStore) {
            return new TimestampedWindowStoreReadOnlyDecorator((TimestampedWindowStore)global);
        }
        if (global instanceof WindowStore) {
            return new WindowStoreReadOnlyDecorator((WindowStore)global);
        }
        if (global instanceof SessionStore) {
            return new SessionStoreReadOnlyDecorator((SessionStore)global);
        }
        return global;
    }

    /* synthetic */ AbstractReadOnlyDecorator(StateStore x0, 1 x1) {
        this(x0);
    }

    static class SessionStoreReadOnlyDecorator<K, AGG>
    extends AbstractReadOnlyDecorator<SessionStore<K, AGG>, K, AGG>
    implements SessionStore<K, AGG> {
        private SessionStoreReadOnlyDecorator(SessionStore<K, AGG> inner) {
            super(inner, null);
        }

        @Override
        public KeyValueIterator<Windowed<K>, AGG> findSessions(K key, long earliestSessionEndTime, long latestSessionStartTime) {
            return ((SessionStore)this.wrapped()).findSessions(key, earliestSessionEndTime, latestSessionStartTime);
        }

        @Override
        public KeyValueIterator<Windowed<K>, AGG> findSessions(K keyFrom, K keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
            return ((SessionStore)this.wrapped()).findSessions(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
        }

        @Override
        public void remove(Windowed<K> sessionKey) {
            throw new UnsupportedOperationException(AbstractReadOnlyDecorator.ERROR_MESSAGE);
        }

        @Override
        public void put(Windowed<K> sessionKey, AGG aggregate) {
            throw new UnsupportedOperationException(AbstractReadOnlyDecorator.ERROR_MESSAGE);
        }

        @Override
        public AGG fetchSession(K key, long startTime, long endTime) {
            return ((SessionStore)this.wrapped()).fetchSession(key, startTime, endTime);
        }

        @Override
        public KeyValueIterator<Windowed<K>, AGG> fetch(K key) {
            return ((SessionStore)this.wrapped()).fetch(key);
        }

        @Override
        public KeyValueIterator<Windowed<K>, AGG> fetch(K from, K to) {
            return ((SessionStore)this.wrapped()).fetch(from, to);
        }
    }

    static class TimestampedWindowStoreReadOnlyDecorator<K, V>
    extends WindowStoreReadOnlyDecorator<K, ValueAndTimestamp<V>>
    implements TimestampedWindowStore<K, V> {
        private TimestampedWindowStoreReadOnlyDecorator(TimestampedWindowStore<K, V> inner) {
            super(inner);
        }
    }

    static class WindowStoreReadOnlyDecorator<K, V>
    extends AbstractReadOnlyDecorator<WindowStore<K, V>, K, V>
    implements WindowStore<K, V> {
        private WindowStoreReadOnlyDecorator(WindowStore<K, V> inner) {
            super(inner, null);
        }

        @Override
        @Deprecated
        public void put(K key, V value) {
            throw new UnsupportedOperationException(AbstractReadOnlyDecorator.ERROR_MESSAGE);
        }

        @Override
        public void put(K key, V value, long windowStartTimestamp) {
            throw new UnsupportedOperationException(AbstractReadOnlyDecorator.ERROR_MESSAGE);
        }

        @Override
        public V fetch(K key, long time) {
            return ((WindowStore)this.wrapped()).fetch(key, time);
        }

        @Override
        @Deprecated
        public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).fetch(key, timeFrom, timeTo);
        }

        @Override
        @Deprecated
        public KeyValueIterator<Windowed<K>, V> fetch(K from, K to, long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).fetch(from, to, timeFrom, timeTo);
        }

        @Override
        public KeyValueIterator<Windowed<K>, V> all() {
            return ((WindowStore)this.wrapped()).all();
        }

        @Override
        @Deprecated
        public KeyValueIterator<Windowed<K>, V> fetchAll(long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).fetchAll(timeFrom, timeTo);
        }
    }

    static class TimestampedKeyValueStoreReadOnlyDecorator<K, V>
    extends KeyValueStoreReadOnlyDecorator<K, ValueAndTimestamp<V>>
    implements TimestampedKeyValueStore<K, V> {
        private TimestampedKeyValueStoreReadOnlyDecorator(TimestampedKeyValueStore<K, V> inner) {
            super(inner);
        }
    }

    static class KeyValueStoreReadOnlyDecorator<K, V>
    extends AbstractReadOnlyDecorator<KeyValueStore<K, V>, K, V>
    implements KeyValueStore<K, V> {
        private KeyValueStoreReadOnlyDecorator(KeyValueStore<K, V> inner) {
            super(inner, null);
        }

        @Override
        public V get(K key) {
            return ((KeyValueStore)this.wrapped()).get(key);
        }

        @Override
        public KeyValueIterator<K, V> range(K from, K to) {
            return ((KeyValueStore)this.wrapped()).range(from, to);
        }

        @Override
        public KeyValueIterator<K, V> all() {
            return ((KeyValueStore)this.wrapped()).all();
        }

        @Override
        public long approximateNumEntries() {
            return ((KeyValueStore)this.wrapped()).approximateNumEntries();
        }

        @Override
        public void put(K key, V value) {
            throw new UnsupportedOperationException(AbstractReadOnlyDecorator.ERROR_MESSAGE);
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw new UnsupportedOperationException(AbstractReadOnlyDecorator.ERROR_MESSAGE);
        }

        @Override
        public void putAll(List<KeyValue<K, V>> entries) {
            throw new UnsupportedOperationException(AbstractReadOnlyDecorator.ERROR_MESSAGE);
        }

        @Override
        public V delete(K key) {
            throw new UnsupportedOperationException(AbstractReadOnlyDecorator.ERROR_MESSAGE);
        }
    }
}

