/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Objects;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.ProcessorNodeMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.MeteredTimestampedKeyValueStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KTableSource<K, V>
implements ProcessorSupplier<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(KTableSource.class);
    private final String storeName;
    private String queryableName;
    private boolean sendOldValues;

    public KTableSource(String storeName, String queryableName) {
        Objects.requireNonNull(storeName, "storeName can't be null");
        this.storeName = storeName;
        this.queryableName = queryableName;
        this.sendOldValues = false;
    }

    public String queryableName() {
        return this.queryableName;
    }

    @Override
    public Processor<K, V> get() {
        return new KTableSourceProcessor();
    }

    public void enableSendingOldValues() {
        this.sendOldValues = true;
        this.queryableName = this.storeName;
    }

    public void materialize() {
        this.queryableName = this.storeName;
    }

    public boolean materialized() {
        return this.queryableName != null;
    }

    private class KTableSourceProcessor
    extends AbstractProcessor<K, V> {
        private MeteredTimestampedKeyValueStore<K, V> store;
        private TimestampedTupleForwarder<K, V> tupleForwarder;
        private StreamsMetricsImpl metrics;
        private Sensor droppedRecordsSensor;
        private Sensor skippedIdempotentUpdatesSensor = null;

        private KTableSourceProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.metrics = (StreamsMetricsImpl)context.metrics();
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensorOrSkippedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), this.metrics);
            if (KTableSource.this.queryableName != null) {
                StateStore stateStore = context.getStateStore(KTableSource.this.queryableName);
                try {
                    this.store = (MeteredTimestampedKeyValueStore)((WrappedStateStore)stateStore).wrapped();
                }
                catch (ClassCastException e) {
                    throw new IllegalStateException("Unexpected store type: " + stateStore.getClass() + " for store: " + KTableSource.this.queryableName, e);
                }
                this.tupleForwarder = new TimestampedTupleForwarder(this.store, context, new TimestampedCacheFlushListener(context), KTableSource.this.sendOldValues);
                this.skippedIdempotentUpdatesSensor = ProcessorNodeMetrics.skippedIdempotentUpdatesSensor(Thread.currentThread().getName(), context.taskId().toString(), ((InternalProcessorContext)context).currentNode().name(), this.metrics);
            }
        }

        @Override
        public void process(K key, V value) {
            if (key == null) {
                LOG.warn("Skipping record due to null key. topic=[{}] partition=[{}] offset=[{}]", new Object[]{this.context().topic(), this.context().partition(), this.context().offset()});
                this.droppedRecordsSensor.record();
                return;
            }
            if (KTableSource.this.queryableName != null) {
                ValueAndTimestamp newValueAndTimestamp;
                boolean isDifferentValue;
                Object oldValue;
                MeteredTimestampedKeyValueStore.RawAndDeserializedValue tuple = this.store.getWithBinary(key);
                ValueAndTimestamp oldValueAndTimestamp = tuple.value;
                if (oldValueAndTimestamp != null) {
                    oldValue = oldValueAndTimestamp.value();
                    if (this.context().timestamp() < oldValueAndTimestamp.timestamp()) {
                        LOG.warn("Detected out-of-order KTable update for {} at offset {}, partition {}.", new Object[]{this.store.name(), this.context().offset(), this.context().partition()});
                    }
                } else {
                    oldValue = null;
                }
                if (isDifferentValue = this.store.putIfDifferentValues(key, newValueAndTimestamp = ValueAndTimestamp.make(value, this.context().timestamp()), tuple.serializedValue)) {
                    this.tupleForwarder.maybeForward(key, value, oldValue);
                } else {
                    this.skippedIdempotentUpdatesSensor.record();
                }
            } else {
                this.context().forward(key, new Change<Object>(value, null));
            }
        }
    }
}

