/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.test.TestRecord;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestTopicsTest {
    private static final String INPUT_TOPIC = "input";
    private static final String OUTPUT_TOPIC = "output1";
    private static final String INPUT_TOPIC_MAP = "output1";
    private static final String OUTPUT_TOPIC_MAP = "output2";
    private TopologyTestDriver testDriver;
    private final Serde<String> stringSerde = new Serdes.StringSerde();
    private final Serde<Long> longSerde = new Serdes.LongSerde();
    private final Instant testBaseTime = Instant.parse("2019-06-01T10:00:00Z");

    @BeforeEach
    public void setup() {
        StreamsBuilder builder = new StreamsBuilder();
        builder.stream(INPUT_TOPIC).to("output1");
        KStream source = builder.stream("output1", Consumed.with(this.longSerde, this.stringSerde));
        KStream mapped = source.map((key, value) -> new KeyValue(value, key));
        mapped.to(OUTPUT_TOPIC_MAP, Produced.with(this.stringSerde, this.longSerde));
        Properties properties = new Properties();
        properties.put("default.key.serde", Serdes.ByteArraySerde.class);
        properties.put("default.value.serde", Serdes.ByteArraySerde.class);
        this.testDriver = new TopologyTestDriver(builder.build(), properties);
    }

    @AfterEach
    public void tearDown() {
        this.testDriver.close();
    }

    @Test
    public void testValue() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic(INPUT_TOPIC, this.stringSerde.serializer(), this.stringSerde.serializer());
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic("output1", this.stringSerde.deserializer(), this.stringSerde.deserializer());
        inputTopic.pipeInput((Object)"Hello");
        MatcherAssert.assertThat((Object)((String)outputTopic.readValue()), (Matcher)CoreMatchers.equalTo((Object)"Hello"));
        MatcherAssert.assertThat((Object)outputTopic.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testValueList() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic(INPUT_TOPIC, this.stringSerde.serializer(), this.stringSerde.serializer());
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic("output1", this.stringSerde.deserializer(), this.stringSerde.deserializer());
        List<String> inputList = Arrays.asList("This", "is", "an", "example");
        inputTopic.pipeValueList(inputList);
        List output = outputTopic.readValuesToList();
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"This", "is", "an", "example"}));
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(inputList)));
    }

    @Test
    public void testKeyValue() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic(INPUT_TOPIC, this.longSerde.serializer(), this.stringSerde.serializer());
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic("output1", this.longSerde.deserializer(), this.stringSerde.deserializer());
        inputTopic.pipeInput((Object)1L, (Object)"Hello");
        MatcherAssert.assertThat((Object)outputTopic.readKeyValue(), (Matcher)CoreMatchers.equalTo((Object)new KeyValue((Object)1L, (Object)"Hello")));
        MatcherAssert.assertThat((Object)outputTopic.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testKeyValueList() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic("output1", this.longSerde.serializer(), this.stringSerde.serializer());
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic(OUTPUT_TOPIC_MAP, this.stringSerde.deserializer(), this.longSerde.deserializer());
        List<String> inputList = Arrays.asList("This", "is", "an", "example");
        LinkedList<KeyValue> input = new LinkedList<KeyValue>();
        LinkedList<KeyValue> expected = new LinkedList<KeyValue>();
        long i = 0L;
        for (String s : inputList) {
            input.add(new KeyValue((Object)i, (Object)s));
            expected.add(new KeyValue((Object)s, (Object)i));
            ++i;
        }
        inputTopic.pipeKeyValueList(input);
        List output = outputTopic.readKeyValuesToList();
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(expected)));
    }

    @Test
    public void testKeyValuesToMap() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic("output1", this.longSerde.serializer(), this.stringSerde.serializer());
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic(OUTPUT_TOPIC_MAP, this.stringSerde.deserializer(), this.longSerde.deserializer());
        List<String> inputList = Arrays.asList("This", "is", "an", "example");
        LinkedList<KeyValue> input = new LinkedList<KeyValue>();
        HashMap<String, Long> expected = new HashMap<String, Long>();
        long i = 0L;
        for (String s : inputList) {
            input.add(new KeyValue((Object)i, (Object)s));
            expected.put(s, i);
            ++i;
        }
        inputTopic.pipeKeyValueList(input);
        Map output = outputTopic.readKeyValuesToMap();
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(expected)));
    }

    @Test
    public void testKeyValuesToMapWithNull() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic(INPUT_TOPIC, this.longSerde.serializer(), this.stringSerde.serializer());
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic("output1", this.longSerde.deserializer(), this.stringSerde.deserializer());
        inputTopic.pipeInput((Object)"value");
        Assertions.assertThrows(IllegalStateException.class, () -> ((TestOutputTopic)outputTopic).readKeyValuesToMap());
    }

    @Test
    public void testKeyValueListDuration() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic("output1", this.longSerde.serializer(), this.stringSerde.serializer());
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic(OUTPUT_TOPIC_MAP, this.stringSerde.deserializer(), this.longSerde.deserializer());
        List<String> inputList = Arrays.asList("This", "is", "an", "example");
        LinkedList<KeyValue> input = new LinkedList<KeyValue>();
        LinkedList<TestRecord> expected = new LinkedList<TestRecord>();
        long i = 0L;
        Duration advance = Duration.ofSeconds(15L);
        Instant recordInstant = this.testBaseTime;
        for (String s : inputList) {
            input.add(new KeyValue((Object)i, (Object)s));
            expected.add(new TestRecord((Object)s, (Object)i, recordInstant));
            ++i;
            recordInstant = recordInstant.plus(advance);
        }
        inputTopic.pipeKeyValueList(input, this.testBaseTime, advance);
        List output = outputTopic.readRecordsToList();
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(expected)));
    }

    @Test
    public void testRecordList() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic("output1", this.longSerde.serializer(), this.stringSerde.serializer());
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic(OUTPUT_TOPIC_MAP, this.stringSerde.deserializer(), this.longSerde.deserializer());
        List<String> inputList = Arrays.asList("This", "is", "an", "example");
        LinkedList<TestRecord> input = new LinkedList<TestRecord>();
        LinkedList<TestRecord> expected = new LinkedList<TestRecord>();
        Duration advance = Duration.ofSeconds(15L);
        Instant recordInstant = this.testBaseTime;
        Long i = 0L;
        for (String s : inputList) {
            input.add(new TestRecord((Object)i, (Object)s, recordInstant));
            expected.add(new TestRecord((Object)s, (Object)i, recordInstant));
            Long l = i;
            Long l2 = i = Long.valueOf(i + 1L);
            recordInstant = recordInstant.plus(advance);
        }
        inputTopic.pipeRecordList(input);
        List output = outputTopic.readRecordsToList();
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(expected)));
    }

    @Test
    public void testTimestamp() {
        long baseTime = 3L;
        TestInputTopic inputTopic = this.testDriver.createInputTopic(INPUT_TOPIC, this.longSerde.serializer(), this.stringSerde.serializer());
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic("output1", this.longSerde.deserializer(), this.stringSerde.deserializer());
        inputTopic.pipeInput(null, (Object)"Hello", baseTime);
        MatcherAssert.assertThat((Object)outputTopic.readRecord(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new TestRecord(null, (Object)"Hello", null, Long.valueOf(baseTime)))));
        inputTopic.pipeInput((Object)2L, (Object)"Kafka", ++baseTime);
        MatcherAssert.assertThat((Object)outputTopic.readRecord(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new TestRecord((Object)2L, (Object)"Kafka", null, Long.valueOf(baseTime)))));
        inputTopic.pipeInput((Object)2L, (Object)"Kafka", this.testBaseTime);
        MatcherAssert.assertThat((Object)outputTopic.readRecord(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new TestRecord((Object)2L, (Object)"Kafka", this.testBaseTime))));
        List<String> inputList = Arrays.asList("Advancing", "time");
        Duration advance = Duration.ofSeconds(15L);
        Instant recordInstant = this.testBaseTime.plus(Duration.ofDays(1L));
        inputTopic.pipeValueList(inputList, recordInstant, advance);
        MatcherAssert.assertThat((Object)outputTopic.readRecord(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new TestRecord(null, (Object)"Advancing", recordInstant))));
        MatcherAssert.assertThat((Object)outputTopic.readRecord(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new TestRecord(null, (Object)"time", null, recordInstant.plus(advance)))));
    }

    @Test
    public void testWithHeaders() {
        long baseTime = 3L;
        RecordHeaders headers = new RecordHeaders(new Header[]{new RecordHeader("foo", "value".getBytes()), new RecordHeader("bar", null), new RecordHeader("\"A\\u00ea\\u00f1\\u00fcC\"", "value".getBytes())});
        TestInputTopic inputTopic = this.testDriver.createInputTopic(INPUT_TOPIC, this.longSerde.serializer(), this.stringSerde.serializer());
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic("output1", this.longSerde.deserializer(), this.stringSerde.deserializer());
        inputTopic.pipeInput(new TestRecord((Object)1L, (Object)"Hello", (Headers)headers));
        MatcherAssert.assertThat((Object)outputTopic.readRecord(), (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)CoreMatchers.equalTo((Object)1L)), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)"Hello")), (Matcher)Matchers.hasProperty((String)"headers", (Matcher)CoreMatchers.equalTo((Object)headers))));
        inputTopic.pipeInput(new TestRecord((Object)2L, (Object)"Kafka", (Headers)headers, Long.valueOf(++baseTime)));
        MatcherAssert.assertThat((Object)outputTopic.readRecord(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new TestRecord((Object)2L, (Object)"Kafka", (Headers)headers, Long.valueOf(baseTime)))));
    }

    @Test
    public void testStartTimestamp() {
        Duration advance = Duration.ofSeconds(2L);
        TestInputTopic inputTopic = this.testDriver.createInputTopic(INPUT_TOPIC, this.longSerde.serializer(), this.stringSerde.serializer(), this.testBaseTime, Duration.ZERO);
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic("output1", this.longSerde.deserializer(), this.stringSerde.deserializer());
        inputTopic.pipeInput((Object)1L, (Object)"Hello");
        MatcherAssert.assertThat((Object)outputTopic.readRecord(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new TestRecord((Object)1L, (Object)"Hello", this.testBaseTime))));
        inputTopic.pipeInput((Object)2L, (Object)"World");
        MatcherAssert.assertThat((Object)outputTopic.readRecord(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new TestRecord((Object)2L, (Object)"World", null, Long.valueOf(this.testBaseTime.toEpochMilli())))));
        inputTopic.advanceTime(advance);
        inputTopic.pipeInput((Object)3L, (Object)"Kafka");
        MatcherAssert.assertThat((Object)outputTopic.readRecord(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new TestRecord((Object)3L, (Object)"Kafka", this.testBaseTime.plus(advance)))));
    }

    @Test
    public void testTimestampAutoAdvance() {
        Duration advance = Duration.ofSeconds(2L);
        TestInputTopic inputTopic = this.testDriver.createInputTopic(INPUT_TOPIC, this.longSerde.serializer(), this.stringSerde.serializer(), this.testBaseTime, advance);
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic("output1", this.longSerde.deserializer(), this.stringSerde.deserializer());
        inputTopic.pipeInput((Object)"Hello");
        MatcherAssert.assertThat((Object)outputTopic.readRecord(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new TestRecord(null, (Object)"Hello", this.testBaseTime))));
        inputTopic.pipeInput((Object)2L, (Object)"Kafka");
        MatcherAssert.assertThat((Object)outputTopic.readRecord(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new TestRecord((Object)2L, (Object)"Kafka", this.testBaseTime.plus(advance)))));
    }

    @Test
    public void testMultipleTopics() {
        TestInputTopic inputTopic1 = this.testDriver.createInputTopic(INPUT_TOPIC, this.longSerde.serializer(), this.stringSerde.serializer());
        TestInputTopic inputTopic2 = this.testDriver.createInputTopic("output1", this.longSerde.serializer(), this.stringSerde.serializer());
        TestOutputTopic outputTopic1 = this.testDriver.createOutputTopic("output1", this.longSerde.deserializer(), this.stringSerde.deserializer());
        TestOutputTopic outputTopic2 = this.testDriver.createOutputTopic(OUTPUT_TOPIC_MAP, this.stringSerde.deserializer(), this.longSerde.deserializer());
        inputTopic1.pipeInput((Object)1L, (Object)"Hello");
        MatcherAssert.assertThat((Object)outputTopic1.readKeyValue(), (Matcher)CoreMatchers.equalTo((Object)new KeyValue((Object)1L, (Object)"Hello")));
        MatcherAssert.assertThat((Object)outputTopic2.readKeyValue(), (Matcher)CoreMatchers.equalTo((Object)new KeyValue((Object)"Hello", (Object)1L)));
        MatcherAssert.assertThat((Object)outputTopic1.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)outputTopic2.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        inputTopic2.pipeInput((Object)1L, (Object)"Hello");
        MatcherAssert.assertThat((Object)outputTopic2.readKeyValue(), (Matcher)CoreMatchers.equalTo((Object)new KeyValue((Object)"Hello", (Object)1L)));
        MatcherAssert.assertThat((Object)outputTopic1.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)outputTopic2.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testNonExistingOutputTopic() {
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic("no-exist", this.longSerde.deserializer(), this.stringSerde.deserializer());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((TestOutputTopic)outputTopic).readRecord(), (String)"Uninitialized topic");
    }

    @Test
    public void testNonUsedOutputTopic() {
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic("output1", this.longSerde.deserializer(), this.stringSerde.deserializer());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((TestOutputTopic)outputTopic).readRecord(), (String)"Uninitialized topic");
    }

    @Test
    public void testEmptyTopic() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic(INPUT_TOPIC, this.stringSerde.serializer(), this.stringSerde.serializer());
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic("output1", this.stringSerde.deserializer(), this.stringSerde.deserializer());
        inputTopic.pipeInput((Object)"Hello");
        MatcherAssert.assertThat((Object)((String)outputTopic.readValue()), (Matcher)CoreMatchers.equalTo((Object)"Hello"));
        Assertions.assertThrows(NoSuchElementException.class, () -> ((TestOutputTopic)outputTopic).readRecord(), (String)"Empty topic");
    }

    @Test
    public void testNonExistingInputTopic() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic("no-exist", this.longSerde.serializer(), this.stringSerde.serializer());
        Assertions.assertThrows(IllegalArgumentException.class, () -> inputTopic.pipeInput((Object)1L, (Object)"Hello"), (String)"Unknown topic");
    }

    @Test
    public void shouldNotAllowToCreateTopicWithNullTopicName() {
        Assertions.assertThrows(NullPointerException.class, () -> this.testDriver.createInputTopic(null, this.stringSerde.serializer(), this.stringSerde.serializer()));
    }

    @Test
    public void shouldNotAllowToCreateWithNullDriver() {
        Assertions.assertThrows(NullPointerException.class, () -> new TestInputTopic(null, INPUT_TOPIC, this.stringSerde.serializer(), this.stringSerde.serializer(), Instant.now(), Duration.ZERO));
    }

    @Test
    public void testWrongSerde() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic("output1", this.stringSerde.serializer(), this.stringSerde.serializer());
        Assertions.assertThrows(StreamsException.class, () -> inputTopic.pipeInput((Object)"1L", (Object)"Hello"));
    }

    @Test
    public void testDuration() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testDriver.createInputTopic("output1", this.stringSerde.serializer(), this.stringSerde.serializer(), this.testBaseTime, Duration.ofDays(-1L)));
    }

    @Test
    public void testNegativeAdvance() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic("output1", this.stringSerde.serializer(), this.stringSerde.serializer());
        Assertions.assertThrows(IllegalArgumentException.class, () -> inputTopic.advanceTime(Duration.ofDays(-1L)));
    }

    @Test
    public void testInputToString() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic("topicName", this.stringSerde.serializer(), this.stringSerde.serializer());
        MatcherAssert.assertThat((Object)inputTopic.toString(), (Matcher)Matchers.allOf((Matcher)CoreMatchers.containsString((String)"TestInputTopic"), (Matcher)CoreMatchers.containsString((String)"topic='topicName'"), (Matcher)CoreMatchers.containsString((String)"StringSerializer")));
    }

    @Test
    public void shouldNotAllowToCreateOutputTopicWithNullTopicName() {
        Assertions.assertThrows(NullPointerException.class, () -> this.testDriver.createOutputTopic(null, this.stringSerde.deserializer(), this.stringSerde.deserializer()));
    }

    @Test
    public void shouldNotAllowToCreateOutputWithNullDriver() {
        Assertions.assertThrows(NullPointerException.class, () -> new TestOutputTopic(null, "output1", this.stringSerde.deserializer(), this.stringSerde.deserializer()));
    }

    @Test
    public void testOutputWrongSerde() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic("output1", this.longSerde.serializer(), this.stringSerde.serializer());
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic(OUTPUT_TOPIC_MAP, this.longSerde.deserializer(), this.stringSerde.deserializer());
        inputTopic.pipeInput((Object)1L, (Object)"Hello");
        Assertions.assertThrows(SerializationException.class, () -> ((TestOutputTopic)outputTopic).readKeyValue());
    }

    @Test
    public void testOutputToString() {
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic("output1", this.stringSerde.deserializer(), this.stringSerde.deserializer());
        MatcherAssert.assertThat((Object)outputTopic.toString(), (Matcher)Matchers.allOf((Matcher)CoreMatchers.containsString((String)"TestOutputTopic"), (Matcher)CoreMatchers.containsString((String)"topic='output1'"), (Matcher)CoreMatchers.containsString((String)"size=0"), (Matcher)CoreMatchers.containsString((String)"StringDeserializer")));
    }

    @Test
    public void testRecordsToList() {
        TestInputTopic inputTopic = this.testDriver.createInputTopic("output1", this.longSerde.serializer(), this.stringSerde.serializer());
        TestOutputTopic outputTopic = this.testDriver.createOutputTopic(OUTPUT_TOPIC_MAP, this.stringSerde.deserializer(), this.longSerde.deserializer());
        List<String> inputList = Arrays.asList("This", "is", "an", "example");
        LinkedList<KeyValue> input = new LinkedList<KeyValue>();
        LinkedList<TestRecord> expected = new LinkedList<TestRecord>();
        long i = 0L;
        Duration advance = Duration.ofSeconds(15L);
        Instant recordInstant = Instant.parse("2019-06-01T10:00:00Z");
        for (String s : inputList) {
            input.add(new KeyValue((Object)i, (Object)s));
            expected.add(new TestRecord((Object)s, (Object)i, recordInstant));
            ++i;
            recordInstant = recordInstant.plus(advance);
        }
        inputTopic.pipeKeyValueList(input, Instant.parse("2019-06-01T10:00:00Z"), advance);
        List output = outputTopic.readRecordsToList();
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(expected)));
    }
}

