/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.integration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.tiered.storage.TieredStorageTestBuilder;
import org.apache.kafka.tiered.storage.TieredStorageTestHarness;
import org.apache.kafka.tiered.storage.specs.KeyValueSpec;

public final class PartitionsExpandTest
extends TieredStorageTestHarness {
    public int brokerCount() {
        return 2;
    }

    @Override
    protected void writeTestSpecifications(TieredStorageTestBuilder builder) {
        Integer broker0 = 0;
        Integer broker1 = 1;
        String topicA = "topicA";
        Integer p0 = 0;
        Integer p1 = 1;
        Integer p2 = 2;
        Integer partitionCount = 1;
        Integer replicationFactor = 2;
        Integer maxBatchCountPerSegment = 1;
        boolean enableRemoteLogStorage = true;
        List<Integer> p0Assignment = Arrays.asList(broker0, broker1);
        List<Integer> p1Assignment = Arrays.asList(broker0, broker1);
        List<Integer> p2Assignment = Arrays.asList(broker1, broker0);
        builder.createTopic("topicA", partitionCount, replicationFactor, maxBatchCountPerSegment, Collections.singletonMap(p0, p0Assignment), true).expectSegmentToBeOffloaded(broker0, "topicA", p0, 0, new KeyValueSpec("k0", "v0")).expectSegmentToBeOffloaded(broker0, "topicA", p0, 1, new KeyValueSpec("k1", "v1")).expectEarliestLocalOffsetInLogDirectory("topicA", p0, 2L).produce("topicA", p0, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1"), new KeyValueSpec("k2", "v2")).createPartitions("topicA", 3, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)p1, p1Assignment), Utils.mkEntry((Object)p2, p2Assignment)})).expectFetchFromTieredStorage(broker0, "topicA", p0, 2).consume("topicA", p0, 0L, 3, 2).expectLeader("topicA", p1, broker0, false).expectLeader("topicA", p2, broker1, false).expectSegmentToBeOffloaded(broker0, "topicA", p1, 0, new KeyValueSpec("k0", "v0")).expectSegmentToBeOffloaded(broker0, "topicA", p1, 1, new KeyValueSpec("k1", "v1")).expectEarliestLocalOffsetInLogDirectory("topicA", p1, 2L).produce("topicA", p1, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1"), new KeyValueSpec("k2", "v2")).expectSegmentToBeOffloaded(broker1, "topicA", p2, 0, new KeyValueSpec("k0", "v0")).expectSegmentToBeOffloaded(broker1, "topicA", p2, 1, new KeyValueSpec("k1", "v1")).expectEarliestLocalOffsetInLogDirectory("topicA", p2, 2L).produce("topicA", p2, new KeyValueSpec("k0", "v0"), new KeyValueSpec("k1", "v1"), new KeyValueSpec("k2", "v2")).expectSegmentToBeOffloaded(broker0, "topicA", p0, 3, new KeyValueSpec("k3", "v3")).expectSegmentToBeOffloaded(broker0, "topicA", p0, 4, new KeyValueSpec("k4", "v4")).expectEarliestLocalOffsetInLogDirectory("topicA", p0, 5L).produce("topicA", p0, new KeyValueSpec("k3", "v3"), new KeyValueSpec("k4", "v4"), new KeyValueSpec("k5", "v5")).expectFetchFromTieredStorage(broker0, "topicA", p0, 5).consume("topicA", p0, 0L, 6, 5).expectFetchFromTieredStorage(broker0, "topicA", p1, 2).consume("topicA", p1, 0L, 3, 2).expectFetchFromTieredStorage(broker1, "topicA", p2, 1).consume("topicA", p2, 1L, 2, 1);
    }
}

