/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.server.log.remote.storage.ClassLoaderAwareRemoteStorageManager;
import org.apache.kafka.server.log.remote.storage.RemoteStorageManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ClassLoaderAwareRemoteStorageManagerTest {
    @Test
    public void testWithClassLoader() {
        DummyClassLoader dummyClassLoader = new DummyClassLoader();
        RemoteStorageManager delegate = (RemoteStorageManager)Mockito.mock(RemoteStorageManager.class);
        ClassLoaderAwareRemoteStorageManager rsm = new ClassLoaderAwareRemoteStorageManager(delegate, (ClassLoader)dummyClassLoader);
        ((RemoteStorageManager)Mockito.doAnswer(invocation -> {
            Assertions.assertEquals((Object)dummyClassLoader, (Object)Thread.currentThread().getContextClassLoader());
            return null;
        }).when((Object)delegate)).configure((Map)ArgumentMatchers.any());
        Assertions.assertNotEquals((Object)dummyClassLoader, (Object)Thread.currentThread().getContextClassLoader());
        rsm.configure(Collections.emptyMap());
        Assertions.assertNotEquals((Object)dummyClassLoader, (Object)Thread.currentThread().getContextClassLoader());
    }

    private static class DummyClassLoader
    extends ClassLoader {
        private DummyClassLoader() {
        }
    }
}

