/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManagerHarness;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.mutable.Buffer;

public class TopicBasedRemoteLogMetadataManagerRestartTest {
    private static final int SEG_SIZE = 0x100000;
    private final Time time = new MockTime(1L);
    private final String logDir = TestUtils.tempDirectory((String)"_rlmm_segs_").getAbsolutePath();
    private TopicBasedRemoteLogMetadataManagerHarness remoteLogMetadataManagerHarness;

    @BeforeEach
    public void setup() {
        this.remoteLogMetadataManagerHarness = new TopicBasedRemoteLogMetadataManagerHarness(){

            @Override
            protected java.util.Map<String, Object> overrideRemoteLogMetadataManagerProps() {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("log.dir", TopicBasedRemoteLogMetadataManagerRestartTest.this.logDir);
                return props;
            }
        };
        this.remoteLogMetadataManagerHarness.initialize(Collections.emptySet(), true);
    }

    private void startTopicBasedRemoteLogMetadataManagerHarness(boolean startConsumerThread) {
        this.remoteLogMetadataManagerHarness.initializeRemoteLogMetadataManager(Collections.emptySet(), startConsumerThread, null);
    }

    @AfterEach
    public void teardown() throws IOException {
        if (this.remoteLogMetadataManagerHarness != null) {
            this.remoteLogMetadataManagerHarness.close();
        }
    }

    private void stopTopicBasedRemoteLogMetadataManagerHarness() throws IOException {
        this.remoteLogMetadataManagerHarness.closeRemoteLogMetadataManager();
    }

    private TopicBasedRemoteLogMetadataManager topicBasedRlmm() {
        return this.remoteLogMetadataManagerHarness.remoteLogMetadataManager();
    }

    @Test
    public void testRLMMAPIsAfterRestart() throws Exception {
        String leaderTopic = "new-leader";
        HashMap<Integer, Buffer> assignedLeaderTopicReplicas = new HashMap<Integer, Buffer>();
        ArrayList<Integer> leaderTopicReplicas = new ArrayList<Integer>();
        leaderTopicReplicas.add(0);
        leaderTopicReplicas.add(1);
        leaderTopicReplicas.add(2);
        assignedLeaderTopicReplicas.put(0, JavaConverters.asScalaBuffer(leaderTopicReplicas));
        this.remoteLogMetadataManagerHarness.createTopicWithAssignment(leaderTopic, (Map)JavaConverters.mapAsScalaMap(assignedLeaderTopicReplicas), this.remoteLogMetadataManagerHarness.listenerName());
        String followerTopic = "new-follower";
        HashMap<Integer, Buffer> assignedFollowerTopicReplicas = new HashMap<Integer, Buffer>();
        ArrayList<Integer> followerTopicReplicas = new ArrayList<Integer>();
        followerTopicReplicas.add(1);
        followerTopicReplicas.add(2);
        followerTopicReplicas.add(0);
        assignedFollowerTopicReplicas.put(0, JavaConverters.asScalaBuffer(followerTopicReplicas));
        this.remoteLogMetadataManagerHarness.createTopicWithAssignment(followerTopic, (Map)JavaConverters.mapAsScalaMap(assignedFollowerTopicReplicas), this.remoteLogMetadataManagerHarness.listenerName());
        TopicIdPartition leaderTopicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition(leaderTopic, 0));
        TopicIdPartition followerTopicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition(followerTopic, 0));
        this.topicBasedRlmm().onPartitionLeadershipChanges(Collections.singleton(leaderTopicIdPartition), Collections.singleton(followerTopicIdPartition));
        RemoteLogSegmentMetadata leaderSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(leaderTopicIdPartition, Uuid.randomUuid()), 0L, 100L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(0, 0L));
        this.topicBasedRlmm().addRemoteLogSegmentMetadata(leaderSegmentMetadata).get();
        RemoteLogSegmentMetadata followerSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(followerTopicIdPartition, Uuid.randomUuid()), 0L, 100L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(0, 0L));
        this.topicBasedRlmm().addRemoteLogSegmentMetadata(followerSegmentMetadata).get();
        this.stopTopicBasedRemoteLogMetadataManagerHarness();
        this.startTopicBasedRemoteLogMetadataManagerHarness(true);
        this.topicBasedRlmm().onPartitionLeadershipChanges(Collections.singleton(leaderTopicIdPartition), Collections.singleton(followerTopicIdPartition));
        TestUtils.waitForCondition(() -> TestUtils.sameElementsWithoutOrder(Collections.singleton(leaderSegmentMetadata).iterator(), (Iterator)this.topicBasedRlmm().listRemoteLogSegments(leaderTopicIdPartition)), (String)"Remote log segment metadata not available");
        TestUtils.waitForCondition(() -> TestUtils.sameElementsWithoutOrder(Collections.singleton(followerSegmentMetadata).iterator(), (Iterator)this.topicBasedRlmm().listRemoteLogSegments(followerTopicIdPartition)), (String)"Remote log segment metadata not available");
        RemoteLogSegmentMetadata leaderSegmentMetadata2 = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(leaderTopicIdPartition, Uuid.randomUuid()), 101L, 200L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(0, 101L));
        this.topicBasedRlmm().addRemoteLogSegmentMetadata(leaderSegmentMetadata2).get();
        Assertions.assertTrue((boolean)TestUtils.sameElementsWithoutOrder(Arrays.asList(leaderSegmentMetadata, leaderSegmentMetadata2).iterator(), (Iterator)this.topicBasedRlmm().listRemoteLogSegments(leaderTopicIdPartition)));
    }
}

