/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.server.log.remote.metadata.storage.ClassLoaderAwareRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteStorageException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ClassLoaderAwareRemoteLogMetadataManagerTest {
    ClassLoaderAwareRemoteLogMetadataManagerTest() {
    }

    @Test
    public void testWithClassLoader() throws RemoteStorageException {
        DummyClassLoader dummyClassLoader = new DummyClassLoader();
        RemoteLogMetadataManager delegate = (RemoteLogMetadataManager)Mockito.mock(RemoteLogMetadataManager.class);
        ClassLoaderAwareRemoteLogMetadataManager rlmm = new ClassLoaderAwareRemoteLogMetadataManager(delegate, (ClassLoader)dummyClassLoader);
        Mockito.when((Object)delegate.addRemoteLogSegmentMetadata((RemoteLogSegmentMetadata)Mockito.any(RemoteLogSegmentMetadata.class))).thenAnswer(metadata -> {
            Assertions.assertEquals((Object)dummyClassLoader, (Object)Thread.currentThread().getContextClassLoader());
            return CompletableFuture.completedFuture(null);
        });
        Assertions.assertNotEquals((Object)dummyClassLoader, (Object)Thread.currentThread().getContextClassLoader());
        rlmm.addRemoteLogSegmentMetadata((RemoteLogSegmentMetadata)Mockito.mock(RemoteLogSegmentMetadata.class));
        Assertions.assertNotEquals((Object)dummyClassLoader, (Object)Thread.currentThread().getContextClassLoader());
    }

    private static class DummyClassLoader
    extends ClassLoader {
        private DummyClassLoader() {
        }
    }
}

