/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.utils;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageTraverser;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentFileset;

public final class LocalTieredStorageOutput<K, V>
implements LocalTieredStorageTraverser {
    private final Deserializer<K> keyDe;
    private final Deserializer<V> valueDe;
    private String output = this.row("File", "Offsets", "Records", "Broker ID");
    private String currentTopic = "";

    public LocalTieredStorageOutput(Deserializer<K> keyDe, Deserializer<V> valueDe) {
        this.keyDe = keyDe;
        this.valueDe = valueDe;
        this.output = this.output + this.repeatString("-", 88) + System.lineSeparator();
    }

    private String row(String file, Object offset, String record, String ident) {
        return String.format("%-51s |%8s |%13s %n", ident + file, offset.toString(), record);
    }

    private String row(String file, Object offset, String record) {
        return this.row(file, offset, record, "    ");
    }

    private String row(String file, Object offset) {
        return this.row(file, offset, "");
    }

    private String row(String file) {
        return this.row(file, "", "");
    }

    private String row() {
        return this.row("", "", "");
    }

    private String repeatString(String str, int times) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            builder.append(str);
        }
        return builder.toString();
    }

    @Override
    public void visitTopicIdPartition(TopicIdPartition topicIdPartition) {
        this.currentTopic = topicIdPartition.topicPartition().topic();
        this.output = this.output + this.row(topicIdPartition.topicPartition().toString(), "", "", "");
    }

    @Override
    public void visitSegment(RemoteLogSegmentFileset fileset) {
        try {
            List<Record> records = fileset.getRecords();
            String segFilename = fileset.getFile(RemoteLogSegmentFileset.RemoteLogSegmentFileType.SEGMENT).getName();
            if (records.isEmpty()) {
                this.output = this.output + this.row(segFilename, -1, "");
            } else {
                List offsetKeyValues = records.stream().map(record -> new Tuple2<Long, String>(record.offset(), "(" + this.des(this.keyDe, record.key()) + ", " + this.des(this.valueDe, record.value()) + ")")).collect(Collectors.toList());
                this.output = this.output + this.row(segFilename, ((Tuple2)offsetKeyValues.get(0)).t1, (String)((Tuple2)offsetKeyValues.get(0)).t2);
                if (offsetKeyValues.size() > 1) {
                    offsetKeyValues.subList(1, records.size()).forEach(offsetKeyValue -> {
                        this.output = this.output + this.row("", ((Tuple2)offsetKeyValue).t1, (String)((Tuple2)offsetKeyValue).t2);
                    });
                }
            }
            this.output = this.output + this.row();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getOutput() {
        return this.output;
    }

    private String des(Deserializer<?> de, ByteBuffer bytes) {
        return de.deserialize(this.currentTopic, Utils.toNullableArray((ByteBuffer)bytes)).toString();
    }

    private static class Tuple2<T1, T2> {
        private final T1 t1;
        private final T2 t2;

        Tuple2(T1 t1, T2 t2) {
            this.t1 = t1;
            this.t2 = t2;
        }
    }
}

