/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;

public final class UpdateBrokerConfigAction
implements TieredStorageTestAction {
    private final int brokerId;
    private final Map<String, String> configsToBeAdded;
    private final List<String> configsToBeDeleted;

    public UpdateBrokerConfigAction(int brokerId, Map<String, String> configsToBeAdded, List<String> configsToBeDeleted) {
        this.brokerId = brokerId;
        this.configsToBeAdded = configsToBeAdded;
        this.configsToBeDeleted = configsToBeDeleted;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws ExecutionException, InterruptedException, TimeoutException {
        context.updateBrokerConfig(this.brokerId, this.configsToBeAdded, this.configsToBeDeleted);
    }

    @Override
    public void describe(PrintStream output) {
        output.printf("Update broker config: %d, configs-to-be-added: %s, configs-to-be-deleted: %s%n", this.brokerId, this.configsToBeAdded, this.configsToBeDeleted);
    }
}

