/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import org.apache.kafka.tiered.storage.specs.TopicSpec;
import org.apache.kafka.tiered.storage.utils.TieredStorageTestUtils;

public final class CreateTopicAction
implements TieredStorageTestAction {
    private final TopicSpec spec;

    public CreateTopicAction(TopicSpec spec) {
        this.spec = spec;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws ExecutionException, InterruptedException {
        boolean enableRemoteStorage = true;
        Map<String, String> topicConfigs = TieredStorageTestUtils.createTopicConfigForRemoteStorage(enableRemoteStorage, this.spec.getMaxBatchCountPerSegment());
        topicConfigs.putAll(this.spec.getProperties());
        this.spec.getProperties().clear();
        this.spec.getProperties().putAll(topicConfigs);
        context.createTopic(this.spec);
    }

    @Override
    public void describe(PrintStream output) {
        output.println("create topic: " + this.spec);
    }
}

