/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorage;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorageTraverser;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentFileset;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;

public final class LocalTieredStorageSnapshot {
    private final Snapshot snapshot;

    public static LocalTieredStorageSnapshot takeSnapshot(LocalTieredStorage storage) {
        Snapshot snapshot = new Snapshot();
        storage.traverse(snapshot);
        return new LocalTieredStorageSnapshot(snapshot);
    }

    public List<TopicPartition> getTopicPartitions() {
        List topicPartitions = this.snapshot.topicIdPartitions.stream().map(TopicIdPartition::topicPartition).collect(Collectors.toList());
        return Collections.unmodifiableList(topicPartitions);
    }

    public List<RemoteLogSegmentFileset> getFilesets(TopicPartition topicPartition) {
        return this.snapshot.records.values().stream().filter(fileset -> fileset.getRemoteLogSegmentId().topicIdPartition().topicPartition().equals((Object)topicPartition)).collect(Collectors.toList());
    }

    public int size() {
        return this.snapshot.records.size();
    }

    public File getFile(RemoteLogSegmentId id, RemoteLogSegmentFileset.RemoteLogSegmentFileType type) {
        RemoteLogSegmentFileset fileset = (RemoteLogSegmentFileset)this.snapshot.records.get(id);
        if (fileset == null) {
            throw new IllegalArgumentException(String.format("No file found for id: %s", id));
        }
        return fileset.getFile(type);
    }

    public String toString() {
        return this.snapshot.records.values().stream().map(Object::toString).reduce("", (s1, s2) -> s1 + s2);
    }

    private LocalTieredStorageSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
        Objects.requireNonNull(this.snapshot);
    }

    private static final class Snapshot
    implements LocalTieredStorageTraverser {
        private final Map<RemoteLogSegmentId, RemoteLogSegmentFileset> records = new HashMap<RemoteLogSegmentId, RemoteLogSegmentFileset>();
        private final List<TopicIdPartition> topicIdPartitions = new ArrayList<TopicIdPartition>();

        private Snapshot() {
        }

        @Override
        public void visitTopicIdPartition(TopicIdPartition topicIdPartition) {
            if (this.topicIdPartitions.contains(topicIdPartition)) {
                throw new IllegalStateException(String.format("Topic-partition %s was already visited", topicIdPartition));
            }
            this.topicIdPartitions.add(topicIdPartition);
        }

        @Override
        public void visitSegment(RemoteLogSegmentFileset fileset) {
            if (this.records.containsKey(fileset.getRemoteLogSegmentId())) {
                throw new IllegalStateException(String.format("Segment with id %s was already visited", fileset.getRemoteLogSegmentId()));
            }
            this.records.put(fileset.getRemoteLogSegmentId(), fileset);
        }
    }
}

