/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import kafka.api.IntegrationTestHarness;
import kafka.utils.EmptyTestInfo;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataTopicPartitioner;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManager;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicBasedRemoteLogMetadataManagerHarness
extends IntegrationTestHarness {
    private static final Logger log = LoggerFactory.getLogger(TopicBasedRemoteLogMetadataManagerHarness.class);
    protected static final int METADATA_TOPIC_PARTITIONS_COUNT = 3;
    protected static final short METADATA_TOPIC_REPLICATION_FACTOR = 2;
    protected static final long METADATA_TOPIC_RETENTION_MS = 86400000L;
    private TopicBasedRemoteLogMetadataManager topicBasedRemoteLogMetadataManager;

    protected Map<String, Object> overrideRemoteLogMetadataManagerProps() {
        return Collections.emptyMap();
    }

    public void initialize(Set<TopicIdPartition> topicIdPartitions, boolean startConsumerThread) {
        super.setUp((TestInfo)new EmptyTestInfo());
        this.initializeRemoteLogMetadataManager(topicIdPartitions, startConsumerThread, null);
    }

    public void initializeRemoteLogMetadataManager(Set<TopicIdPartition> topicIdPartitions, boolean startConsumerThread, RemoteLogMetadataTopicPartitioner remoteLogMetadataTopicPartitioner) {
        String logDir = TestUtils.tempDirectory((String)"rlmm_segs_").getAbsolutePath();
        this.topicBasedRemoteLogMetadataManager = new TopicBasedRemoteLogMetadataManager(startConsumerThread){

            public void onPartitionLeadershipChanges(Set<TopicIdPartition> leaderPartitions, Set<TopicIdPartition> followerPartitions) {
                HashSet<TopicIdPartition> allReplicas = new HashSet<TopicIdPartition>(leaderPartitions);
                allReplicas.addAll(followerPartitions);
                for (TopicIdPartition topicIdPartition : allReplicas) {
                    File partitionDir = new File(new File(this.config().logDir()), topicIdPartition.topicPartition().topic() + "-" + topicIdPartition.topicPartition().partition());
                    partitionDir.mkdirs();
                    if (partitionDir.exists()) continue;
                    throw new KafkaException("Partition directory:[" + partitionDir + "] could not be created successfully.");
                }
                super.onPartitionLeadershipChanges(leaderPartitions, followerPartitions);
            }
        };
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("remote.log.metadata.common.client.bootstrap.servers", this.bootstrapServers(this.listenerName()));
        configs.put("broker.id", 0);
        configs.put("log.dir", logDir);
        configs.put("remote.log.metadata.topic.num.partitions", 3);
        configs.put("remote.log.metadata.topic.replication.factor", (short)2);
        configs.put("remote.log.metadata.topic.retention.ms", 86400000L);
        log.debug("TopicBasedRemoteLogMetadataManager configs before adding overridden properties: {}", configs);
        configs.putAll(this.overrideRemoteLogMetadataManagerProps());
        log.debug("TopicBasedRemoteLogMetadataManager configs after adding overridden properties: {}", configs);
        this.topicBasedRemoteLogMetadataManager.configure(configs);
        if (remoteLogMetadataTopicPartitioner != null) {
            this.topicBasedRemoteLogMetadataManager.setRlmTopicPartitioner(remoteLogMetadataTopicPartitioner);
        }
        try {
            this.waitUntilInitialized(60000L);
        }
        catch (TimeoutException e) {
            throw new KafkaException((Throwable)e);
        }
        this.topicBasedRemoteLogMetadataManager.onPartitionLeadershipChanges(topicIdPartitions, Collections.emptySet());
    }

    public void waitUntilInitialized(long waitTimeMs) throws TimeoutException {
        long startMs = System.currentTimeMillis();
        while (!this.topicBasedRemoteLogMetadataManager.isInitialized()) {
            long currentTimeMs = System.currentTimeMillis();
            if (currentTimeMs > startMs + waitTimeMs) {
                throw new TimeoutException("Time out reached before it is initialized successfully");
            }
            Utils.sleep((long)100L);
        }
    }

    public int brokerCount() {
        return 3;
    }

    protected TopicBasedRemoteLogMetadataManager remoteLogMetadataManager() {
        return this.topicBasedRemoteLogMetadataManager;
    }

    public void close() throws IOException {
        this.closeRemoteLogMetadataManager();
        this.tearDown();
    }

    public void closeRemoteLogMetadataManager() {
        Utils.closeQuietly((AutoCloseable)this.topicBasedRemoteLogMetadataManager, (String)"TopicBasedRemoteLogMetadataManager");
    }
}

