/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.specs;

import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ExpandPartitionCountSpec {
    private final String topicName;
    private final int partitionCount;
    private final Map<Integer, List<Integer>> assignment;

    public ExpandPartitionCountSpec(String topicName, int partitionCount) {
        this(topicName, partitionCount, null);
    }

    public ExpandPartitionCountSpec(String topicName, int partitionCount, Map<Integer, List<Integer>> assignment) {
        this.topicName = topicName;
        this.partitionCount = partitionCount;
        this.assignment = assignment;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public Map<Integer, List<Integer>> getAssignment() {
        return this.assignment;
    }

    public String toString() {
        return String.format("ExpandPartitionCountSpec[topicName=%s, partitionCount=%d, assignment=%s]", this.topicName, this.partitionCount, this.assignment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpandPartitionCountSpec that = (ExpandPartitionCountSpec)o;
        return this.partitionCount == that.partitionCount && Objects.equals(this.topicName, that.topicName) && Objects.equals(this.assignment, that.assignment);
    }

    public int hashCode() {
        return Objects.hash(this.topicName, this.partitionCount, this.assignment);
    }
}

