/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import org.apache.kafka.tiered.storage.utils.TieredStorageTestUtils;

public final class ReassignReplicaAction
implements TieredStorageTestAction {
    private final TopicPartition topicPartition;
    private final List<Integer> replicaIds;

    public ReassignReplicaAction(TopicPartition topicPartition, List<Integer> replicaIds) {
        this.topicPartition = topicPartition;
        this.replicaIds = replicaIds;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws InterruptedException, ExecutionException {
        String topic = this.topicPartition.topic();
        int partition = this.topicPartition.partition();
        Map<TopicPartition, Optional<NewPartitionReassignment>> proposed = Collections.singletonMap(this.topicPartition, Optional.of(new NewPartitionReassignment(this.replicaIds)));
        context.admin().alterPartitionReassignments(proposed);
        TestUtils.waitForCondition(() -> {
            try {
                TopicDescription description = TieredStorageTestUtils.describeTopic(context, topic);
                List actualReplicaIds = ((TopicPartitionInfo)description.partitions().get(partition)).replicas().stream().map(Node::id).collect(Collectors.toList());
                return this.replicaIds.equals(actualReplicaIds);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof UnknownTopicOrPartitionException) {
                    return false;
                }
                throw new RuntimeException(e);
            }
        }, (String)("Unable to reassign the replicas of " + this.topicPartition + ", replica-ids: " + this.replicaIds));
    }

    @Override
    public void describe(PrintStream output) {
        output.printf("reassign-replica topic-partition: %s replica-ids: %s%n", this.topicPartition, this.replicaIds);
    }
}

