/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.internals.FuturePurgatory;

public class ThresholdPurgatory<T extends Comparable<T>>
implements FuturePurgatory<T> {
    private final AtomicLong idGenerator = new AtomicLong(0L);
    private final ExpirationService expirationService;
    private final ConcurrentNavigableMap<ThresholdKey<T>, CompletableFuture<Long>> thresholdMap = new ConcurrentSkipListMap<ThresholdKey<T>, CompletableFuture<Long>>();

    public ThresholdPurgatory(ExpirationService expirationService) {
        this.expirationService = expirationService;
    }

    @Override
    public CompletableFuture<Long> await(T threshold, long maxWaitTimeMs) {
        ThresholdKey key = new ThresholdKey(this.idGenerator.incrementAndGet(), (Comparable)threshold, null);
        CompletableFuture<Long> future = this.expirationService.failAfter(maxWaitTimeMs);
        this.thresholdMap.put(key, future);
        future.whenComplete((timeMs, exception) -> this.thresholdMap.remove(key));
        return future;
    }

    @Override
    public void maybeComplete(T value, long currentTimeMs) {
        ThresholdKey maxKey = new ThresholdKey(Long.MAX_VALUE, (Comparable)value, null);
        SortedMap submap = this.thresholdMap.headMap((Object)maxKey);
        for (CompletableFuture completion : submap.values()) {
            completion.complete(currentTimeMs);
        }
    }

    @Override
    public void completeAll(long currentTimeMs) {
        for (CompletableFuture completion : this.thresholdMap.values()) {
            completion.complete(currentTimeMs);
        }
    }

    @Override
    public void completeAllExceptionally(Throwable exception) {
        for (CompletableFuture completion : this.thresholdMap.values()) {
            completion.completeExceptionally(exception);
        }
    }

    @Override
    public int numWaiting() {
        return this.thresholdMap.size();
    }

    private static class ThresholdKey<T extends Comparable<T>>
    implements Comparable<ThresholdKey<T>> {
        private final long id;
        private final T threshold;

        private ThresholdKey(long id, T threshold) {
            this.id = id;
            this.threshold = threshold;
        }

        @Override
        public int compareTo(ThresholdKey<T> o) {
            int res = this.threshold.compareTo(o.threshold);
            if (res != 0) {
                return res;
            }
            return Long.compare(this.id, o.id);
        }

        /* synthetic */ ThresholdKey(long x0, Comparable x1, 1 x2) {
            this(x0, x1);
        }
    }
}

