/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.snapshot;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public final class SnapshotsTest {
    @Test
    public void testValidSnapshotFilename() {
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)TestUtils.RANDOM.nextInt(Integer.MAX_VALUE), TestUtils.RANDOM.nextInt(Integer.MAX_VALUE));
        Path path = Snapshots.snapshotPath((Path)TestUtils.tempDirectory().toPath(), (OffsetAndEpoch)snapshotId);
        SnapshotPath snapshotPath = (SnapshotPath)Snapshots.parse((Path)path).get();
        Assertions.assertEquals((Object)path, (Object)snapshotPath.path);
        Assertions.assertEquals((Object)snapshotId, (Object)snapshotPath.snapshotId);
        Assertions.assertFalse((boolean)snapshotPath.partial);
        Assertions.assertFalse((boolean)snapshotPath.deleted);
    }

    @Test
    public void testValidPartialSnapshotFilename() throws IOException {
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)TestUtils.RANDOM.nextInt(Integer.MAX_VALUE), TestUtils.RANDOM.nextInt(Integer.MAX_VALUE));
        Path path = Snapshots.createTempFile((Path)TestUtils.tempDirectory().toPath(), (OffsetAndEpoch)snapshotId);
        Files.delete(path);
        SnapshotPath snapshotPath = (SnapshotPath)Snapshots.parse((Path)path).get();
        Assertions.assertEquals((Object)path, (Object)snapshotPath.path);
        Assertions.assertEquals((Object)snapshotId, (Object)snapshotPath.snapshotId);
        Assertions.assertTrue((boolean)snapshotPath.partial);
    }

    @Test
    public void testValidDeletedSnapshotFilename() {
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)TestUtils.RANDOM.nextInt(Integer.MAX_VALUE), TestUtils.RANDOM.nextInt(Integer.MAX_VALUE));
        Path path = Snapshots.snapshotPath((Path)TestUtils.tempDirectory().toPath(), (OffsetAndEpoch)snapshotId);
        Path deletedPath = Snapshots.deleteRenamePath((Path)path, (OffsetAndEpoch)snapshotId);
        SnapshotPath snapshotPath = (SnapshotPath)Snapshots.parse((Path)deletedPath).get();
        Assertions.assertEquals((Object)snapshotId, (Object)snapshotPath.snapshotId);
        Assertions.assertTrue((boolean)snapshotPath.deleted);
    }

    @Test
    public void testInvalidSnapshotFilenames() {
        Path root = FileSystems.getDefault().getPath("/", new String[0]);
        Assertions.assertEquals(Optional.empty(), (Object)Snapshots.parse((Path)root.resolve("00000000000000000000.log")));
        Assertions.assertEquals(Optional.empty(), (Object)Snapshots.parse((Path)root.resolve("00000000000000000000.snapshot")));
        Assertions.assertEquals(Optional.empty(), (Object)Snapshots.parse((Path)root.resolve("00000000000000000000.index")));
        Assertions.assertEquals(Optional.empty(), (Object)Snapshots.parse((Path)root.resolve("00000000000000000000.timeindex")));
        Assertions.assertEquals(Optional.empty(), (Object)Snapshots.parse((Path)root.resolve("leader-epoch-checkpoint")));
        Assertions.assertEquals(Optional.empty(), (Object)Snapshots.parse((Path)root.resolve("partition.metadata")));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDeleteSnapshot(boolean renameBeforeDeleting) throws IOException {
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)TestUtils.RANDOM.nextInt(Integer.MAX_VALUE), TestUtils.RANDOM.nextInt(Integer.MAX_VALUE));
        Path logDirPath = TestUtils.tempDirectory().toPath();
        try (FileRawSnapshotWriter snapshot = FileRawSnapshotWriter.create((Path)logDirPath, (OffsetAndEpoch)snapshotId, Optional.empty());){
            snapshot.freeze();
            Path snapshotPath = Snapshots.snapshotPath((Path)logDirPath, (OffsetAndEpoch)snapshotId);
            Assertions.assertTrue((boolean)Files.exists(snapshotPath, new LinkOption[0]));
            if (renameBeforeDeleting) {
                Utils.atomicMoveWithFallback((Path)snapshotPath, (Path)Snapshots.deleteRenamePath((Path)snapshotPath, (OffsetAndEpoch)snapshotId), (boolean)false);
            }
            Assertions.assertTrue((boolean)Snapshots.deleteIfExists((Path)logDirPath, (OffsetAndEpoch)snapshot.snapshotId()));
            Assertions.assertFalse((boolean)Files.exists(snapshotPath, new LinkOption[0]));
            Assertions.assertFalse((boolean)Files.exists(Snapshots.deleteRenamePath((Path)snapshotPath, (OffsetAndEpoch)snapshotId), new LinkOption[0]));
        }
    }
}

