/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.io.IOException;
import java.util.Collections;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Random;
import java.util.Set;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.MockQuorumStateStore;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.QuorumState;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.internals.BatchAccumulator;
import org.apache.kafka.raft.internals.KafkaRaftMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class KafkaRaftMetricsTest {
    private final int localId = 0;
    private final int electionTimeoutMs = 5000;
    private final int fetchTimeoutMs = 10000;
    private final Time time = new MockTime();
    private final Metrics metrics = new Metrics(this.time);
    private final Random random = new Random(1L);
    private KafkaRaftMetrics raftMetrics;
    private BatchAccumulator<?> accumulator = (BatchAccumulator)Mockito.mock(BatchAccumulator.class);

    @AfterEach
    public void tearDown() {
        if (this.raftMetrics != null) {
            this.raftMetrics.close();
        }
        this.metrics.close();
    }

    private QuorumState buildQuorumState(Set<Integer> voters) {
        return new QuorumState(OptionalInt.of(0), voters, 5000, 10000, (QuorumStateStore)new MockQuorumStateStore(), this.time, new LogContext("kafka-raft-metrics-test"), this.random);
    }

    @Test
    public void shouldRecordVoterQuorumState() throws IOException {
        QuorumState state = this.buildQuorumState(Utils.mkSet((Object[])new Integer[]{0, 1, 2}));
        state.initialize(new OffsetAndEpoch(0L, 0));
        this.raftMetrics = new KafkaRaftMetrics(this.metrics, "raft", state);
        Assertions.assertEquals((Object)"unattached", (Object)this.getMetric(this.metrics, "current-state").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "current-leader").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "current-vote").metricValue());
        Assertions.assertEquals((Object)0.0, (Object)this.getMetric(this.metrics, "current-epoch").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "high-watermark").metricValue());
        state.transitionToCandidate();
        Assertions.assertEquals((Object)"candidate", (Object)this.getMetric(this.metrics, "current-state").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "current-leader").metricValue());
        Assertions.assertEquals((Object)0.0, (Object)this.getMetric(this.metrics, "current-vote").metricValue());
        Assertions.assertEquals((Object)1.0, (Object)this.getMetric(this.metrics, "current-epoch").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "high-watermark").metricValue());
        state.candidateStateOrThrow().recordGrantedVote(1);
        state.transitionToLeader(2L, this.accumulator);
        Assertions.assertEquals((Object)"leader", (Object)this.getMetric(this.metrics, "current-state").metricValue());
        Assertions.assertEquals((Object)0.0, (Object)this.getMetric(this.metrics, "current-leader").metricValue());
        Assertions.assertEquals((Object)0.0, (Object)this.getMetric(this.metrics, "current-vote").metricValue());
        Assertions.assertEquals((Object)1.0, (Object)this.getMetric(this.metrics, "current-epoch").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "high-watermark").metricValue());
        state.leaderStateOrThrow().updateLocalState(new LogOffsetMetadata(5L));
        state.leaderStateOrThrow().updateReplicaState(1, 0L, new LogOffsetMetadata(5L));
        Assertions.assertEquals((Object)5.0, (Object)this.getMetric(this.metrics, "high-watermark").metricValue());
        state.transitionToFollower(2, 1);
        Assertions.assertEquals((Object)"follower", (Object)this.getMetric(this.metrics, "current-state").metricValue());
        Assertions.assertEquals((Object)1.0, (Object)this.getMetric(this.metrics, "current-leader").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "current-vote").metricValue());
        Assertions.assertEquals((Object)2.0, (Object)this.getMetric(this.metrics, "current-epoch").metricValue());
        Assertions.assertEquals((Object)5.0, (Object)this.getMetric(this.metrics, "high-watermark").metricValue());
        state.followerStateOrThrow().updateHighWatermark(OptionalLong.of(10L));
        Assertions.assertEquals((Object)10.0, (Object)this.getMetric(this.metrics, "high-watermark").metricValue());
        state.transitionToVoted(3, 2);
        Assertions.assertEquals((Object)"voted", (Object)this.getMetric(this.metrics, "current-state").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "current-leader").metricValue());
        Assertions.assertEquals((Object)2.0, (Object)this.getMetric(this.metrics, "current-vote").metricValue());
        Assertions.assertEquals((Object)3.0, (Object)this.getMetric(this.metrics, "current-epoch").metricValue());
        Assertions.assertEquals((Object)10.0, (Object)this.getMetric(this.metrics, "high-watermark").metricValue());
        state.transitionToUnattached(4);
        Assertions.assertEquals((Object)"unattached", (Object)this.getMetric(this.metrics, "current-state").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "current-leader").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "current-vote").metricValue());
        Assertions.assertEquals((Object)4.0, (Object)this.getMetric(this.metrics, "current-epoch").metricValue());
        Assertions.assertEquals((Object)10.0, (Object)this.getMetric(this.metrics, "high-watermark").metricValue());
    }

    @Test
    public void shouldRecordNonVoterQuorumState() throws IOException {
        QuorumState state = this.buildQuorumState(Utils.mkSet((Object[])new Integer[]{1, 2, 3}));
        state.initialize(new OffsetAndEpoch(0L, 0));
        this.raftMetrics = new KafkaRaftMetrics(this.metrics, "raft", state);
        Assertions.assertEquals((Object)"unattached", (Object)this.getMetric(this.metrics, "current-state").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "current-leader").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "current-vote").metricValue());
        Assertions.assertEquals((Object)0.0, (Object)this.getMetric(this.metrics, "current-epoch").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "high-watermark").metricValue());
        state.transitionToFollower(2, 1);
        Assertions.assertEquals((Object)"observer", (Object)this.getMetric(this.metrics, "current-state").metricValue());
        Assertions.assertEquals((Object)1.0, (Object)this.getMetric(this.metrics, "current-leader").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "current-vote").metricValue());
        Assertions.assertEquals((Object)2.0, (Object)this.getMetric(this.metrics, "current-epoch").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "high-watermark").metricValue());
        state.followerStateOrThrow().updateHighWatermark(OptionalLong.of(10L));
        Assertions.assertEquals((Object)10.0, (Object)this.getMetric(this.metrics, "high-watermark").metricValue());
        state.transitionToUnattached(4);
        Assertions.assertEquals((Object)"unattached", (Object)this.getMetric(this.metrics, "current-state").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "current-leader").metricValue());
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric(this.metrics, "current-vote").metricValue());
        Assertions.assertEquals((Object)4.0, (Object)this.getMetric(this.metrics, "current-epoch").metricValue());
        Assertions.assertEquals((Object)10.0, (Object)this.getMetric(this.metrics, "high-watermark").metricValue());
    }

    @Test
    public void shouldRecordLogEnd() throws IOException {
        QuorumState state = this.buildQuorumState(Collections.singleton(0));
        state.initialize(new OffsetAndEpoch(0L, 0));
        this.raftMetrics = new KafkaRaftMetrics(this.metrics, "raft", state);
        Assertions.assertEquals((Object)0.0, (Object)this.getMetric(this.metrics, "log-end-offset").metricValue());
        Assertions.assertEquals((Object)0.0, (Object)this.getMetric(this.metrics, "log-end-epoch").metricValue());
        this.raftMetrics.updateLogEnd(new OffsetAndEpoch(5L, 1));
        Assertions.assertEquals((Object)5.0, (Object)this.getMetric(this.metrics, "log-end-offset").metricValue());
        Assertions.assertEquals((Object)1.0, (Object)this.getMetric(this.metrics, "log-end-epoch").metricValue());
    }

    @Test
    public void shouldRecordNumUnknownVoterConnections() throws IOException {
        QuorumState state = this.buildQuorumState(Collections.singleton(0));
        state.initialize(new OffsetAndEpoch(0L, 0));
        this.raftMetrics = new KafkaRaftMetrics(this.metrics, "raft", state);
        Assertions.assertEquals((Object)0.0, (Object)this.getMetric(this.metrics, "number-unknown-voter-connections").metricValue());
        this.raftMetrics.updateNumUnknownVoterConnections(2);
        Assertions.assertEquals((Object)2.0, (Object)this.getMetric(this.metrics, "number-unknown-voter-connections").metricValue());
    }

    @Test
    public void shouldRecordPollIdleRatio() {
        QuorumState state = this.buildQuorumState(Collections.singleton(0));
        state.initialize(new OffsetAndEpoch(0L, 0));
        this.raftMetrics = new KafkaRaftMetrics(this.metrics, "raft", state);
        this.raftMetrics.updatePollStart(this.time.milliseconds());
        this.raftMetrics.updatePollEnd(this.time.milliseconds());
        this.raftMetrics.updatePollStart(this.time.milliseconds());
        this.time.sleep(100L);
        this.raftMetrics.updatePollEnd(this.time.milliseconds());
        this.time.sleep(100L);
        this.raftMetrics.updatePollStart(this.time.milliseconds());
        this.time.sleep(200L);
        this.raftMetrics.updatePollEnd(this.time.milliseconds());
        Assertions.assertEquals((Object)0.75, (Object)this.getMetric(this.metrics, "poll-idle-ratio-avg").metricValue());
        this.time.sleep(100L);
        this.raftMetrics.updatePollStart(this.time.milliseconds());
        this.time.sleep(75L);
        this.raftMetrics.updatePollEnd(this.time.milliseconds());
        this.raftMetrics.updatePollStart(this.time.milliseconds());
        this.time.sleep(25L);
        this.raftMetrics.updatePollEnd(this.time.milliseconds());
        this.raftMetrics.updatePollStart(this.time.milliseconds());
        this.raftMetrics.updatePollEnd(this.time.milliseconds());
        Assertions.assertEquals((Object)0.5, (Object)this.getMetric(this.metrics, "poll-idle-ratio-avg").metricValue());
        this.time.sleep(40L);
        this.raftMetrics.updatePollStart(this.time.milliseconds());
        this.time.sleep(60L);
        this.raftMetrics.updatePollEnd(this.time.milliseconds());
        this.time.sleep(10L);
        this.raftMetrics.updatePollStart(this.time.milliseconds());
        this.time.sleep(5L);
        Assertions.assertEquals((Object)0.6, (Object)this.getMetric(this.metrics, "poll-idle-ratio-avg").metricValue());
        this.time.sleep(5L);
        this.raftMetrics.updatePollEnd(this.time.milliseconds());
        Assertions.assertEquals((Object)0.5, (Object)this.getMetric(this.metrics, "poll-idle-ratio-avg").metricValue());
    }

    @Test
    public void shouldRecordLatency() throws IOException {
        QuorumState state = this.buildQuorumState(Collections.singleton(0));
        state.initialize(new OffsetAndEpoch(0L, 0));
        this.raftMetrics = new KafkaRaftMetrics(this.metrics, "raft", state);
        this.raftMetrics.updateElectionStartMs(this.time.milliseconds());
        this.time.sleep(1000L);
        this.raftMetrics.maybeUpdateElectionLatency(this.time.milliseconds());
        Assertions.assertEquals((Object)1000.0, (Object)this.getMetric(this.metrics, "election-latency-avg").metricValue());
        Assertions.assertEquals((Object)1000.0, (Object)this.getMetric(this.metrics, "election-latency-max").metricValue());
        this.raftMetrics.updateElectionStartMs(this.time.milliseconds());
        this.time.sleep(800L);
        this.raftMetrics.maybeUpdateElectionLatency(this.time.milliseconds());
        Assertions.assertEquals((Object)900.0, (Object)this.getMetric(this.metrics, "election-latency-avg").metricValue());
        Assertions.assertEquals((Object)1000.0, (Object)this.getMetric(this.metrics, "election-latency-max").metricValue());
        this.raftMetrics.updateCommitLatency(50.0, this.time.milliseconds());
        Assertions.assertEquals((Object)50.0, (Object)this.getMetric(this.metrics, "commit-latency-avg").metricValue());
        Assertions.assertEquals((Object)50.0, (Object)this.getMetric(this.metrics, "commit-latency-max").metricValue());
        this.raftMetrics.updateCommitLatency(60.0, this.time.milliseconds());
        Assertions.assertEquals((Object)55.0, (Object)this.getMetric(this.metrics, "commit-latency-avg").metricValue());
        Assertions.assertEquals((Object)60.0, (Object)this.getMetric(this.metrics, "commit-latency-max").metricValue());
    }

    @Test
    public void shouldRecordRate() throws IOException {
        QuorumState state = this.buildQuorumState(Collections.singleton(0));
        state.initialize(new OffsetAndEpoch(0L, 0));
        this.raftMetrics = new KafkaRaftMetrics(this.metrics, "raft", state);
        this.raftMetrics.updateAppendRecords(12L);
        Assertions.assertEquals((Object)0.4, (Object)this.getMetric(this.metrics, "append-records-rate").metricValue());
        this.raftMetrics.updateAppendRecords(9L);
        Assertions.assertEquals((Object)0.7, (Object)this.getMetric(this.metrics, "append-records-rate").metricValue());
        this.raftMetrics.updateFetchedRecords(24L);
        Assertions.assertEquals((Object)0.8, (Object)this.getMetric(this.metrics, "fetch-records-rate").metricValue());
        this.raftMetrics.updateFetchedRecords(48L);
        Assertions.assertEquals((Object)2.4, (Object)this.getMetric(this.metrics, "fetch-records-rate").metricValue());
    }

    private KafkaMetric getMetric(Metrics metrics, String name) {
        return (KafkaMetric)metrics.metrics().get(metrics.metricName(name, "raft-metrics"));
    }
}

