/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.raft.internals.TimeRatio;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TimeRatioTest {
    TimeRatioTest() {
    }

    @Test
    public void testRatio() {
        MetricConfig config = new MetricConfig();
        MockTime time = new MockTime();
        TimeRatio ratio = new TimeRatio(1.0);
        ratio.record(config, 0.0, time.milliseconds());
        time.sleep(10L);
        ratio.record(config, 10.0, time.milliseconds());
        time.sleep(10L);
        ratio.record(config, 0.0, time.milliseconds());
        Assertions.assertEquals((double)0.5, (double)ratio.measure(config, time.milliseconds()));
        time.sleep(10L);
        ratio.record(config, 10.0, time.milliseconds());
        time.sleep(40L);
        ratio.record(config, 0.0, time.milliseconds());
        Assertions.assertEquals((double)0.2, (double)ratio.measure(config, time.milliseconds()));
    }

    @Test
    public void testRatioMisalignedWindow() {
        MetricConfig config = new MetricConfig();
        MockTime time = new MockTime();
        TimeRatio ratio = new TimeRatio(1.0);
        ratio.record(config, 0.0, time.milliseconds());
        time.sleep(10L);
        ratio.record(config, 10.0, time.milliseconds());
        time.sleep(10L);
        Assertions.assertEquals((double)1.0, (double)ratio.measure(config, time.milliseconds()));
        ratio.record(config, 5.0, time.milliseconds());
        Assertions.assertEquals((double)0.5, (double)ratio.measure(config, time.milliseconds()));
    }
}

