/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.raft.ControlRecord;
import org.apache.kafka.raft.internals.CloseListener;
import org.apache.kafka.raft.internals.RecordsBatchReader;
import org.apache.kafka.raft.internals.RecordsIteratorTest;
import org.apache.kafka.raft.internals.StringSerde;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;

class RecordsBatchReaderTest {
    private static final int MAX_BATCH_BYTES = 128;
    private final StringSerde serde = new StringSerde();

    RecordsBatchReaderTest() {
    }

    @ParameterizedTest
    @EnumSource(value=CompressionType.class)
    public void testReadFromMemoryRecords(CompressionType compressionType) {
        long seed = 57L;
        List<RecordsIteratorTest.TestBatch<String>> batches = RecordsIteratorTest.createBatches(seed);
        long baseOffset = batches.get((int)0).baseOffset;
        MemoryRecords memRecords = RecordsIteratorTest.buildRecords(compressionType, batches);
        this.testBatchReader(baseOffset, (Records)memRecords, batches);
    }

    @ParameterizedTest
    @EnumSource(value=CompressionType.class)
    public void testReadFromFileRecords(CompressionType compressionType) throws Exception {
        long seed = 57L;
        List<RecordsIteratorTest.TestBatch<String>> batches = RecordsIteratorTest.createBatches(seed);
        long baseOffset = batches.get((int)0).baseOffset;
        MemoryRecords memRecords = RecordsIteratorTest.buildRecords(compressionType, batches);
        FileRecords fileRecords = FileRecords.open((File)TestUtils.tempFile());
        fileRecords.append(memRecords);
        this.testBatchReader(baseOffset, (Records)fileRecords, batches);
    }

    @Test
    public void testLeaderChangeControlBatch() {
        MemoryRecords records = RecordsIteratorTest.buildControlRecords(ControlRecordType.LEADER_CHANGE);
        ControlRecord expectedRecord = new ControlRecord(ControlRecordType.LEADER_CHANGE, (ApiMessage)new LeaderChangeMessage());
        try (RecordsBatchReader reader = RecordsBatchReader.of((long)0L, (Records)records, (RecordSerde)this.serde, (BufferSupplier)BufferSupplier.NO_CACHING, (int)128, ignore -> {}, (boolean)true);){
            Assertions.assertTrue((boolean)reader.hasNext());
            Assertions.assertEquals(Collections.singletonList(expectedRecord), (Object)reader.next().controlRecords());
            Assertions.assertFalse((boolean)reader.hasNext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBatchReader(long baseOffset, Records records, List<RecordsIteratorTest.TestBatch<String>> expectedBatches) {
        BufferSupplier bufferSupplier = (BufferSupplier)Mockito.mock(BufferSupplier.class);
        Set allocatedBuffers = Collections.newSetFromMap(new IdentityHashMap());
        Mockito.when((Object)bufferSupplier.get(Mockito.anyInt())).thenAnswer(invocation -> {
            int size = (Integer)invocation.getArgument(0);
            ByteBuffer buffer = ByteBuffer.allocate(size);
            allocatedBuffers.add(buffer);
            return buffer;
        });
        ((BufferSupplier)Mockito.doAnswer(invocation -> {
            ByteBuffer released = (ByteBuffer)invocation.getArgument(0);
            allocatedBuffers.remove(released);
            return null;
        }).when((Object)bufferSupplier)).release((ByteBuffer)Mockito.any(ByteBuffer.class));
        CloseListener closeListener = (CloseListener)Mockito.mock(CloseListener.class);
        try (RecordsBatchReader reader = RecordsBatchReader.of((long)baseOffset, (Records)records, (RecordSerde)this.serde, (BufferSupplier)bufferSupplier, (int)128, (CloseListener)closeListener, (boolean)true);){
            for (RecordsIteratorTest.TestBatch<String> batch : expectedBatches) {
                Assertions.assertTrue((boolean)reader.hasNext());
                Assertions.assertEquals(batch, RecordsIteratorTest.TestBatch.from(reader.next()));
            }
            Assertions.assertFalse((boolean)reader.hasNext());
            Assertions.assertThrows(NoSuchElementException.class, () -> ((RecordsBatchReader)reader).next());
        }
        ((CloseListener)Mockito.verify((Object)closeListener)).onClose((AutoCloseable)reader);
        Assertions.assertEquals(Collections.emptySet(), allocatedBuffers);
    }
}

