/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.Arrays;
import java.util.OptionalLong;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.internals.CloseListener;
import org.apache.kafka.raft.internals.MemoryBatchReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class MemoryBatchReaderTest {
    MemoryBatchReaderTest() {
    }

    @Test
    public void testIteration() {
        Batch batch1 = Batch.data((long)0L, (int)1, (long)0L, (int)3, Arrays.asList("a", "b", "c"));
        Batch batch2 = Batch.data((long)3L, (int)2, (long)1L, (int)2, Arrays.asList("d", "e"));
        Batch batch3 = Batch.data((long)5L, (int)2, (long)3L, (int)4, Arrays.asList("f", "g", "h", "i"));
        CloseListener listener = (CloseListener)Mockito.mock(CloseListener.class);
        MemoryBatchReader reader = MemoryBatchReader.of(Arrays.asList(batch1, batch2, batch3), (CloseListener)listener);
        Assertions.assertEquals((long)0L, (long)reader.baseOffset());
        Assertions.assertEquals((Object)OptionalLong.of(8L), (Object)reader.lastOffset());
        Assertions.assertTrue((boolean)reader.hasNext());
        Assertions.assertEquals((Object)batch1, (Object)reader.next());
        Assertions.assertTrue((boolean)reader.hasNext());
        Assertions.assertEquals((Object)batch2, (Object)reader.next());
        Assertions.assertTrue((boolean)reader.hasNext());
        Assertions.assertEquals((Object)batch3, (Object)reader.next());
        Assertions.assertFalse((boolean)reader.hasNext());
        reader.close();
        ((CloseListener)Mockito.verify((Object)listener)).onClose((AutoCloseable)reader);
    }
}

