/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.kafka.raft.internals.BatchMemoryPool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BatchMemoryPoolTest {
    BatchMemoryPoolTest() {
    }

    @Test
    public void testAllocateAndRelease() {
        int batchSize = 1024;
        int maxRetainedBatches = 1;
        Set<ByteBuffer> released = Collections.newSetFromMap(new IdentityHashMap());
        BatchMemoryPool pool = new BatchMemoryPool(maxRetainedBatches, batchSize);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)pool.availableMemory());
        Assertions.assertFalse((boolean)pool.isOutOfMemory());
        ByteBuffer buffer1 = pool.tryAllocate(batchSize);
        Assertions.assertNotNull((Object)buffer1);
        Assertions.assertEquals((int)0, (int)buffer1.position());
        Assertions.assertEquals((int)batchSize, (int)buffer1.limit());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)pool.availableMemory());
        Assertions.assertFalse((boolean)pool.isOutOfMemory());
        ByteBuffer buffer2 = pool.tryAllocate(batchSize);
        Assertions.assertNotNull((Object)buffer2);
        Assertions.assertEquals((long)(2 * batchSize), (long)pool.size());
        this.release(this.update(buffer2), pool, released);
        this.release(this.update(buffer1), pool, released);
        Assertions.assertEquals((long)(maxRetainedBatches * batchSize), (long)pool.size());
        ByteBuffer reallocated = pool.tryAllocate(batchSize);
        Assertions.assertTrue((boolean)released.contains(reallocated));
        Assertions.assertEquals((int)0, (int)reallocated.position());
        Assertions.assertEquals((int)batchSize, (int)reallocated.limit());
    }

    @Test
    public void testMultipleAllocations() {
        int batchSize = 1024;
        int maxRetainedBatches = 3;
        Set<ByteBuffer> released = Collections.newSetFromMap(new IdentityHashMap());
        BatchMemoryPool pool = new BatchMemoryPool(maxRetainedBatches, batchSize);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)pool.availableMemory());
        ByteBuffer batch1 = pool.tryAllocate(batchSize);
        Assertions.assertNotNull((Object)batch1);
        ByteBuffer batch2 = pool.tryAllocate(batchSize);
        Assertions.assertNotNull((Object)batch2);
        ByteBuffer batch3 = pool.tryAllocate(batchSize);
        Assertions.assertNotNull((Object)batch3);
        ByteBuffer batch4 = pool.tryAllocate(batchSize);
        Assertions.assertNotNull((Object)batch4);
        Assertions.assertEquals((long)(4 * batchSize), (long)pool.size());
        this.release(batch4, pool, released);
        this.release(batch2, pool, released);
        ByteBuffer batch5 = pool.tryAllocate(batchSize);
        Assertions.assertTrue((boolean)released.contains(batch5));
        released.remove(batch5);
        this.release(batch1, pool, released);
        this.release(batch3, pool, released);
        ByteBuffer batch6 = pool.tryAllocate(batchSize);
        Assertions.assertTrue((boolean)released.contains(batch6));
        released.remove(batch6);
        this.release(batch5, pool, released);
        this.release(batch6, pool, released);
        Assertions.assertEquals((long)(maxRetainedBatches * batchSize), (long)pool.size());
    }

    @Test
    public void testOversizeAllocation() {
        int batchSize = 1024;
        int maxRetainedBatches = 3;
        BatchMemoryPool pool = new BatchMemoryPool(maxRetainedBatches, batchSize);
        Assertions.assertThrows(IllegalArgumentException.class, () -> pool.tryAllocate(batchSize + 1));
    }

    @Test
    public void testReleaseBufferNotMatchingBatchSize() {
        int batchSize = 1024;
        int maxRetainedBatches = 3;
        BatchMemoryPool pool = new BatchMemoryPool(maxRetainedBatches, batchSize);
        ByteBuffer buffer = ByteBuffer.allocate(1023);
        Assertions.assertThrows(IllegalArgumentException.class, () -> pool.release(buffer));
    }

    private ByteBuffer update(ByteBuffer buffer) {
        buffer.position(512);
        buffer.limit(724);
        return buffer;
    }

    private void release(ByteBuffer buffer, BatchMemoryPool pool, Set<ByteBuffer> released) {
        pool.release(buffer);
        released.add(buffer);
    }
}

