/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.LeaderState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetMetadata;
import org.apache.kafka.raft.internals.BatchAccumulator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

public class LeaderStateTest {
    private final int localId = 0;
    private final int epoch = 5;
    private final LogContext logContext = new LogContext();
    private final BatchAccumulator<?> accumulator = (BatchAccumulator)Mockito.mock(BatchAccumulator.class);

    private LeaderState<?> newLeaderState(Set<Integer> voters, long epochStartOffset) {
        return new LeaderState(0, 5, epochStartOffset, voters, voters, this.accumulator, this.logContext);
    }

    @Test
    public void testRequireNonNullAccumulator() {
        Assertions.assertThrows(NullPointerException.class, () -> new LeaderState(0, 5, 0L, Collections.emptySet(), Collections.emptySet(), null, this.logContext));
    }

    @Test
    public void testFollowerAcknowledgement() {
        int node1 = 1;
        int node2 = 2;
        LeaderState<?> state = this.newLeaderState(Utils.mkSet((Object[])new Integer[]{0, node1, node2}), 0L);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new Integer[]{node1, node2}), (Object)state.nonAcknowledgingVoters());
        state.addAcknowledgementFrom(node1);
        Assertions.assertEquals(Collections.singleton(node2), (Object)state.nonAcknowledgingVoters());
        state.addAcknowledgementFrom(node2);
        Assertions.assertEquals(Collections.emptySet(), (Object)state.nonAcknowledgingVoters());
    }

    @Test
    public void testNonFollowerAcknowledgement() {
        int nonVoterId = 1;
        LeaderState<?> state = this.newLeaderState(Collections.singleton(0), 0L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> state.addAcknowledgementFrom(nonVoterId));
    }

    @Test
    public void testUpdateHighWatermarkQuorumSizeOne() {
        LeaderState<?> state = this.newLeaderState(Collections.singleton(0), 15L);
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        Assertions.assertFalse((boolean)state.updateLocalState(new LogOffsetMetadata(15L)));
        Assertions.assertEquals(Collections.emptySet(), (Object)state.nonAcknowledgingVoters());
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        Assertions.assertTrue((boolean)state.updateLocalState(new LogOffsetMetadata(16L)));
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(16L)), (Object)state.highWatermark());
        Assertions.assertTrue((boolean)state.updateLocalState(new LogOffsetMetadata(20L)));
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(20L)), (Object)state.highWatermark());
    }

    @Test
    public void testNonMonotonicLocalEndOffsetUpdate() {
        LeaderState<?> state = this.newLeaderState(Collections.singleton(0), 15L);
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        Assertions.assertTrue((boolean)state.updateLocalState(new LogOffsetMetadata(16L)));
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(16L)), (Object)state.highWatermark());
        Assertions.assertThrows(IllegalStateException.class, () -> state.updateLocalState(new LogOffsetMetadata(15L)));
    }

    @Test
    public void testLastCaughtUpTimeVoters() {
        int node1 = 1;
        int node2 = 2;
        int currentTime = 1000;
        int fetchTime = 0;
        int caughtUpTime = -1;
        LeaderState<?> state = this.newLeaderState(Utils.mkSet((Object[])new Integer[]{0, node1, node2}), 10L);
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        Assertions.assertFalse((boolean)state.updateLocalState(new LogOffsetMetadata(10L)));
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new Integer[]{node1, node2}), (Object)state.nonAcknowledgingVoters());
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        Assertions.assertFalse((boolean)state.updateLocalState(new LogOffsetMetadata(11L)));
        Assertions.assertFalse((boolean)state.updateReplicaState(node1, (long)(++fetchTime), new LogOffsetMetadata(10L)));
        Assertions.assertEquals((long)currentTime, (long)this.describeVoterState(state, 0, currentTime).lastCaughtUpTimestamp());
        Assertions.assertEquals((long)caughtUpTime, (long)this.describeVoterState(state, node1, currentTime).lastCaughtUpTimestamp());
        Assertions.assertTrue((boolean)state.updateReplicaState(node1, (long)(++fetchTime), new LogOffsetMetadata(11L)));
        caughtUpTime = fetchTime++;
        Assertions.assertEquals((long)currentTime, (long)this.describeVoterState(state, 0, currentTime).lastCaughtUpTimestamp());
        Assertions.assertEquals((long)caughtUpTime, (long)this.describeVoterState(state, node1, currentTime).lastCaughtUpTimestamp());
        Assertions.assertFalse((boolean)state.updateLocalState(new LogOffsetMetadata(100L)));
        Assertions.assertTrue((boolean)state.updateReplicaState(node1, (long)fetchTime, new LogOffsetMetadata(50L)));
        Assertions.assertEquals((long)currentTime, (long)this.describeVoterState(state, 0, currentTime).lastCaughtUpTimestamp());
        Assertions.assertEquals((long)caughtUpTime, (long)this.describeVoterState(state, node1, currentTime).lastCaughtUpTimestamp());
        int prevFetchTime = fetchTime++;
        Assertions.assertFalse((boolean)state.updateLocalState(new LogOffsetMetadata(200L)));
        Assertions.assertTrue((boolean)state.updateReplicaState(node1, (long)fetchTime, new LogOffsetMetadata(100L)));
        caughtUpTime = prevFetchTime;
        Assertions.assertEquals((long)currentTime, (long)this.describeVoterState(state, 0, currentTime).lastCaughtUpTimestamp());
        Assertions.assertEquals((long)caughtUpTime, (long)this.describeVoterState(state, node1, currentTime).lastCaughtUpTimestamp());
        Assertions.assertEquals((long)-1L, (long)this.describeVoterState(state, node2, currentTime).lastCaughtUpTimestamp());
        Assertions.assertFalse((boolean)state.updateLocalState(new LogOffsetMetadata(300L)));
        Assertions.assertTrue((boolean)state.updateReplicaState(node2, (long)(++fetchTime), new LogOffsetMetadata(200L)));
        Assertions.assertEquals((long)-1L, (long)this.describeVoterState(state, node2, currentTime).lastCaughtUpTimestamp());
        Assertions.assertTrue((boolean)state.updateReplicaState(node2, (long)(++fetchTime), new LogOffsetMetadata(250L)));
        Assertions.assertEquals((long)-1L, (long)this.describeVoterState(state, node2, currentTime).lastCaughtUpTimestamp());
    }

    @Test
    public void testLastCaughtUpTimeObserver() {
        int node1 = 1;
        int currentTime = 1000;
        int fetchTime = 0;
        int caughtUpTime = -1;
        LeaderState<?> state = this.newLeaderState(Collections.singleton(0), 5L);
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        Assertions.assertEquals(Collections.emptySet(), (Object)state.nonAcknowledgingVoters());
        Assertions.assertTrue((boolean)state.updateLocalState(new LogOffsetMetadata(11L)));
        Assertions.assertFalse((boolean)state.updateReplicaState(node1, (long)(++fetchTime), new LogOffsetMetadata(10L)));
        Assertions.assertEquals((long)currentTime, (long)this.describeVoterState(state, 0, currentTime).lastCaughtUpTimestamp());
        Assertions.assertEquals((long)caughtUpTime, (long)this.describeObserverState(state, node1, currentTime).lastCaughtUpTimestamp());
        Assertions.assertFalse((boolean)state.updateReplicaState(node1, (long)(++fetchTime), new LogOffsetMetadata(11L)));
        caughtUpTime = fetchTime++;
        Assertions.assertEquals((long)currentTime, (long)this.describeVoterState(state, 0, currentTime).lastCaughtUpTimestamp());
        Assertions.assertEquals((long)caughtUpTime, (long)this.describeObserverState(state, node1, currentTime).lastCaughtUpTimestamp());
        Assertions.assertTrue((boolean)state.updateLocalState(new LogOffsetMetadata(100L)));
        Assertions.assertFalse((boolean)state.updateReplicaState(node1, (long)fetchTime, new LogOffsetMetadata(50L)));
        Assertions.assertEquals((long)currentTime, (long)this.describeVoterState(state, 0, currentTime).lastCaughtUpTimestamp());
        Assertions.assertEquals((long)caughtUpTime, (long)this.describeObserverState(state, node1, currentTime).lastCaughtUpTimestamp());
        int prevFetchTime = fetchTime++;
        Assertions.assertTrue((boolean)state.updateLocalState(new LogOffsetMetadata(200L)));
        Assertions.assertFalse((boolean)state.updateReplicaState(node1, (long)fetchTime, new LogOffsetMetadata(102L)));
        caughtUpTime = prevFetchTime;
        Assertions.assertEquals((long)currentTime, (long)this.describeVoterState(state, 0, currentTime).lastCaughtUpTimestamp());
        Assertions.assertEquals((long)caughtUpTime, (long)this.describeObserverState(state, node1, currentTime).lastCaughtUpTimestamp());
        Assertions.assertFalse((boolean)state.updateReplicaState(node1, (long)(++fetchTime), new LogOffsetMetadata(200L)));
        caughtUpTime = fetchTime;
        Assertions.assertEquals((long)currentTime, (long)this.describeVoterState(state, 0, currentTime).lastCaughtUpTimestamp());
        Assertions.assertEquals((long)caughtUpTime, (long)this.describeObserverState(state, node1, currentTime).lastCaughtUpTimestamp());
    }

    @Test
    public void testIdempotentEndOffsetUpdate() {
        LeaderState<?> state = this.newLeaderState(Collections.singleton(0), 15L);
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        Assertions.assertTrue((boolean)state.updateLocalState(new LogOffsetMetadata(16L)));
        Assertions.assertFalse((boolean)state.updateLocalState(new LogOffsetMetadata(16L)));
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(16L)), (Object)state.highWatermark());
    }

    @Test
    public void testUpdateHighWatermarkMetadata() {
        LeaderState<?> state = this.newLeaderState(Collections.singleton(0), 15L);
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        LogOffsetMetadata initialHw = new LogOffsetMetadata(16L, Optional.of(new MockOffsetMetadata("bar")));
        Assertions.assertTrue((boolean)state.updateLocalState(initialHw));
        Assertions.assertEquals(Optional.of(initialHw), (Object)state.highWatermark());
        LogOffsetMetadata updateHw = new LogOffsetMetadata(16L, Optional.of(new MockOffsetMetadata("baz")));
        Assertions.assertTrue((boolean)state.updateLocalState(updateHw));
        Assertions.assertEquals(Optional.of(updateHw), (Object)state.highWatermark());
    }

    @Test
    public void testUpdateHighWatermarkQuorumSizeTwo() {
        int otherNodeId = 1;
        LeaderState<?> state = this.newLeaderState(Utils.mkSet((Object[])new Integer[]{0, otherNodeId}), 10L);
        Assertions.assertFalse((boolean)state.updateLocalState(new LogOffsetMetadata(13L)));
        Assertions.assertEquals(Collections.singleton(otherNodeId), (Object)state.nonAcknowledgingVoters());
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        Assertions.assertFalse((boolean)state.updateReplicaState(otherNodeId, 0L, new LogOffsetMetadata(10L)));
        Assertions.assertEquals(Collections.emptySet(), (Object)state.nonAcknowledgingVoters());
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        Assertions.assertTrue((boolean)state.updateReplicaState(otherNodeId, 0L, new LogOffsetMetadata(11L)));
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(11L)), (Object)state.highWatermark());
        Assertions.assertTrue((boolean)state.updateReplicaState(otherNodeId, 0L, new LogOffsetMetadata(13L)));
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(13L)), (Object)state.highWatermark());
    }

    @Test
    public void testUpdateHighWatermarkQuorumSizeThree() {
        int node1 = 1;
        int node2 = 2;
        LeaderState<?> state = this.newLeaderState(Utils.mkSet((Object[])new Integer[]{0, node1, node2}), 10L);
        Assertions.assertFalse((boolean)state.updateLocalState(new LogOffsetMetadata(15L)));
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new Integer[]{node1, node2}), (Object)state.nonAcknowledgingVoters());
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        Assertions.assertFalse((boolean)state.updateReplicaState(node1, 0L, new LogOffsetMetadata(10L)));
        Assertions.assertEquals(Collections.singleton(node2), (Object)state.nonAcknowledgingVoters());
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        Assertions.assertFalse((boolean)state.updateReplicaState(node2, 0L, new LogOffsetMetadata(10L)));
        Assertions.assertEquals(Collections.emptySet(), (Object)state.nonAcknowledgingVoters());
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        Assertions.assertTrue((boolean)state.updateReplicaState(node2, 0L, new LogOffsetMetadata(15L)));
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(15L)), (Object)state.highWatermark());
        Assertions.assertFalse((boolean)state.updateLocalState(new LogOffsetMetadata(20L)));
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(15L)), (Object)state.highWatermark());
        Assertions.assertTrue((boolean)state.updateReplicaState(node1, 0L, new LogOffsetMetadata(20L)));
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(20L)), (Object)state.highWatermark());
        Assertions.assertFalse((boolean)state.updateReplicaState(node2, 0L, new LogOffsetMetadata(20L)));
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(20L)), (Object)state.highWatermark());
    }

    @Test
    public void testNonMonotonicHighWatermarkUpdate() {
        MockTime time = new MockTime();
        int node1 = 1;
        LeaderState<?> state = this.newLeaderState(Utils.mkSet((Object[])new Integer[]{0, node1}), 0L);
        state.updateLocalState(new LogOffsetMetadata(10L));
        state.updateReplicaState(node1, time.milliseconds(), new LogOffsetMetadata(10L));
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(10L)), (Object)state.highWatermark());
        Assertions.assertFalse((boolean)state.updateReplicaState(node1, time.milliseconds(), new LogOffsetMetadata(5L)));
        Assertions.assertEquals((long)5L, (long)this.describeVoterState(state, node1, time.milliseconds()).logEndOffset());
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(10L)), (Object)state.highWatermark());
    }

    @Test
    public void testGetNonLeaderFollowersByFetchOffsetDescending() {
        int node1 = 1;
        int node2 = 2;
        long leaderStartOffset = 10L;
        long leaderEndOffset = 15L;
        LeaderState<?> state = this.setUpLeaderAndFollowers(node1, node2, leaderStartOffset, leaderEndOffset);
        Assertions.assertEquals(Arrays.asList(node2, node1), (Object)state.nonLeaderVotersByDescendingFetchOffset());
    }

    @Test
    public void testDescribeQuorumWithSingleVoter() {
        MockTime time = new MockTime();
        long leaderStartOffset = 10L;
        long leaderEndOffset = 15L;
        LeaderState<?> state = this.newLeaderState(Utils.mkSet((Object[])new Integer[]{0}), leaderStartOffset);
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        DescribeQuorumResponseData.PartitionData partitionData = state.describeQuorum(time.milliseconds());
        Assertions.assertEquals((long)-1L, (long)partitionData.highWatermark());
        Assertions.assertEquals((int)0, (int)partitionData.leaderId());
        Assertions.assertEquals((int)5, (int)partitionData.leaderEpoch());
        Assertions.assertEquals(Collections.emptyList(), (Object)partitionData.observers());
        Assertions.assertEquals((int)1, (int)partitionData.currentVoters().size());
        Assertions.assertEquals((Object)new DescribeQuorumResponseData.ReplicaState().setReplicaId(0).setLogEndOffset(-1L).setLastFetchTimestamp(time.milliseconds()).setLastCaughtUpTimestamp(time.milliseconds()), partitionData.currentVoters().get(0));
        Assertions.assertTrue((boolean)state.updateLocalState(new LogOffsetMetadata(leaderEndOffset)));
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(leaderEndOffset)), (Object)state.highWatermark());
        time.sleep(500L);
        partitionData = state.describeQuorum(time.milliseconds());
        Assertions.assertEquals((long)leaderEndOffset, (long)partitionData.highWatermark());
        Assertions.assertEquals((int)0, (int)partitionData.leaderId());
        Assertions.assertEquals((int)5, (int)partitionData.leaderEpoch());
        Assertions.assertEquals(Collections.emptyList(), (Object)partitionData.observers());
        Assertions.assertEquals((int)1, (int)partitionData.currentVoters().size());
        Assertions.assertEquals((Object)new DescribeQuorumResponseData.ReplicaState().setReplicaId(0).setLogEndOffset(leaderEndOffset).setLastFetchTimestamp(time.milliseconds()).setLastCaughtUpTimestamp(time.milliseconds()), partitionData.currentVoters().get(0));
    }

    @Test
    public void testDescribeQuorumWithMultipleVoters() {
        MockTime time = new MockTime();
        int activeFollowerId = 1;
        int inactiveFollowerId = 2;
        long leaderStartOffset = 10L;
        long leaderEndOffset = 15L;
        LeaderState<?> state = this.newLeaderState(Utils.mkSet((Object[])new Integer[]{0, activeFollowerId, inactiveFollowerId}), leaderStartOffset);
        Assertions.assertFalse((boolean)state.updateLocalState(new LogOffsetMetadata(leaderEndOffset)));
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        long activeFollowerFetchTimeMs = time.milliseconds();
        Assertions.assertTrue((boolean)state.updateReplicaState(activeFollowerId, activeFollowerFetchTimeMs, new LogOffsetMetadata(leaderEndOffset)));
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(leaderEndOffset)), (Object)state.highWatermark());
        time.sleep(500L);
        DescribeQuorumResponseData.PartitionData partitionData = state.describeQuorum(time.milliseconds());
        Assertions.assertEquals((long)leaderEndOffset, (long)partitionData.highWatermark());
        Assertions.assertEquals((int)0, (int)partitionData.leaderId());
        Assertions.assertEquals((int)5, (int)partitionData.leaderEpoch());
        Assertions.assertEquals(Collections.emptyList(), (Object)partitionData.observers());
        List voterStates = partitionData.currentVoters();
        Assertions.assertEquals((int)3, (int)voterStates.size());
        DescribeQuorumResponseData.ReplicaState leaderState = this.findReplicaOrFail(0, partitionData.currentVoters());
        Assertions.assertEquals((Object)new DescribeQuorumResponseData.ReplicaState().setReplicaId(0).setLogEndOffset(leaderEndOffset).setLastFetchTimestamp(time.milliseconds()).setLastCaughtUpTimestamp(time.milliseconds()), (Object)leaderState);
        DescribeQuorumResponseData.ReplicaState activeFollowerState = this.findReplicaOrFail(activeFollowerId, partitionData.currentVoters());
        Assertions.assertEquals((Object)new DescribeQuorumResponseData.ReplicaState().setReplicaId(activeFollowerId).setLogEndOffset(leaderEndOffset).setLastFetchTimestamp(activeFollowerFetchTimeMs).setLastCaughtUpTimestamp(activeFollowerFetchTimeMs), (Object)activeFollowerState);
        DescribeQuorumResponseData.ReplicaState inactiveFollowerState = this.findReplicaOrFail(inactiveFollowerId, partitionData.currentVoters());
        Assertions.assertEquals((Object)new DescribeQuorumResponseData.ReplicaState().setReplicaId(inactiveFollowerId).setLogEndOffset(-1L).setLastFetchTimestamp(-1L).setLastCaughtUpTimestamp(-1L), (Object)inactiveFollowerState);
    }

    private LeaderState<?> setUpLeaderAndFollowers(int follower1, int follower2, long leaderStartOffset, long leaderEndOffset) {
        LeaderState<?> state = this.newLeaderState(Utils.mkSet((Object[])new Integer[]{0, follower1, follower2}), leaderStartOffset);
        state.updateLocalState(new LogOffsetMetadata(leaderEndOffset));
        Assertions.assertEquals(Optional.empty(), (Object)state.highWatermark());
        state.updateReplicaState(follower1, 0L, new LogOffsetMetadata(leaderStartOffset));
        state.updateReplicaState(follower2, 0L, new LogOffsetMetadata(leaderEndOffset));
        return state;
    }

    @Test
    public void testDescribeQuorumWithObservers() {
        MockTime time = new MockTime();
        int observerId = 10;
        long epochStartOffset = 10L;
        LeaderState<?> state = this.newLeaderState(Utils.mkSet((Object[])new Integer[]{0}), epochStartOffset);
        Assertions.assertTrue((boolean)state.updateLocalState(new LogOffsetMetadata(epochStartOffset + 1L)));
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(epochStartOffset + 1L)), (Object)state.highWatermark());
        time.sleep(500L);
        long observerFetchTimeMs = time.milliseconds();
        Assertions.assertFalse((boolean)state.updateReplicaState(observerId, observerFetchTimeMs, new LogOffsetMetadata(epochStartOffset + 1L)));
        time.sleep(500L);
        DescribeQuorumResponseData.PartitionData partitionData = state.describeQuorum(time.milliseconds());
        Assertions.assertEquals((long)(epochStartOffset + 1L), (long)partitionData.highWatermark());
        Assertions.assertEquals((int)0, (int)partitionData.leaderId());
        Assertions.assertEquals((int)5, (int)partitionData.leaderEpoch());
        Assertions.assertEquals((int)1, (int)partitionData.currentVoters().size());
        Assertions.assertEquals((int)0, (int)((DescribeQuorumResponseData.ReplicaState)partitionData.currentVoters().get(0)).replicaId());
        List observerStates = partitionData.observers();
        Assertions.assertEquals((int)1, (int)observerStates.size());
        DescribeQuorumResponseData.ReplicaState observerState = (DescribeQuorumResponseData.ReplicaState)observerStates.get(0);
        Assertions.assertEquals((Object)new DescribeQuorumResponseData.ReplicaState().setReplicaId(observerId).setLogEndOffset(epochStartOffset + 1L).setLastFetchTimestamp(observerFetchTimeMs).setLastCaughtUpTimestamp(observerFetchTimeMs), (Object)observerState);
    }

    @Test
    public void testNoOpForNegativeRemoteNodeId() {
        MockTime time = new MockTime();
        int replicaId = -1;
        long epochStartOffset = 10L;
        LeaderState<?> state = this.newLeaderState(Utils.mkSet((Object[])new Integer[]{0}), epochStartOffset);
        Assertions.assertFalse((boolean)state.updateReplicaState(replicaId, 0L, new LogOffsetMetadata(epochStartOffset)));
        DescribeQuorumResponseData.PartitionData partitionData = state.describeQuorum(time.milliseconds());
        List observerStates = partitionData.observers();
        Assertions.assertEquals(Collections.emptyList(), (Object)observerStates);
    }

    @Test
    public void testObserverStateExpiration() {
        MockTime time = new MockTime();
        int observerId = 10;
        long epochStartOffset = 10L;
        LeaderState<?> state = this.newLeaderState(Utils.mkSet((Object[])new Integer[]{0}), epochStartOffset);
        state.updateReplicaState(observerId, time.milliseconds(), new LogOffsetMetadata(epochStartOffset));
        DescribeQuorumResponseData.PartitionData partitionData = state.describeQuorum(time.milliseconds());
        List observerStates = partitionData.observers();
        Assertions.assertEquals((int)1, (int)observerStates.size());
        DescribeQuorumResponseData.ReplicaState observerState = (DescribeQuorumResponseData.ReplicaState)observerStates.get(0);
        Assertions.assertEquals((int)observerId, (int)observerState.replicaId());
        time.sleep(300000L);
        partitionData = state.describeQuorum(time.milliseconds());
        Assertions.assertEquals(Collections.emptyList(), (Object)partitionData.observers());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGrantVote(boolean isLogUpToDate) {
        LeaderState<?> state = this.newLeaderState(Utils.mkSet((Object[])new Integer[]{1, 2, 3}), 1L);
        Assertions.assertFalse((boolean)state.canGrantVote(1, isLogUpToDate));
        Assertions.assertFalse((boolean)state.canGrantVote(2, isLogUpToDate));
        Assertions.assertFalse((boolean)state.canGrantVote(3, isLogUpToDate));
    }

    private DescribeQuorumResponseData.ReplicaState describeVoterState(LeaderState state, int voterId, long currentTimeMs) {
        DescribeQuorumResponseData.PartitionData partitionData = state.describeQuorum(currentTimeMs);
        return this.findReplicaOrFail(voterId, partitionData.currentVoters());
    }

    private DescribeQuorumResponseData.ReplicaState describeObserverState(LeaderState state, int observerId, long currentTimeMs) {
        DescribeQuorumResponseData.PartitionData partitionData = state.describeQuorum(currentTimeMs);
        return this.findReplicaOrFail(observerId, partitionData.observers());
    }

    private DescribeQuorumResponseData.ReplicaState findReplicaOrFail(int replicaId, List<DescribeQuorumResponseData.ReplicaState> replicas) {
        return replicas.stream().filter(observer -> observer.replicaId() == replicaId).findFirst().orElseThrow(() -> new AssertionError((Object)("Failed to find expected replica state for replica " + replicaId)));
    }

    private static class MockOffsetMetadata
    implements OffsetMetadata {
        private final String value;

        private MockOffsetMetadata(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MockOffsetMetadata that = (MockOffsetMetadata)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

