/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.FollowerState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class FollowerStateTest {
    private final MockTime time = new MockTime();
    private final LogContext logContext = new LogContext();
    private final int epoch = 5;
    private final int fetchTimeoutMs = 15000;
    int leaderId = 3;

    private FollowerState newFollowerState(Set<Integer> voters, Optional<LogOffsetMetadata> highWatermark) {
        return new FollowerState((Time)this.time, 5, this.leaderId, voters, highWatermark, 15000, this.logContext);
    }

    @Test
    public void testFetchTimeoutExpiration() {
        FollowerState state = this.newFollowerState(Utils.mkSet((Object[])new Integer[]{1, 2, 3}), Optional.empty());
        Assertions.assertFalse((boolean)state.hasFetchTimeoutExpired(this.time.milliseconds()));
        Assertions.assertEquals((long)15000L, (long)state.remainingFetchTimeMs(this.time.milliseconds()));
        this.time.sleep(5000L);
        Assertions.assertFalse((boolean)state.hasFetchTimeoutExpired(this.time.milliseconds()));
        Assertions.assertEquals((long)10000L, (long)state.remainingFetchTimeMs(this.time.milliseconds()));
        this.time.sleep(10000L);
        Assertions.assertTrue((boolean)state.hasFetchTimeoutExpired(this.time.milliseconds()));
        Assertions.assertEquals((long)0L, (long)state.remainingFetchTimeMs(this.time.milliseconds()));
    }

    @Test
    public void testMonotonicHighWatermark() {
        FollowerState state = this.newFollowerState(Utils.mkSet((Object[])new Integer[]{1, 2, 3}), Optional.empty());
        OptionalLong highWatermark = OptionalLong.of(15L);
        state.updateHighWatermark(highWatermark);
        Assertions.assertThrows(IllegalArgumentException.class, () -> state.updateHighWatermark(OptionalLong.empty()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> state.updateHighWatermark(OptionalLong.of(14L)));
        state.updateHighWatermark(highWatermark);
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(15L)), (Object)state.highWatermark());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGrantVote(boolean isLogUpToDate) {
        FollowerState state = this.newFollowerState(Utils.mkSet((Object[])new Integer[]{1, 2, 3}), Optional.empty());
        Assertions.assertFalse((boolean)state.canGrantVote(1, isLogUpToDate));
        Assertions.assertFalse((boolean)state.canGrantVote(2, isLogUpToDate));
        Assertions.assertFalse((boolean)state.canGrantVote(3, isLogUpToDate));
    }
}

