/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.image.node.ClientQuotasImageNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ClientQuotasImageNodeTest {
    @Test
    public void testEscapeEmptyString() {
        Assertions.assertEquals((Object)"", (Object)ClientQuotasImageNode.escape((String)""));
    }

    @Test
    public void testEscapeNormalString() {
        Assertions.assertEquals((Object)"abracadabra", (Object)ClientQuotasImageNode.escape((String)"abracadabra"));
    }

    @Test
    public void testEscapeBackslashes() {
        Assertions.assertEquals((Object)"\\\\foo\\\\bar", (Object)ClientQuotasImageNode.escape((String)"\\foo\\bar"));
    }

    @Test
    public void testEscapeParentheses() {
        Assertions.assertEquals((Object)"\\(bob's name\\)", (Object)ClientQuotasImageNode.escape((String)"(bob's name)"));
    }

    private void entityToStringRoundTrip(ClientQuotaEntity entity, String expected) {
        String entityString = ClientQuotasImageNode.clientQuotaEntityToString((ClientQuotaEntity)entity);
        Assertions.assertEquals((Object)expected, (Object)entityString);
        ClientQuotaEntity entity2 = ClientQuotasImageNode.decodeEntity((String)entityString);
        Assertions.assertEquals((Object)entity, (Object)entity2);
    }

    @Test
    public void clientIdEntityRoundTrip() {
        this.entityToStringRoundTrip(new ClientQuotaEntity(Collections.singletonMap("client-id", "foo")), "clientId(foo)");
    }

    @Test
    public void defaultClientIdEntityRoundTrip() {
        this.entityToStringRoundTrip(new ClientQuotaEntity(Collections.singletonMap("client-id", "")), "clientId()");
    }

    @Test
    public void userEntityRoundTrip() {
        this.entityToStringRoundTrip(new ClientQuotaEntity(Collections.singletonMap("user", "my-user-name")), "user(my-user-name)");
    }

    @Test
    public void defaultUserEntityRoundTrip() {
        this.entityToStringRoundTrip(new ClientQuotaEntity(Collections.singletonMap("user", "")), "user()");
    }

    @Test
    public void clientIdAndUserEntityRoundTrip() {
        HashMap<String, String> entityMap = new HashMap<String, String>();
        entityMap.put("user", "bob");
        entityMap.put("client-id", "reports12345");
        this.entityToStringRoundTrip(new ClientQuotaEntity(entityMap), "clientId(reports12345)_user(bob)");
    }

    @Test
    public void ipEntityRoundTrip() {
        this.entityToStringRoundTrip(new ClientQuotaEntity(Collections.singletonMap("ip", "127.0.0.1")), "ip(127.0.0.1)");
    }

    @Test
    public void defaultIpEntityRoundTrip() {
        this.entityToStringRoundTrip(new ClientQuotaEntity(Collections.singletonMap("ip", "")), "ip()");
    }

    @Test
    public void testUserEntityWithBackslashesInNameRoundTrip() {
        this.entityToStringRoundTrip(new ClientQuotaEntity(Collections.singletonMap("user", "foo\\bar")), "user(foo\\\\bar)");
    }

    @Test
    public void testClientIdEntityWithParentheses() {
        this.entityToStringRoundTrip(new ClientQuotaEntity(Collections.singletonMap("client-id", "(this )one)")), "clientId(\\(this \\)one\\))");
    }

    @Test
    public void testErrorOnInvalidEmptyEntityName() {
        Assertions.assertEquals((Object)"Invalid empty entity", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ClientQuotasImageNode.clientQuotaEntityToString((ClientQuotaEntity)new ClientQuotaEntity(Collections.emptyMap())))).getMessage());
    }

    @Test
    public void testErrorOnInvalidEntityType() {
        Assertions.assertEquals((Object)"Invalid entity type foobar", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ClientQuotasImageNode.clientQuotaEntityToString((ClientQuotaEntity)new ClientQuotaEntity(Collections.singletonMap("foobar", "baz"))))).getMessage());
    }
}

