/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.controller.metrics.ControllerMetadataMetricsPublisher;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.image.loader.SnapshotManifest;
import org.apache.kafka.image.writer.ImageReWriter;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ControllerMetadataMetricsPublisherTest {
    static final TopicsImage TOPICS_IMAGE1 = ControllerMetricsTestUtils.fakeTopicsImage(ControllerMetricsTestUtils.fakeTopicImage("foo", Uuid.fromString((String)"JKNp6fQaT-icHxh654ok-w"), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL)), ControllerMetricsTestUtils.fakeTopicImage("bar", Uuid.fromString((String)"pEMSdUVWTXaFQUzLTznFSw"), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NON_PREFERRED_LEADER)), ControllerMetricsTestUtils.fakeTopicImage("quux", Uuid.fromString((String)"zkUT4lyyRke6VIaTw6RQWg"), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.OFFLINE), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.OFFLINE), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.OFFLINE)));
    static final MetadataImage IMAGE1 = ControllerMetadataMetricsPublisherTest.fakeImageFromTopicsImage(TOPICS_IMAGE1);

    @Test
    public void testMetricsBeforePublishing() {
        try (TestEnv env = new TestEnv();){
            Assertions.assertEquals((int)0, (int)env.metrics.activeBrokerCount());
            Assertions.assertEquals((int)0, (int)env.metrics.globalTopicCount());
            Assertions.assertEquals((int)0, (int)env.metrics.globalPartitionCount());
            Assertions.assertEquals((int)0, (int)env.metrics.offlinePartitionCount());
            Assertions.assertEquals((int)0, (int)env.metrics.preferredReplicaImbalanceCount());
            Assertions.assertEquals((int)0, (int)env.metrics.metadataErrorCount());
        }
    }

    static MetadataImage fakeImageFromTopicsImage(TopicsImage topicsImage) {
        return new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImage.EMPTY, topicsImage, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY);
    }

    @Test
    public void testPublish() {
        try (TestEnv env = new TestEnv();){
            Assertions.assertEquals((int)0, (int)env.metrics.activeBrokerCount());
            Assertions.assertEquals((int)0, (int)env.metrics.globalTopicCount());
            Assertions.assertEquals((int)0, (int)env.metrics.globalPartitionCount());
            Assertions.assertEquals((int)0, (int)env.metrics.offlinePartitionCount());
            Assertions.assertEquals((int)0, (int)env.metrics.preferredReplicaImbalanceCount());
            Assertions.assertEquals((int)0, (int)env.metrics.metadataErrorCount());
        }
    }

    static LoaderManifest fakeManifest(boolean isSnapshot) {
        if (isSnapshot) {
            return new SnapshotManifest(MetadataProvenance.EMPTY, 0L);
        }
        return LogDeltaManifest.newBuilder().provenance(MetadataProvenance.EMPTY).leaderAndEpoch(LeaderAndEpoch.UNKNOWN).numBatches(0).elapsedNs(0L).numBytes(0L).build();
    }

    @Test
    public void testLoadSnapshot() {
        try (TestEnv env = new TestEnv();){
            MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
            ImageReWriter writer = new ImageReWriter(delta);
            IMAGE1.write((ImageWriter)writer, new ImageWriterOptions.Builder().setMetadataVersion(delta.image().features().metadataVersion()).build());
            env.publisher.onMetadataUpdate(delta, IMAGE1, ControllerMetadataMetricsPublisherTest.fakeManifest(true));
            Assertions.assertEquals((int)0, (int)env.metrics.activeBrokerCount());
            Assertions.assertEquals((int)3, (int)env.metrics.globalTopicCount());
            Assertions.assertEquals((int)7, (int)env.metrics.globalPartitionCount());
            Assertions.assertEquals((int)3, (int)env.metrics.offlinePartitionCount());
            Assertions.assertEquals((int)4, (int)env.metrics.preferredReplicaImbalanceCount());
            Assertions.assertEquals((int)0, (int)env.metrics.metadataErrorCount());
        }
    }

    static class TestEnv
    implements AutoCloseable {
        MockFaultHandler faultHandler = new MockFaultHandler("ControllerMetadataMetricsPublisher");
        ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.empty());
        ControllerMetadataMetricsPublisher publisher = new ControllerMetadataMetricsPublisher(this.metrics, (FaultHandler)this.faultHandler);

        TestEnv() {
        }

        @Override
        public void close() {
            this.publisher.close();
            this.faultHandler.maybeRethrowFirstException();
        }
    }
}

