/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.errors;

import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.RejectedExecutionException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.controller.errors.EventHandlerExceptionInfo;
import org.apache.kafka.raft.errors.NotLeaderException;
import org.apache.kafka.raft.errors.UnexpectedBaseOffsetException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class EventHandlerExceptionInfoTest {
    private static final EventHandlerExceptionInfo TOPIC_EXISTS = EventHandlerExceptionInfo.fromInternal((Throwable)new TopicExistsException("Topic exists."), () -> OptionalInt.empty());
    private static final EventHandlerExceptionInfo REJECTED_EXECUTION = EventHandlerExceptionInfo.fromInternal((Throwable)new RejectedExecutionException(), () -> OptionalInt.empty());
    private static final EventHandlerExceptionInfo INTERRUPTED = EventHandlerExceptionInfo.fromInternal((Throwable)new InterruptedException(), () -> OptionalInt.of(1));
    private static final EventHandlerExceptionInfo NULL_POINTER = EventHandlerExceptionInfo.fromInternal((Throwable)new NullPointerException(), () -> OptionalInt.of(1));
    private static final EventHandlerExceptionInfo NOT_LEADER = EventHandlerExceptionInfo.fromInternal((Throwable)new NotLeaderException("Append failed"), () -> OptionalInt.of(2));
    private static final EventHandlerExceptionInfo UNEXPECTED_END_OFFSET = EventHandlerExceptionInfo.fromInternal((Throwable)new UnexpectedBaseOffsetException("Wanted base offset 3, but the next offset was 4"), () -> OptionalInt.of(1));
    private static final EventHandlerExceptionInfo TIMEOUT = EventHandlerExceptionInfo.fromInternal((Throwable)new TimeoutException(), () -> OptionalInt.of(1));

    @Test
    public void testTopicExistsExceptionInfo() {
        Assertions.assertEquals((Object)new EventHandlerExceptionInfo(false, false, (Throwable)new TopicExistsException("Topic exists.")), (Object)TOPIC_EXISTS);
    }

    @Test
    public void testTopicExistsExceptionFailureMessage() {
        Assertions.assertEquals((Object)"event failed with TopicExistsException in 234 microseconds.", (Object)TOPIC_EXISTS.failureMessage(123, OptionalLong.of(234L), true, 456L));
    }

    @Test
    public void testRejectedExecutionExceptionInfo() {
        Assertions.assertEquals((Object)new EventHandlerExceptionInfo(false, false, (Throwable)new RejectedExecutionException(), (Throwable)new TimeoutException("The controller is shutting down.", (Throwable)new RejectedExecutionException())), (Object)REJECTED_EXECUTION);
    }

    @Test
    public void testRejectedExecutionExceptionFailureMessage() {
        Assertions.assertEquals((Object)"event unable to start processing because of RejectedExecutionException (treated as TimeoutException).", (Object)REJECTED_EXECUTION.failureMessage(123, OptionalLong.empty(), true, 456L));
    }

    @Test
    public void testInterruptedExceptionInfo() {
        Assertions.assertEquals((Object)new EventHandlerExceptionInfo(true, true, (Throwable)new InterruptedException(), (Throwable)new UnknownServerException("The controller was interrupted.")), (Object)INTERRUPTED);
    }

    @Test
    public void testInterruptedExceptionFailureMessageWhenActive() {
        Assertions.assertEquals((Object)"event unable to start processing because of InterruptedException (treated as UnknownServerException) at epoch 123. Renouncing leadership and reverting to the last committed offset 456.", (Object)INTERRUPTED.failureMessage(123, OptionalLong.empty(), true, 456L));
    }

    @Test
    public void testInterruptedExceptionFailureMessageWhenInactive() {
        Assertions.assertEquals((Object)"event unable to start processing because of InterruptedException (treated as UnknownServerException) at epoch 123. The controller is already in standby mode.", (Object)INTERRUPTED.failureMessage(123, OptionalLong.empty(), false, 456L));
    }

    @Test
    public void testNullPointerExceptionInfo() {
        Assertions.assertEquals((Object)new EventHandlerExceptionInfo(true, true, (Throwable)new NullPointerException(), (Throwable)new UnknownServerException((Throwable)new NullPointerException())), (Object)NULL_POINTER);
    }

    @Test
    public void testNullPointerExceptionFailureMessageWhenActive() {
        Assertions.assertEquals((Object)"event failed with NullPointerException (treated as UnknownServerException) at epoch 123 in 40 microseconds. Renouncing leadership and reverting to the last committed offset 456.", (Object)NULL_POINTER.failureMessage(123, OptionalLong.of(40L), true, 456L));
    }

    @Test
    public void testNullPointerExceptionFailureMessageWhenInactive() {
        Assertions.assertEquals((Object)"event failed with NullPointerException (treated as UnknownServerException) at epoch 123 in 40 microseconds. The controller is already in standby mode.", (Object)NULL_POINTER.failureMessage(123, OptionalLong.of(40L), false, 456L));
    }

    @Test
    public void testNotLeaderExceptionInfo() {
        Assertions.assertEquals((Object)new EventHandlerExceptionInfo(false, true, (Throwable)new NotLeaderException("Append failed"), (Throwable)new NotControllerException("The active controller appears to be node 2.")), (Object)NOT_LEADER);
    }

    @Test
    public void testNotLeaderExceptionFailureMessage() {
        Assertions.assertEquals((Object)"event unable to start processing because of NotLeaderException (treated as NotControllerException) at epoch 123. Renouncing leadership and reverting to the last committed offset 456.", (Object)NOT_LEADER.failureMessage(123, OptionalLong.empty(), true, 456L));
    }

    @Test
    public void testUnexpectedBaseOffsetExceptionInfo() {
        Assertions.assertEquals((Object)new EventHandlerExceptionInfo(false, true, (Throwable)new UnexpectedBaseOffsetException("Wanted base offset 3, but the next offset was 4"), (Throwable)new NotControllerException("Unexpected end offset. Controller will resign.")), (Object)UNEXPECTED_END_OFFSET);
    }

    @Test
    public void testUnexpectedBaseOffsetFailureMessage() {
        Assertions.assertEquals((Object)"event failed with UnexpectedBaseOffsetException (treated as NotControllerException) at epoch 123 in 90 microseconds. Renouncing leadership and reverting to the last committed offset 456.", (Object)UNEXPECTED_END_OFFSET.failureMessage(123, OptionalLong.of(90L), true, 456L));
    }

    @Test
    public void testIsNotTimeoutException() {
        Assertions.assertFalse((boolean)TOPIC_EXISTS.isTimeoutException());
        Assertions.assertFalse((boolean)REJECTED_EXECUTION.isTimeoutException());
        Assertions.assertFalse((boolean)INTERRUPTED.isTimeoutException());
        Assertions.assertFalse((boolean)NULL_POINTER.isTimeoutException());
        Assertions.assertFalse((boolean)NOT_LEADER.isTimeoutException());
        Assertions.assertFalse((boolean)UNEXPECTED_END_OFFSET.isTimeoutException());
    }

    @Test
    public void testIsTimeoutException() {
        Assertions.assertTrue((boolean)TIMEOUT.isTimeoutException());
    }
}

