/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Collections;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.Provide;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class PartitionRegistrationTest {
    @Test
    public void testElectionWasClean() {
        Assertions.assertTrue((boolean)PartitionRegistration.electionWasClean((int)1, (int[])new int[]{1, 2}));
        Assertions.assertFalse((boolean)PartitionRegistration.electionWasClean((int)1, (int[])new int[]{0, 2}));
        Assertions.assertFalse((boolean)PartitionRegistration.electionWasClean((int)1, (int[])new int[0]));
        Assertions.assertTrue((boolean)PartitionRegistration.electionWasClean((int)3, (int[])new int[]{1, 2, 3, 4, 5, 6}));
    }

    @Test
    public void testPartitionControlInfoMergeAndDiff() {
        PartitionRegistration a = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build();
        PartitionRegistration b = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{3}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(1)).build();
        PartitionRegistration c = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(1)).build();
        Assertions.assertEquals((Object)b, (Object)a.merge(new PartitionChangeRecord().setLeader(3).setIsr(Arrays.asList(3))));
        Assertions.assertEquals((Object)"isr: [1, 2] -> [3], leader: 1 -> 3, leaderEpoch: 0 -> 1, partitionEpoch: 0 -> 1", (Object)b.diff(a));
        Assertions.assertEquals((Object)"isr: [1, 2] -> [1], partitionEpoch: 0 -> 1", (Object)c.diff(a));
    }

    @Test
    public void testRecordRoundTrip() {
        PartitionRegistration registrationA = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2}).setRemovingReplicas(new int[]{1}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build();
        Uuid topicId = Uuid.fromString((String)"OGdAI5nxT_m-ds3rJMqPLA");
        int partitionId = 4;
        ApiMessageAndVersion record = registrationA.toRecord(topicId, partitionId);
        PartitionRegistration registrationB = new PartitionRegistration((PartitionRecord)record.message());
        Assertions.assertEquals((Object)registrationA, (Object)registrationB);
    }

    @Test
    public void testToLeaderAndIsrPartitionState() {
        PartitionRegistration a = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(123)).setPartitionEpoch(Integer.valueOf(456)).build();
        PartitionRegistration b = new PartitionRegistration.Builder().setReplicas(new int[]{2, 3, 4}).setIsr(new int[]{2, 3, 4}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(234)).setPartitionEpoch(Integer.valueOf(567)).build();
        Assertions.assertEquals((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("foo").setPartitionIndex(1).setControllerEpoch(-1).setLeader(1).setLeaderEpoch(123).setIsr(Arrays.asList(1, 2)).setPartitionEpoch(456).setReplicas(Arrays.asList(1, 2, 3)).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList()).setIsNew(true).toString(), (Object)a.toLeaderAndIsrPartitionState(new TopicPartition("foo", 1), true).toString());
        Assertions.assertEquals((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("bar").setPartitionIndex(0).setControllerEpoch(-1).setLeader(2).setLeaderEpoch(234).setIsr(Arrays.asList(2, 3, 4)).setPartitionEpoch(567).setReplicas(Arrays.asList(2, 3, 4)).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList()).setIsNew(false).toString(), (Object)b.toLeaderAndIsrPartitionState(new TopicPartition("bar", 0), false).toString());
    }

    @Test
    public void testMergePartitionChangeRecordWithReassignmentData() {
        PartitionRegistration partition0 = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionRegistration partition1 = partition0.merge(new PartitionChangeRecord().setRemovingReplicas(Collections.singletonList(3)).setAddingReplicas(Collections.singletonList(4)).setReplicas(Arrays.asList(1, 2, 3, 4)));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{3}).setAddingReplicas(new int[]{4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).build(), (Object)partition1);
        PartitionRegistration partition2 = partition1.merge(new PartitionChangeRecord().setIsr(Arrays.asList(1, 2, 4)).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()).setReplicas(Arrays.asList(1, 2, 4)));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 4}).setIsr(new int[]{1, 2, 4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(202)).build(), (Object)partition2);
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingReplicas() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder();
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set replicas.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingIsr() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0});
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set isr.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingLeader() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0}).setIsr(new int[]{0}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{0});
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set leader.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingLeaderRecoveryState() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0}).setIsr(new int[]{0}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{0}).setLeader(Integer.valueOf(0));
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set leader recovery state.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingLeaderEpoch() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0}).setIsr(new int[]{0}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{0}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set leader epoch.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingPartitionEpoch() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0}).setIsr(new int[]{0}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{0}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0));
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set partition epoch.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderSuccess() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setIsr(new int[]{0, 1}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0));
        PartitionRegistration partitionRegistration = builder.build();
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{0, 1}), (Object)Replicas.toList((int[])partitionRegistration.replicas));
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{0, 1}), (Object)Replicas.toList((int[])partitionRegistration.isr));
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{0}), (Object)Replicas.toList((int[])partitionRegistration.removingReplicas));
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{1}), (Object)Replicas.toList((int[])partitionRegistration.addingReplicas));
        Assertions.assertEquals((int)0, (int)partitionRegistration.leader);
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERED, (Object)partitionRegistration.leaderRecoveryState);
        Assertions.assertEquals((int)0, (int)partitionRegistration.leaderEpoch);
        Assertions.assertEquals((int)0, (int)partitionRegistration.partitionEpoch);
    }

    @Test
    public void testBuilderSetsDefaultAddingAndRemovingReplicas() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0));
        PartitionRegistration partitionRegistration = builder.build();
        Assertions.assertEquals((Object)Replicas.toList((int[])Replicas.NONE), (Object)Replicas.toList((int[])partitionRegistration.removingReplicas));
        Assertions.assertEquals((Object)Replicas.toList((int[])Replicas.NONE), (Object)Replicas.toList((int[])partitionRegistration.addingReplicas));
    }

    @Property
    public void testConsistentEqualsAndHashCode(@ForAll(value="uniqueSamples") PartitionRegistration a, @ForAll(value="uniqueSamples") PartitionRegistration b) {
        if (a.equals((Object)b)) {
            Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        }
        if (a.hashCode() != b.hashCode()) {
            Assertions.assertNotEquals((Object)a, (Object)b);
        }
    }

    @Provide
    Arbitrary<PartitionRegistration> uniqueSamples() {
        return Arbitraries.of((Object[])new PartitionRegistration[]{new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(101)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERING).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{4, 5, 6}).setAddingReplicas(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{1, 2, 3}).setAddingReplicas(new int[]{4, 5, 6}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setIsr(new int[]{1, 2, 3}).setAddingReplicas(new int[]{4, 5, 6}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build()});
    }
}

