/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.HashSet;
import java.util.Optional;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class LeaderRecoveryStateTest {
    private static final byte NO_CHANGE = -1;

    @Test
    void testUniqueValues() {
        HashSet<Byte> set = new HashSet<Byte>();
        for (LeaderRecoveryState recovery : LeaderRecoveryState.values()) {
            Assertions.assertTrue((boolean)set.add(recovery.value()), (String)String.format("Value %s for election state %s has already been used", recovery.value(), recovery));
        }
    }

    @Test
    void testDoesNotContainNoChange() {
        for (LeaderRecoveryState recovery : LeaderRecoveryState.values()) {
            Assertions.assertNotEquals((byte)-1, (byte)recovery.value());
        }
    }

    @Test
    void testByteToLeaderRecoveryState() {
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERED, (Object)LeaderRecoveryState.of((byte)0));
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERING, (Object)LeaderRecoveryState.of((byte)1));
    }

    @Test
    void testLeaderRecoveryStateValue() {
        Assertions.assertEquals((int)0, (int)LeaderRecoveryState.RECOVERED.value());
        Assertions.assertEquals((int)1, (int)LeaderRecoveryState.RECOVERING.value());
    }

    @Test
    void testInvalidValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> LeaderRecoveryState.of((byte)-1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> LeaderRecoveryState.of((byte)2));
    }

    @Test
    void testOptionalInvalidValue() {
        Assertions.assertEquals(Optional.empty(), (Object)LeaderRecoveryState.optionalOf((byte)-1));
        Assertions.assertEquals(Optional.empty(), (Object)LeaderRecoveryState.optionalOf((byte)2));
    }

    @Test
    void testChangeTo() {
        LeaderRecoveryState state = LeaderRecoveryState.RECOVERED;
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERED, (Object)state.changeTo((byte)-1));
        state = state.changeTo(LeaderRecoveryState.RECOVERING.value());
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERING, (Object)state);
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERING, (Object)state.changeTo((byte)-1));
        state = state.changeTo(LeaderRecoveryState.RECOVERED.value());
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERED, (Object)state);
    }
}

