/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import org.apache.kafka.image.MetadataVersionChange;
import org.apache.kafka.image.MetadataVersionChangeException;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=40L)
public class MetadataVersionChangeTest {
    private static final Logger log = LoggerFactory.getLogger(MetadataVersionChangeTest.class);
    private static final MetadataVersionChange CHANGE_3_0_IV1_TO_3_3_IV0 = new MetadataVersionChange(MetadataVersion.IBP_3_0_IV1, MetadataVersion.IBP_3_3_IV0);
    private static final MetadataVersionChange CHANGE_3_3_IV0_TO_3_0_IV1 = new MetadataVersionChange(MetadataVersion.IBP_3_3_IV0, MetadataVersion.IBP_3_0_IV1);

    @Test
    public void testIsUpgrade() throws Throwable {
        Assertions.assertTrue((boolean)CHANGE_3_0_IV1_TO_3_3_IV0.isUpgrade());
        Assertions.assertFalse((boolean)CHANGE_3_3_IV0_TO_3_0_IV1.isUpgrade());
    }

    @Test
    public void testIsDowngrade() throws Throwable {
        Assertions.assertFalse((boolean)CHANGE_3_0_IV1_TO_3_3_IV0.isDowngrade());
        Assertions.assertTrue((boolean)CHANGE_3_3_IV0_TO_3_0_IV1.isDowngrade());
    }

    @Test
    public void testMetadataVersionChangeExceptionToString() throws Throwable {
        Assertions.assertEquals((Object)"org.apache.kafka.image.MetadataVersionChangeException: The metadata version is changing from 3.0-IV1 to 3.3-IV0", (Object)new MetadataVersionChangeException(CHANGE_3_0_IV1_TO_3_3_IV0).toString());
        Assertions.assertEquals((Object)"org.apache.kafka.image.MetadataVersionChangeException: The metadata version is changing from 3.3-IV0 to 3.0-IV1", (Object)new MetadataVersionChangeException(CHANGE_3_3_IV0_TO_3_0_IV1).toString());
    }
}

